/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.admin;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.ConfigParser;
import org.glassfish.scripting.jruby.admin.Messages;
import org.glassfish.scripting.jruby.config.JrubyContainer;
import org.glassfish.scripting.jruby.config.JrubyRuntimePool;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="jruby-container-config")
@I18n(value="jruby-container-config.command")
@Scoped(value=PerLookup.class)
public class JRubyContainerCommand
implements AdminCommand {
    @Inject(optional=true)
    JrubyContainer container;
    @Inject
    ConfigParser parser;
    @Inject
    Habitat habitat;
    @Param(name="jruby-home", optional=true)
    String jrubyHome;
    @Param(name="jruby-runtime", optional=true, shortName="runtime")
    String jrubyRuntime;
    @Param(name="jruby-runtime-min", optional=true, shortName="runtime-min")
    String jrubyRuntimeMin;
    @Param(name="jruby-runtime-max", optional=true, shortName="runtime-max")
    String jrubyRuntimeMax;
    @Param(name="show", optional=true, acceptableValues="true, false")
    String show;
    private static final int INVALID_INT = -1;
    private static final int JRUBY_RUNTIME = 0;
    private static final int JRUBY_RUNTIME_MIN = 1;
    private static final int JRUBY_RUNTIME_MAX = 2;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.container == null) {
            URL xml = this.getClass().getClassLoader().getResource("/org/glassfish/scripting/jruby/config/jruby-container-config.xml");
            try {
                this.container = (JrubyContainer)this.parser.parseContainerConfig(this.habitat, xml, JrubyContainer.class);
                String home = System.getProperty("com.sun.aas.installRoot") + File.separator + "jruby";
                if (!new File(home).exists()) {
                    home = "";
                }
                try {
                    final String home1 = home;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyContainer>(){

                        public Object run(JrubyContainer param) throws PropertyVetoException, TransactionFailure {
                            param.setJrubyHome(home1);
                            return null;
                        }
                    }, (ConfigBeanProxy)this.container);
                }
                catch (TransactionFailure e) {
                    report.failure(context.getLogger(), Messages.format("jruby-config.failed", new Object[0]), (Throwable)e);
                }
            }
            catch (IOException e) {
                report.failure(context.logger, "Failed to create <jruby-container> config element", (Throwable)e);
            }
        }
        if (this.show != null && Boolean.valueOf(this.show).booleanValue()) {
            report.setActionDescription("current.config");
            report.getTopMessagePart().addChild().setMessage("jruby-home=" + this.container.getJrubyHome());
            report.getTopMessagePart().addChild().setMessage("jruby-runtime=" + this.container.getJrubyRuntimePool().getJrubyRuntime());
            report.getTopMessagePart().addChild().setMessage("jruby-runtime-min=" + this.container.getJrubyRuntimePool().getJrubyRuntimeMin());
            report.getTopMessagePart().addChild().setMessage("jruby-runtime-max=" + this.container.getJrubyRuntimePool().getJrubyRuntimeMax());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        this.updateJRubyHome(context);
        this.updateJRubyRuntimePool(context);
    }

    private void updateJRubyHome(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jrubyHome == null) {
            return;
        }
        if (!new File(this.jrubyHome).exists()) {
            report.failure(context.logger, Messages.format("jruby-home.notexist", this.jrubyHome));
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyContainer>(){

                public Object run(JrubyContainer param) throws PropertyVetoException, TransactionFailure {
                    param.setJrubyHome(JRubyContainerCommand.this.jrubyHome);
                    return null;
                }
            }, (ConfigBeanProxy)this.container);
            report.getTopMessagePart().setMessage(Messages.format("jruby-home.success", this.jrubyHome));
        }
        catch (TransactionFailure e) {
            report.failure(context.getLogger(), Messages.format("jruby-home.failure", new Object[0]), (Throwable)e);
        }
    }

    private void updateJRubyRuntimePool(AdminCommandContext context) {
        if (this.jrubyRuntime == null && this.jrubyRuntimeMin == null && this.jrubyRuntimeMax == null) {
            return;
        }
        ActionReport report = context.getActionReport();
        int value = this.toInt("jruby-runtime", this.jrubyRuntime, context);
        final int[] settings = new int[]{value, value = this.toInt("jruby-runtime-min", this.jrubyRuntimeMin, context), value = this.toInt("jruby-runtime-max", this.jrubyRuntimeMax, context)};
        JrubyRuntimePool pool = this.container.getJrubyRuntimePool();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyRuntimePool>(){

                public Object run(JrubyRuntimePool param) throws PropertyVetoException, TransactionFailure {
                    if (settings[0] > 0) {
                        param.setJrubyRuntime(settings[0]);
                    }
                    if (settings[1] > 0) {
                        param.setJrubyRuntimeMin(settings[1]);
                    }
                    if (settings[2] > 0) {
                        param.setJrubyRuntimeMax(settings[2]);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)pool);
            report.getTopMessagePart().setMessage(Messages.format("jruby-runtime-pool.success", pool.getJrubyRuntime(), pool.getJrubyRuntimeMin(), pool.getJrubyRuntimeMax()));
        }
        catch (TransactionFailure e) {
            context.logger.log(Level.SEVERE, "jruby-runtime-pool.failure", e);
        }
    }

    private int toInt(String property, String value, AdminCommandContext context) {
        if (value == null) {
            return -1;
        }
        try {
            return Integer.valueOf(this.jrubyRuntime, 10);
        }
        catch (NumberFormatException e) {
            context.getActionReport().failure(context.getLogger(), Messages.format("invalid.number", property, value), (Throwable)e);
            return -1;
        }
    }
}

