# Merb init file.
# Thanks to Yehuda Katz for coding help

#translate merb/Glassfish log levels

#load required files
require 'rubygems'
gem 'merb-core', '>= 0'
require 'merb-core'
require 'rack/handler/grizzly'
require 'rack/adapter/merb'
Merb::Rack::Adapter.register %w{grizzly}, :GrizzlyMerb

#Figure out the correct log level to use
case $glassfish_log_level
  when "SEVERE" then log_level = :fatal
  when "WARNING" then log_level = :error
  when "INFO" then log_level = :warn
  when "CONFIG" then log_level = :info
  when "FINE" then log_level = :info
  when "FINER" then log_level = :debug
  when "FINEST" then log_level = :debug
end

# Set up the server and log stream, supress merb signal trapping
Merb.disable(:signals)


# Start merb
Merb.start({
   :environment => $rackEnv, 
   :merb_root => $glassfish_appRoot,
   :adapter => "grizzly",
   :log_level => log_level,
   :path_prefix => $root == "/"?
           nil:$root
})
