/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.web.osgi.JavaEEUndeploymentRequest;
import org.glassfish.web.osgi.OSGiBundleArchive;
import org.glassfish.web.osgi.OSGiDeploymentContextImpl;
import org.glassfish.web.osgi.OSGiWarHandler;
import org.glassfish.web.osgi.OSGiWebContainer;
import org.osgi.framework.Bundle;

public class JavaEEDeploymentRequest {
    private static final Logger logger = Logger.getLogger(JavaEEUndeploymentRequest.class.getPackage().getName());
    private ActionReport reporter;
    private Bundle b;
    private boolean dirDeployment;
    private Deployment deployer;
    private ArchiveFactory archiveFactory;
    private ServerEnvironmentImpl env;
    private ReadableArchive archive;
    private OSGiDeploymentContextImpl dc;

    public JavaEEDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        this.deployer = deployer;
        this.archiveFactory = archiveFactory;
        this.env = env;
        this.reporter = reporter;
        this.b = b;
    }

    public OSGiWebContainer.OSGiApplicationInfo execute() {
        try {
            this.prepare();
        }
        catch (Exception e) {
            this.reporter.failure(logger, "Failed while preparing to deploy bundle " + this.b, (Throwable)e);
            return null;
        }
        return this.deploy();
    }

    private void prepare() throws Exception {
        this.archive = new OSGiBundleArchive(this.b);
        OpsParams opsParams = this.getDeployParams(this.archive);
        this.dc = new OSGiDeploymentContextImpl(this.reporter, logger, this.archive, opsParams, (ServerEnvironment)this.env, this.b);
        File file = JavaEEDeploymentRequest.makeFile(this.dc.getSource());
        boolean bl = this.dirDeployment = file != null && file.isDirectory();
        if (!this.dirDeployment) {
            this.expandIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiWebContainer.OSGiApplicationInfo deploy() {
        OSGiWebContainer.OSGiApplicationInfo oSGiApplicationInfo;
        block12: {
            ApplicationInfo appInfo;
            block10: {
                OSGiWebContainer.OSGiApplicationInfo oSGiApplicationInfo2;
                block11: {
                    appInfo = null;
                    try {
                        appInfo = this.deployer.deploy((ExtendedDeploymentContext)this.dc);
                        if (appInfo == null) break block10;
                        OSGiWebContainer.OSGiApplicationInfo osgiAppInfo = new OSGiWebContainer.OSGiApplicationInfo();
                        osgiAppInfo.appInfo = appInfo;
                        osgiAppInfo.isDirectoryDeployment = this.dirDeployment;
                        osgiAppInfo.bundle = this.b;
                        oSGiApplicationInfo2 = osgiAppInfo;
                        Object var5_5 = null;
                        if (this.dirDeployment || appInfo != null) break block11;
                    }
                    catch (Throwable throwable) {
                        block13: {
                            Object var5_7 = null;
                            if (this.dirDeployment || appInfo != null) break block13;
                            try {
                                File dir = this.dc.getSourceDir();
                                assert (dir.isDirectory());
                                FileUtils.whack((File)dir);
                                logger.logp(Level.INFO, "JavaEEDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                            }
                            catch (Exception e2) {
                                logger.logp(Level.WARNING, "JavaEEDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        File dir = this.dc.getSourceDir();
                        assert (dir.isDirectory());
                        FileUtils.whack((File)dir);
                        logger.logp(Level.INFO, "JavaEEDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                    }
                    catch (Exception e2) {
                        logger.logp(Level.WARNING, "JavaEEDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                    }
                }
                return oSGiApplicationInfo2;
            }
            logger.logp(Level.INFO, "JavaEEDeploymentRequest", "deploy", "failed to deploy {0}", new Object[]{this.b});
            this.reporter.failure(logger, "failed to deploy " + this.b);
            oSGiApplicationInfo = null;
            Object var5_6 = null;
            if (this.dirDeployment || appInfo != null) break block12;
            try {
                File dir = this.dc.getSourceDir();
                assert (dir.isDirectory());
                FileUtils.whack((File)dir);
                logger.logp(Level.INFO, "JavaEEDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
            }
            catch (Exception e2) {
                logger.logp(Level.WARNING, "JavaEEDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
            }
        }
        return oSGiApplicationInfo;
    }

    private void expandIfNeeded() throws IOException {
        File file = JavaEEDeploymentRequest.makeFile(this.dc.getSource());
        boolean bl = this.dirDeployment = file != null && file.isDirectory();
        if (this.dirDeployment) {
            logger.logp(Level.FINE, "JavaEEDeploymentRequest", "expandIfNeeded", "Archive is already expanded at = {0}", new Object[]{file});
            return;
        }
        File tmpFile = File.createTempFile("osgiapp", "");
        tmpFile.delete();
        tmpFile = new File(tmpFile.getAbsolutePath());
        tmpFile.deleteOnExit();
        if (!tmpFile.mkdirs()) {
            throw new IOException("Not able to expand " + this.archive.getName() + " in " + tmpFile);
        }
        WritableArchive targetArchive = this.archiveFactory.createArchive(tmpFile);
        new OSGiWarHandler().expand(this.archive, targetArchive, (DeploymentContext)this.dc);
        logger.logp(Level.INFO, "JavaEEDeploymentRequest", "expand", "Expanded at {0}", new Object[]{targetArchive.getURI()});
        this.archive = this.archiveFactory.openArchive(tmpFile);
        this.dc.setSource(this.archive);
    }

    public static File makeFile(ReadableArchive a) {
        try {
            return new File(a.getURI());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private OpsParams getDeployParams(ReadableArchive archive) throws Exception {
        DeployCommandParameters parameters = new DeployCommandParameters();
        parameters.name = archive.getName();
        try {
            parameters.contextroot = archive.getManifest().getMainAttributes().getValue("Web-ContextPath");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (parameters.contextroot == null || parameters.contextroot.length() == 0) {
            throw new Exception("Web-ContextPath manifest header is mandatory");
        }
        parameters.enabled = Boolean.TRUE;
        parameters.origin = OpsParams.Origin.deploy;
        parameters.force = true;
        return parameters;
    }
}

