/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEvent;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEventListener;
import com.sun.appserv.jdbc.DataSource;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.TransactionHelperImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.glassfish.internal.api.Globals;
import org.glassfish.persistence.common.I18NHelper;

public class SunTransactionHelper
extends TransactionHelperImpl
implements ConnectorNamingEventListener {
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)SunTransactionHelper.class.getClassLoader());
    private static List<PersistenceManagerFactory> pmf_list;
    private static final Object pmf_listSyncObject;
    private final List<ApplicationLifeCycleEventListener> applicationLifeCycleEventListeners = new ArrayList<ApplicationLifeCycleEventListener>();

    SunTransactionHelper() {
    }

    public Transaction getTransaction() {
        try {
            return TransactionManagerFinder.appserverTM.getTransaction();
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    public UserTransaction getUserTransaction() {
        try {
            InitialContext ctx = (InitialContext)Class.forName("javax.naming.InitialContext").newInstance();
            return (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        Object object = pmf_listSyncObject;
        synchronized (object) {
            int i = pmf_list.indexOf(pmf);
            if (i == -1) {
                pmf_list.add(pmf);
                return pmf;
            }
            return pmf_list.get(i);
        }
    }

    public String getDDLNamePrefix(Object info) {
        return DeploymentHelper.getDDLNamePrefix(info);
    }

    public Connection getNonTransactionalConnection(Object resource, String username, String password) throws SQLException {
        Connection rc = null;
        if (resource instanceof DataSource) {
            DataSource ds = (DataSource)resource;
            rc = username == null ? ds.getNonTxConnection() : ds.getNonTxConnection(username, password);
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.SunTransactionHelper.wrongdatasourcetype", (String)resource.getClass().getName()));
        }
        return rc;
    }

    public TransactionManager getLocalTransactionManager() {
        try {
            return TransactionManagerFinder.appserverTM;
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApplicationLifeCycleEventListener(ApplicationLifeCycleEventListener listener) {
        List<ApplicationLifeCycleEventListener> list = this.applicationLifeCycleEventListeners;
        synchronized (list) {
            this.applicationLifeCycleEventListeners.add(listener);
        }
    }

    public void connectorNamingEventPerformed(ConnectorNamingEvent event) {
        if (event.getEventType() == 0) {
            String dsName = ConnectorsUtil.getPMJndiName((String)event.getJndiName());
            this.cleanUpResources(dsName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpResources(String name) {
        Object object = pmf_listSyncObject;
        synchronized (object) {
            Iterator<PersistenceManagerFactory> it = pmf_list.iterator();
            while (it.hasNext()) {
                PersistenceManagerFactory pmf = it.next();
                if (!pmf.getConnectionFactoryName().equals(name)) continue;
                it.remove();
            }
        }
    }

    static {
        pmf_listSyncObject = new Object();
        SunTransactionHelper helper = new SunTransactionHelper();
        EJBHelper.registerTransactionHelper(helper);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)Globals.getDefaultHabitat().getByContract(ConnectorRuntime.class);
        connectorRuntime.registerConnectorNamingEventListener((ConnectorNamingEventListener)helper);
        pmf_list = new ArrayList<PersistenceManagerFactory>();
    }

    private static class TransactionManagerFinder {
        private static final String AS_TM_NAME = "java:appserver/TransactionManager";
        static TransactionManager appserverTM = null;

        private TransactionManagerFinder() {
        }

        static {
            try {
                appserverTM = (TransactionManager)new InitialContext().lookup(AS_TM_NAME);
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(e.getMessage());
            }
        }
    }
}

