/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;

public class VersionCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(VersionCommand.class);

    public VersionCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        VersionCommand.addOption(opts, "verbose", '\u0000', "BOOLEAN", false, "false");
        VersionCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
        this.processProgramOptions();
    }

    protected int executeCommand() throws CommandException {
        try {
            RemoteCommand cmd = new RemoteCommand("version", this.programOpts, this.env);
            if (this.getBooleanOption("verbose")) {
                cmd.execute("version", "--verbose");
            } else {
                cmd.execute("version");
            }
        }
        catch (Exception e) {
            this.printRemoteException(e);
            this.invokeLocal();
        }
        return 0;
    }

    private void invokeLocal() {
        String fv = Version.getFullVersion();
        String cn = Version.class.getName();
        String msg = strings.get("version.local", new Object[]{cn, fv});
        logger.printMessage(msg);
    }

    private void printRemoteException(Exception e) {
        String host = this.programOpts.getHost();
        String port = this.programOpts.getPort() + "";
        String msg = strings.get("remote.version.failed", new Object[]{host, port});
        logger.printMessage(msg);
        logger.printDebugMessage(e.getMessage());
    }
}

