/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.ImplementorCacheDelegate;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.Tie;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.rpc.server.ServiceLifecycle;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.webservices.ServletImplInvocationHandler;
import org.glassfish.webservices.WebServiceContractImpl;

public class ImplementorCacheDelegateImpl
extends ImplementorCacheDelegate {
    private Hashtable implementorCache_;
    private ServletContext servletContext_;
    private JaxRpcObjectFactory rpcFactory_;

    public ImplementorCacheDelegateImpl(ServletConfig servletConfig) {
        this.servletContext_ = servletConfig.getServletContext();
        this.implementorCache_ = new Hashtable();
        this.rpcFactory_ = JaxRpcObjectFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementor getImplementorFor(RuntimeEndpointInfo targetEndpoint) {
        Implementor implementor = null;
        try {
            RuntimeEndpointInfo runtimeEndpointInfo = targetEndpoint;
            synchronized (runtimeEndpointInfo) {
                implementor = (Implementor)this.implementorCache_.get(targetEndpoint);
                if (implementor == null) {
                    implementor = this.createImplementor(targetEndpoint);
                    this.implementorCache_.put(targetEndpoint, implementor);
                }
            }
            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
            InvocationManager invManager = wscImpl.getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            ((EJBInvocation)inv).setWebServiceTie((Object)implementor.getTie());
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException();
            re.initCause(t);
            throw re;
        }
        return implementor;
    }

    public void releaseImplementor(RuntimeEndpointInfo targetEndpoint, Implementor implementor) {
    }

    public void destroy() {
        for (Implementor implementor : this.implementorCache_.values()) {
            try {
                implementor.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.implementorCache_.clear();
    }

    private Implementor createImplementor(RuntimeEndpointInfo targetEndpoint) throws Exception {
        Tie tie = (Tie)targetEndpoint.getTieClass().newInstance();
        Class seiClass = targetEndpoint.getRemoteInterface();
        Class implClass = targetEndpoint.getImplementationClass();
        Remote servant = null;
        if (seiClass.isAssignableFrom(implClass)) {
            servant = (Remote)implClass.newInstance();
        } else {
            Class[] classArray;
            Object implInstance = implClass.newInstance();
            ServletImplInvocationHandler handler = new ServletImplInvocationHandler(implInstance);
            boolean implementsLifecycle = ServiceLifecycle.class.isAssignableFrom(implClass);
            if (implementsLifecycle) {
                Class[] classArray2 = new Class[2];
                classArray2[0] = seiClass;
                classArray = classArray2;
                classArray2[1] = ServiceLifecycle.class;
            } else {
                Class[] classArray3 = new Class[1];
                classArray = classArray3;
                classArray3[0] = seiClass;
            }
            Class[] proxyInterfaces = classArray;
            servant = (Remote)Proxy.newProxyInstance(implClass.getClassLoader(), proxyInterfaces, (InvocationHandler)handler);
        }
        tie.setTarget(servant);
        Implementor implementor = this.rpcFactory_.createImplementor(this.servletContext_, tie);
        implementor.init();
        return implementor;
    }
}

