/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.util.NullVisitor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class MethodCopier
extends ClassAdapter {
    private ClassReader fromClass;
    private Iterable<MethodInfo> methods;

    public MethodCopier(ClassReader fromClass, ClassVisitor toClass, Iterable<MethodInfo> methods) {
        super(toClass);
        this.fromClass = fromClass;
        this.methods = methods;
    }

    protected MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private MethodInfo getMethodInfo(String name, String desc) {
        Iterator<MethodInfo> itr = this.methods.iterator();
        while (itr.hasNext()) {
            MethodInfo mi = itr.next();
            if (!mi.name.equals(name) || !mi.desc.equals(desc)) continue;
            itr.remove();
            return mi;
        }
        return null;
    }

    @Override
    public void visitEnd() {
        this.fromClass.accept(new ClassVisitor(){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new NullVisitor();
            }

            @Override
            public void visitAttribute(Attribute attr) {
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return null;
            }

            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodInfo mi = MethodCopier.this.getMethodInfo(name, desc);
                if (mi != null) {
                    return MethodCopier.this.addMethod(mi.newAccess, mi.newName, desc, signature, exceptions);
                }
                return null;
            }

            @Override
            public void visitOuterClass(String owner, String name, String desc) {
            }

            @Override
            public void visitSource(String source, String debug) {
            }
        }, 0);
        super.visitEnd();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.MethodCopier <class-1> <class-2>");
            System.exit(1);
        }
        Class<?> clazz = Class.forName(args[0]);
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<MethodInfo> miList = new ArrayList<MethodInfo>();
        for (Method m : methods) {
            if (m.getName().equals("<clinit>")) continue;
            MethodInfo mi = new MethodInfo(m.getName(), Type.getMethodDescriptor(m), m.getName(), m.getModifiers());
            miList.add(mi);
        }
        args[0] = args[0].replace('.', '/');
        args[1] = args[1].replace('.', '/');
        FileInputStream fis1 = new FileInputStream(args[0] + ".class");
        ClassReader reader1 = new ClassReader(new BufferedInputStream(fis1));
        FileInputStream fis2 = new FileInputStream(args[1] + ".class");
        ClassReader reader2 = new ClassReader(new BufferedInputStream(fis2));
        FileOutputStream fos = new FileOutputStream(args[1] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        MethodCopier copier = new MethodCopier(reader1, writer, miList);
        InstrumentUtils.accept(reader2, copier);
        fos.write(writer.toByteArray());
    }

    public static class MethodInfo {
        String name;
        String desc;
        String newName;
        int newAccess;

        public MethodInfo(String name, String desc, String newName, int newAccess) {
            this.name = name;
            this.desc = desc;
            this.newName = newName;
            this.newAccess = newAccess;
        }
    }
}

