/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class DomainCredentials
implements Credentials {
    private String adminUserName = null;
    private String adminPassword = null;
    private File passwordFile = null;
    private String masterPassword = "changeit";
    private static final Logger logger = LogService.getLogger();
    private static final StringManager stringManager = StringManager.getManager(DomainCredentials.class);

    public void setAdminUserName(String s) {
        this.adminUserName = s;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminPassword(String s) {
        this.adminPassword = s;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setMasterPassword(String s) {
        this.masterPassword = s;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public String getPasswordFile() {
        if (this.passwordFile == null) {
            try {
                this.passwordFile = File.createTempFile("ugpw", null);
                FileWriter writer = new FileWriter(this.passwordFile);
                if (this.getAdminPassword() != null) {
                    writer.write("AS_ADMIN_PASSWORD=" + this.getAdminPassword() + "\n");
                    writer.write("AS_ADMIN_ADMINPASSWORD=" + this.getAdminPassword() + "\n");
                }
                if (this.getMasterPassword() != null) {
                    writer.write("AS_ADMIN_MASTERPASSWORD=" + this.getMasterPassword() + "\n");
                }
                writer.close();
            }
            catch (IOException ioe) {
                logger.severe(stringManager.getString("upgrade.common.general_exception") + " " + ioe.getMessage());
            }
        }
        return this.passwordFile.getAbsolutePath();
    }

    public void deletePasswordFile() {
        if (this.passwordFile != null) {
            this.passwordFile.delete();
        }
    }
}

