/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.util.i18n.StringManager;

public class DomainsProcessor {
    private CommonInfoModel commonInfo;
    private static final StringManager stringManager = StringManager.getManager(DomainsProcessor.class);
    private boolean domainStarted = false;

    public DomainsProcessor(CommonInfoModel ci) {
        this.commonInfo = ci;
    }

    public int startDomain(String domainName) throws HarnessException {
        int exitValue = 0;
        if (!this.domainStarted) {
            exitValue = Commands.startDomain(domainName, this.commonInfo);
            if (exitValue == 0) {
                this.domainStarted = true;
            } else {
                throw new HarnessException(stringManager.getString("upgrade.common.domain_start_failed", (Object)domainName));
            }
        }
        return exitValue;
    }

    public int stopDomain(String domainName) throws HarnessException {
        int exitValue = 0;
        if (this.domainStarted) {
            exitValue = Commands.stopDomain(domainName, this.commonInfo);
            if (exitValue == 0) {
                this.domainStarted = false;
            } else {
                throw new HarnessException(stringManager.getString("upgrade.common.domain_stop_failed", (Object)domainName));
            }
        }
        return exitValue;
    }
}

