/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcherForward;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

public final class ApplicationDispatcher
implements RequestDispatcher {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(ApplicationDispatcher.class.getName());
    private Boolean crossContextFlag = null;
    private Context context = null;
    private int debug = 0;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Wrapper wrapper = null;

    public ApplicationDispatcher(Wrapper wrapper, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        if (log.isLoggable(Level.FINE)) {
            log.fine("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name);
        }
    }

    public String getInfo() {
        return info;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response, DispatcherType.FORWARD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        boolean isCommit;
        if (!(DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherType.ERROR.equals((Object)dispatcherType) || DispatcherType.ASYNC.equals((Object)dispatcherType))) {
            throw new IllegalArgumentException("Illegal dispatcher type");
        }
        boolean bl = isCommit = DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherType.ERROR.equals((Object)dispatcherType);
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedDispatch dp = new PrivilegedDispatch(request, response, dispatcherType);
                AccessController.doPrivileged(dp);
                if (!isCommit) return;
                ApplicationDispatcherForward.commit((HttpServletRequest)request, (HttpServletResponse)response, this.context, this.wrapper);
                return;
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (!(e instanceof ServletException)) throw (IOException)e;
                throw (ServletException)e;
            }
        } else {
            this.doDispatch(request, response, dispatcherType);
            if (!isCommit) return;
            ApplicationDispatcherForward.commit((HttpServletRequest)request, (HttpServletResponse)response, this.context, this.wrapper);
        }
    }

    private void doDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        if (!DispatcherType.ASYNC.equals((Object)dispatcherType)) {
            if (response.isCommitted()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  Forward on committed response --> ISE");
                }
                throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
            }
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  Forward resetBuffer() returned ISE: " + e);
                }
                throw e;
            }
        }
        State state = new State(request, response, dispatcherType);
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        if (hrequest == null || hresponse == null) {
            this.processRequest(hrequest, hresponse, state);
        } else if (this.servletPath == null && this.pathInfo == null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state);
            wrequest.recycle();
            this.unwrapRequest(state);
        } else {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            if (DispatcherType.FORWARD.equals((Object)dispatcherType) && hrequest.getAttribute("javax.servlet.forward.request_uri") == null || DispatcherType.ASYNC.equals((Object)dispatcherType) && hrequest.getAttribute("javax.servlet.async.request_uri") == null) {
                wrequest.initSpecialAttributes(hrequest.getRequestURI(), hrequest.getContextPath(), hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString());
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response, state);
            wrequest.recycle();
            this.unwrapRequest(state);
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        if (request != null) {
            if (state.dispatcherType != DispatcherType.ERROR) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
                this.invoke(state.outerRequest, response, state);
            } else {
                this.invoke(state.outerRequest, response, state);
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, DispatcherType.INCLUDE);
        this.wrapResponse(state);
        if (this.name != null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            try {
                this.invoke(state.outerRequest, state.outerResponse, state);
            }
            finally {
                wrequest.recycle();
                this.unwrapRequest(state);
                this.unwrapResponse(state);
            }
        }
        ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
        wrequest.initSpecialAttributes(this.requestURI, this.context.getPath(), this.servletPath, this.pathInfo, this.queryString);
        wrequest.setQueryParams(this.queryString);
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        try {
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
        finally {
            wrequest.recycle();
            this.unwrapRequest(state);
            this.unwrapResponse(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        boolean crossContext = false;
        if (this.crossContextFlag != null && this.crossContextFlag.booleanValue()) {
            crossContext = true;
        }
        if (crossContext) {
            this.context.getManager().lockSession(request);
        }
        try {
            if (crossContext) {
                this.context.getManager().preRequestDispatcherProcess(request, response);
            }
            this.doInvoke(request, response, crossContext, state);
            if (crossContext) {
                this.context.getManager().postRequestDispatcherProcess(request, response);
            }
        }
        finally {
            if (crossContext) {
                this.context.getManager().unlockSession(request);
            }
            this.crossContextFlag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(ServletRequest request, ServletResponse response, boolean crossContext, State state) throws IOException, ServletException {
        ClassLoader oldCCL = null;
        if (crossContext) {
            oldCCL = Thread.currentThread().getContextClassLoader();
            ClassLoader contextClassLoader = this.context.getLoader().getClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        HttpServletRequest hrequest = null;
        hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = null;
        hresponse = (HttpServletResponse)response;
        Servlet servlet = null;
        IOException ioException = null;
        ServletException servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.log(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            if (hresponse != null) {
                long available = this.wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hresponse.setDateHeader("Retry-After", available);
                }
                hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            }
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), StandardWrapper.getRootCause(e));
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
        ApplicationFilterChain filterChain = factory.createFilterChain(request, this.wrapper, servlet);
        InstanceSupport support = ((StandardWrapper)this.wrapper).getInstanceSupport();
        RequestFacade requestFacade = state.wrapRequest.getRequestFacade();
        try {
            String jspFile = this.wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", jspFile);
            }
            support.fireInstanceEvent(InstanceEvent.EventType.BEFORE_DISPATCH_EVENT, servlet, request, response);
            if (servlet != null) {
                requestFacade.incrementDispatchDepth();
                if (requestFacade.isMaxDispatchDepthReached()) {
                    throw new ServletException(sm.getString("applicationDispatcher.maxDispatchDepthReached", new Object[]{org.apache.catalina.connector.Request.getMaxDispatchDepth()}));
                }
                if (filterChain != null) {
                    filterChain.setRequestFacade(requestFacade);
                    filterChain.setWrapper((StandardWrapper)this.wrapper);
                    filterChain.doFilter(request, response);
                } else {
                    ((StandardWrapper)this.wrapper).service(request, response, servlet, requestFacade);
                }
            }
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
        }
        catch (ClientAbortException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            ioException = e;
        }
        catch (IOException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            ioException = e;
        }
        catch (UnavailableException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof ClientAbortException)) {
                this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            runtimeException = e;
        }
        finally {
            requestFacade.decrementDispatchDepth();
        }
        try {
            if (filterChain != null) {
                filterChain.release();
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, sm.getString("standardWrapper.releaseFilters", this.wrapper.getName()), e);
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        if (oldCCL != null) {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        } else {
            log.info("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "] " + message, t, 2);
        } else {
            log.log(Level.WARNING, "ApplicationDispatcher[" + this.context.getPath() + "]: " + message, t);
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !"org.apache.catalina.servlets.InvokerHttpRequest".equals(current.getClass().getName()) && current instanceof ServletRequestWrapper && !(current instanceof ApplicationHttpRequest)) {
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        if (!(current instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request not of type HTTP");
        }
        HttpServletRequest hcurrent = (HttpServletRequest)current;
        boolean crossContext = !this.context.getPath().equals(hcurrent.getContextPath());
        this.crossContextFlag = crossContext;
        ApplicationHttpRequest wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext, state.dispatcherType);
        if (previous == null) {
            state.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest(wrapper);
        }
        state.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && current instanceof ServletResponseWrapper && !(current instanceof ApplicationHttpResponse) && !(current instanceof ApplicationResponse) && !(current instanceof Response)) {
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        ServletResponseWrapper wrapper = null;
        wrapper = current instanceof ApplicationHttpResponse || current instanceof HttpResponse || current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, DispatcherType.INCLUDE.equals((Object)state.dispatcherType)) : new ApplicationResponse(current, DispatcherType.INCLUDE.equals((Object)state.dispatcherType));
        if (previous == null) {
            state.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse(wrapper);
        }
        state.wrapResponse = wrapper;
        return wrapper;
    }

    protected class PrivilegedDispatch
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;
        private DispatcherType dispatcherType;

        PrivilegedDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.request = request;
            this.response = response;
            this.dispatcherType = dispatcherType;
        }

        public Object run() throws Exception {
            ApplicationDispatcher.this.doDispatch(this.request, this.response, this.dispatcherType);
            return null;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    private class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ApplicationHttpRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        DispatcherType dispatcherType;

        State(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.dispatcherType = dispatcherType;
        }
    }
}

