/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.migration.thrasher2;

import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class TransactionState
implements Externalizable {
    static final long serialVersionUID = 4438769866522991889L;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final int COMMITTED = 6;
    public static final int ROLLEDBACK = 7;
    public static final int LAST = 7;
    private static final String[] names = new String[]{"CREATED", "STARTED", "FAILED", "INCOMPLETE", "COMPLETE", "PREPARED", "COMMITED", "ROLLEDBACK"};
    private JMQXid xid = null;
    private int state = 0;
    private String user = null;
    private String clientID = null;
    private String connectionString = null;
    private transient ConnectionUID connectionUID = null;
    private static transient JMQXid EMPTY_JMQXID = new JMQXid();

    public TransactionState() {
        this.state = 0;
    }

    public TransactionState(TransactionState transactionState) {
        this.xid = new JMQXid(transactionState.xid);
        this.state = transactionState.state;
        this.user = transactionState.user;
        this.clientID = transactionState.clientID;
        this.connectionString = transactionState.connectionString;
        this.connectionUID = transactionState.connectionUID;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("xid", this.xid == null ? "none" : this.xid.toString());
        hashtable.put("state", names[this.state]);
        hashtable.put("user", this.user == null ? "none" : this.user);
        hashtable.put("connectionString", this.connectionString == null ? "none" : this.connectionString);
        hashtable.put("connectionUID", this.connectionUID == null ? "null" : this.connectionUID.toString());
        hashtable.put("clientID", this.clientID == null ? "none" : this.clientID);
        return hashtable;
    }

    public void setState(int n) throws BrokerException {
        if (n < 0 || n > 7) {
            throw new BrokerException("Illegal state " + n + ". Should be between " + 0 + " and " + 7 + " inclusive.");
        }
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(JMQXid jMQXid) {
        this.xid = jMQXid;
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setClientID(String string) {
        this.clientID = string;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionString(String string) {
        this.connectionString = string;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionUID(ConnectionUID connectionUID) {
        this.connectionUID = connectionUID;
    }

    public ConnectionUID getConnectionUID() {
        return this.connectionUID;
    }

    public int nextState(int n, Integer n2) throws BrokerException {
        switch (n) {
            case 44: {
                if (!(TransactionState.isFlagSet(0, n2) ? this.state == 0 || this.state == 4 || this.state == 1 : (TransactionState.isFlagSet(0x200000, n2) ? this.state == 1 || this.state == 4 : TransactionState.isFlagSet(0x8000000, n2) && (this.state == 3 || this.state == 1)))) break;
                return 1;
            }
            case 58: {
                if (TransactionState.isFlagSet(0x2000000, n2)) {
                    if (this.state != 1 && this.state != 3) break;
                    return 3;
                }
                if (TransactionState.isFlagSet(0x20000000, n2)) {
                    if (this.state != 1 && this.state != 3 && this.state != 2) break;
                    return 2;
                }
                if (!TransactionState.isFlagSet(0x4000000, n2) && !TransactionState.isFlagSet(0x40000000, n2) || this.state != 1 && this.state != 3 && this.state != 4) break;
                return 4;
            }
            case 56: {
                if (this.state != 4 && this.state != 5) break;
                return 5;
            }
            case 46: {
                if (!(TransactionState.isFlagSet(0x40000000, n2) ? this.state == 4 || this.state == 6 : this.state == 5 || this.state == 6)) break;
                return 6;
            }
            case 48: {
                if (this.state == 4 || this.state == 3) {
                    return 7;
                }
                if (this.state == 5) {
                    return 7;
                }
                if (this.state != 2 && this.state != 7) break;
                return 7;
            }
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = PacketType.getString(n);
        objectArray[1] = TransactionState.xaFlagToString(n2);
        objectArray[2] = TransactionState.toString(this.state);
        Object[] objectArray2 = objectArray;
        throw new BrokerException(Globals.getBrokerResources().getString("B4132", objectArray2));
    }

    public static int remoteTransactionNextState(TransactionState transactionState, int n) throws BrokerException {
        int n2 = transactionState.getState();
        switch (n) {
            case 6: {
                if (n2 != 5 && n2 != 6) break;
                return 6;
            }
            case 7: {
                if (n2 != 5 && n2 != 7) break;
                return 7;
            }
        }
        throw new BrokerException("Transaction state " + TransactionState.toString(n2) + " can not transit to state " + TransactionState.toString(n));
    }

    public static boolean isFlagSet(int n, Integer n2) {
        if (n2 == null) {
            return n == 0;
        }
        if (n == 0 || n2 == 0) {
            return n == n2;
        }
        return (n2 & n) == n;
    }

    public static String toString(int n) {
        if (n < 0 || n > 7) {
            return "UNKNOWN(" + n + ")";
        }
        return names[n] + "(" + n + ")";
    }

    public static String xaFlagToString(Integer n) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        if (n == null) {
            return "null";
        }
        stringBuffer.append("0x" + Integer.toHexString(n) + ":");
        if (TransactionState.isFlagSet(0, n)) {
            stringBuffer.append("TMNOFLAGS");
            return stringBuffer.toString();
        }
        if (TransactionState.isFlagSet(0x800000, n)) {
            stringBuffer.append("TMENDRSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x20000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMFAIL");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x200000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMJOIN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x40000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMONEPHASE");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x8000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMRESUME");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x1000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSTARTSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x4000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUCCESS");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x2000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUSPEND");
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("???");
        }
        return stringBuffer.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xid = JMQXid.read(objectInput);
        this.state = objectInput.readInt();
        this.user = (String)objectInput.readObject();
        this.clientID = (String)objectInput.readObject();
        this.connectionString = (String)objectInput.readObject();
        this.connectionUID = null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.xid == null) {
            EMPTY_JMQXID.write(objectOutput);
        } else {
            this.xid.write(objectOutput);
        }
        objectOutput.writeInt(this.state);
        objectOutput.writeObject(this.user);
        objectOutput.writeObject(this.clientID);
        objectOutput.writeObject(this.connectionString);
    }

    public String toString() {
        if (this.xid == null) {
            return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state);
        }
        return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + ":xid=" + this.xid.toString();
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            com.sun.messaging.jmq.jmsserver.data.TransactionState transactionState = new com.sun.messaging.jmq.jmsserver.data.TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
            transactionState.setXid(this.xid);
            transactionState.setState(this.state);
            transactionState.setUser(this.user);
            transactionState.setClientID(this.clientID);
            transactionState.setConnectionString(this.connectionString);
            return transactionState;
        }
        catch (BrokerException brokerException) {
            brokerException.printStackTrace();
            return null;
        }
    }
}

