/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class PauseHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PauseHandler.getDEBUG();

    public PauseHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Pausing: " + hashtable);
        }
        String string = (String)hashtable.get("JMQPauseTarget");
        String string2 = (String)hashtable.get("JMQServiceName");
        String string3 = (String)hashtable.get("JMQDestination");
        Integer n = (Integer)hashtable.get("JMQDestType");
        Integer n2 = (Integer)hashtable.get("JMQDestState");
        int n3 = 200;
        String string4 = null;
        assert (string2 == null || string3 == null);
        if (string == null) {
            string = "JMQServiceName";
        }
        try {
            if ("JMQServiceName".equals(string)) {
                if (string2 == null) {
                    this.logger.log(8, "B1252");
                } else {
                    this.logger.log(8, "B1124", (Object)string2);
                }
                PauseHandler.pauseService(true, string2);
            } else if ("JMQDestination".equals(string)) {
                int n4;
                this.logger.log(8, "B1125", (Object)string3);
                int n5 = n4 = n2 == null ? 3 : n2;
                if (string3 == null) {
                    Iterator iterator = Destination.getAllDestinations();
                    while (iterator.hasNext()) {
                        Destination destination = (Destination)iterator.next();
                        if (destination.isInternal() || destination.isAdmin() || destination.isTemporary()) continue;
                        destination.pauseDestination(n4);
                    }
                } else {
                    Destination destination = Destination.getDestination(string3, DestType.isQueue((int)n));
                    if (destination == null) {
                        String string5;
                        string4 = string5 = Globals.getBrokerResources().getString("B1126", (DestType.isQueue((int)n) ? " queue:" : " topic:") + string3);
                        n3 = 404;
                        this.logger.log(32, string5);
                    } else if (destination.isInternal() || destination.isAdmin()) {
                        string4 = Globals.getBrokerResources().getString("B1127", (DestType.isQueue((int)n) ? " queue:" : " topic:") + string3);
                        this.logger.log(8, string4);
                        n3 = 500;
                    } else {
                        destination.pauseDestination(n4);
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B3064", (Object)string2, (Throwable)iOException);
            n3 = 500;
            string4 = this.rb.getString("B3064", string2) + ": " + iOException;
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, "B3064", (Object)string2, (Throwable)brokerException);
            n3 = 500;
            string4 = this.rb.getString("B3064", string2) + ": " + brokerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string4 = illegalArgumentException.getMessage();
            n3 = 404;
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        PauseHandler.setProperties(packet2, 31, n3, string4);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }

    public static void pauseService(boolean bl, String string) throws BrokerException, IllegalArgumentException {
        ServiceManager serviceManager = Globals.getServiceManager();
        Object var3_3 = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string != null && serviceManager.getService(string) == null) {
            throw new IllegalArgumentException(brokerResources.getString("B4057", string));
        }
        if (bl) {
            if (string == null) {
                serviceManager.pauseAllActiveServices(0, true);
            } else {
                serviceManager.pauseService(string, true);
            }
        } else if (string == null) {
            serviceManager.resumeAllActiveServices(0);
        } else {
            serviceManager.resumeService(string);
        }
    }
}

