/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Controller;
import com.sun.messaging.bridge.service.stomp.FrameParseException;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompFrameMessage {
    private static Logger _logger = Controller.logger();
    private static final String STOMP_VERSION = "1.0";
    protected static final String HEADER_SEPERATOR = ":";
    private static final String NEWLINESTR = "\n";
    private static final byte NEWLINE_BYTE = 10;
    private static final byte NULL_BYTE = 0;
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    protected static final int MIN_COMMAND_LEN = 3;
    protected static final int MAX_COMMAND_LEN = 1024;
    protected static final int MAX_HEADER_LEN = 10240;
    private static final int MAX_HEADERS = 1000;
    private Command _command = Command.UNKNOWN;
    private ArrayList<String> _requiredHeaders = new ArrayList();
    private LinkedHashMap<String, String> _headers = new LinkedHashMap();
    private Integer _contentLength = null;
    protected ParseStage _parseStage = ParseStage.COMMAND;
    private int _byteBufferPosition = 0;
    private ByteArrayOutputStream _bao = null;
    private byte[] _body = null;
    private Exception _parseException = null;
    private boolean _fatalERROR = false;
    private StompBridgeResources _sbr = null;

    protected StompFrameMessage(Command command) {
        this._command = command;
        this._sbr = StompServer.getStompBridgeResources();
        switch (command) {
            case CONNECT: {
                this._requiredHeaders.add("login".toString());
                this._requiredHeaders.add("passcode".toString());
                break;
            }
            case SEND: {
                this._requiredHeaders.add("destination".toString());
            }
        }
    }

    protected void setFatalERROR() {
        this._fatalERROR = true;
    }

    public boolean isFatalERROR() {
        return this._fatalERROR;
    }

    protected Exception getParseException() {
        return this._parseException;
    }

    public Command getCommand() {
        return this._command;
    }

    protected void addHeader(String string, String string2) {
        this._headers.put(string, string2);
    }

    protected LinkedHashMap<String, String> getHeaders() {
        return this._headers;
    }

    protected String getHeader(String string) {
        return this._headers.get(string);
    }

    protected byte[] getBody() {
        if (this._body != null) {
            return this._body;
        }
        if (this._bao == null) {
            return new byte[0];
        }
        this._body = this._bao.toByteArray();
        return this._body;
    }

    protected String getBodyText() throws FrameParseException {
        String string = "";
        if (this._body != null) {
            try {
                if (this._body != null) {
                    return new String(this._body, "UTF-8");
                }
            }
            catch (Exception exception) {
                throw new FrameParseException(exception.getMessage(), exception);
            }
        }
        if (this._bao == null) {
            return string;
        }
        this._body = this._bao.toByteArray();
        try {
            string = new String(this._body, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            throw new FrameParseException(this._sbr.getKString("BSS4010", (Object)this.getCommand(), exception.getMessage()));
        }
    }

    private void writeByteToBody(byte by) throws Exception {
        if (this._bao == null) {
            this._bao = this.getContentLength() != -1 ? new ByteArrayOutputStream(this.getContentLength()) : new ByteArrayOutputStream();
        }
        this._bao.write(by);
    }

    protected void setBody(byte[] byArray) {
        this._body = byArray;
    }

    protected void writeExceptionToBody(Throwable throwable) throws Exception {
        if (this._bao == null) {
            this._bao = new ByteArrayOutputStream();
        }
        throwable.printStackTrace(new PrintStream((OutputStream)this._bao, true, "UTF-8"));
        this.addHeader("content-length", String.valueOf(this.getBodySize()));
    }

    private int getBodySize() {
        if (this._bao == null) {
            return 0;
        }
        return this._bao.size();
    }

    protected void setNextParseStage(ParseStage parseStage) {
        this._parseStage = parseStage;
        if (parseStage == ParseStage.BODY) {
            for (String string : this._requiredHeaders) {
                if (this._headers.get(string) != null || this._parseException != null) continue;
                this._parseException = new FrameParseException(this._sbr.getKString("BSS4011", string, (Object)this.getCommand()));
                _logger.log(Level.SEVERE, this._parseException.getMessage());
            }
        }
        if (parseStage == ParseStage.DONE) {
            try {
                if (this._bao != null) {
                    this._bao.close();
                }
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "Exception in closing ByteArrayOutputStream:" + exception.getMessage());
            }
        }
    }

    protected ParseStage getNextParseStage() {
        return this._parseStage;
    }

    private void setByteBufferPosition(int n) {
        this._byteBufferPosition = n;
    }

    protected int getByteBufferPosition() {
        return this._byteBufferPosition;
    }

    protected int getContentLength() {
        int n;
        block4: {
            if (this._contentLength != null) {
                return this._contentLength;
            }
            String string = this._headers.get("content-length");
            if (string == null) {
                return -1;
            }
            n = -1;
            try {
                n = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                if (this._parseException != null) break block4;
                this._parseException = new FrameParseException(this._sbr.getKString("BSS4012", string, "content-length"));
                n = -1;
                _logger.log(Level.SEVERE, this._parseException.getMessage());
            }
        }
        this._contentLength = new Integer(n);
        return n;
    }

    public ByteBuffer marshall() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((Object)this.getCommand());
        stringBuffer.append(NEWLINESTR);
        for (String string : this._headers.keySet()) {
            stringBuffer.append(string);
            stringBuffer.append(HEADER_SEPERATOR);
            stringBuffer.append(this._headers.get(string));
            stringBuffer.append(NEWLINESTR);
        }
        stringBuffer.append(NEWLINESTR);
        dataOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
        dataOutputStream.write(this.getBody());
        dataOutputStream.write(END_OF_FRAME);
        dataOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        return byteBuffer;
    }

    public void parseHeader(ByteBuffer byteBuffer, int n) throws Exception {
        String string = null;
        int n2 = byteBuffer.position();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "in parseHeader: start=" + n + ", end=" + n2);
        }
        try {
            int n3 = 0;
            while (n < n2) {
                byte[] byArray = StompFrameMessage.parseLine(byteBuffer, 10240, n);
                if (byArray == null) {
                    return;
                }
                n += byArray.length + 1;
                string = new String(byArray, "UTF-8");
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "parseHeader: got line byte-length=" + byArray.length + ", header=:" + string + ", header-length=" + string.length() + ", start=" + n);
                }
                if (string.trim().length() == 0) {
                    this.setByteBufferPosition(n);
                    this.setNextParseStage(ParseStage.BODY);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "parseHeader: DONE - start=" + n);
                    }
                    return;
                }
                int n4 = string.indexOf(HEADER_SEPERATOR);
                if (n4 == -1) {
                    if (this._parseException == null) {
                        this._parseException = new FrameParseException(this._sbr.getKString("BSS4013", string));
                        _logger.log(Level.SEVERE, this._parseException.getMessage());
                    }
                    n4 = string.length() - 1;
                }
                String string2 = string.substring(0, n4).trim();
                String string3 = string.substring(n4 + 1, string.length()).trim();
                this.addHeader(string2, string3);
                if (++n3 > 1000) {
                    throw new FrameParseException(this._sbr.getKString("BSS4014", 1000));
                }
                this.setByteBufferPosition(n);
            }
        }
        catch (Exception exception) {
            if (exception instanceof FrameParseException) {
                throw exception;
            }
            throw new FrameParseException(this._sbr.getKString("BSS4015", string, exception.getMessage()), exception);
        }
    }

    public void readBody(ByteBuffer byteBuffer, int n) throws Exception {
        int n2 = this.getContentLength();
        int n3 = byteBuffer.position();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "in readBody:contentLen=" + this._contentLength + ", start=" + n + ", end=" + n3 + ", bodySize=" + this.getBodySize());
        }
        while (n < n3) {
            byte by;
            if (n2 != -1 && n2 == this.getBodySize()) {
                _logger.log(Level.FINEST, "Body has beed read!");
                this.setByteBufferPosition(n);
                this.setNextParseStage(ParseStage.NULL);
                return;
            }
            if ((by = byteBuffer.get(n++)) == 0 && n2 == -1) {
                if (n < n3 && (byteBuffer.get(n) == 10 || byteBuffer.get(n) == 13)) {
                    ++n;
                }
                if (n < n3 && byteBuffer.get(n) == 10) {
                    ++n;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "readBody: DONE - start=" + n);
                }
                this.setByteBufferPosition(n);
                this.setNextParseStage(ParseStage.DONE);
                return;
            }
            this.writeByteToBody(by);
        }
        this.setByteBufferPosition(n);
        _logger.log(Level.FINEST, "leaving readBody(): BODY_SIZE=" + this.getBodySize());
    }

    public void readNULL(ByteBuffer byteBuffer, int n) throws Exception {
        byte by;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "in readNULL:" + n + HEADER_SEPERATOR + byteBuffer.position());
        }
        if (byteBuffer.position() <= n) {
            return;
        }
        if ((by = byteBuffer.get(n++)) != 0) {
            throw new FrameParseException(this._sbr.getKString("BSS4016", "content-length " + this.getContentLength()));
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "got NULL readNULL:" + n + HEADER_SEPERATOR + byteBuffer.position());
        }
        this.setByteBufferPosition(n);
        this.setNextParseStage(ParseStage.DONE);
    }

    public String toString() {
        return (Object)((Object)this._command) + "[" + this._headers + "]";
    }

    public static StompFrameMessage parseCommand(ByteBuffer byteBuffer, int n) throws Exception {
        StompFrameMessage stompFrameMessage = null;
        String string = "";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "parseCommand: start:end[" + n + HEADER_SEPERATOR + byteBuffer.position() + "]");
        }
        try {
            while (string.trim().length() == 0) {
                byte[] byArray = StompFrameMessage.parseLine(byteBuffer, 1024, n);
                if (byArray == null) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "parseCommand: start[" + n + "] command line not found");
                    }
                    return null;
                }
                n += byArray.length + 1;
                string = new String(byArray, "UTF-8");
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.log(Level.FINEST, "parseCommand: got line:" + string + ", start=" + n);
            }
            if (string.startsWith(Command.CONNECT.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.CONNECT);
            } else if (string.startsWith(Command.SEND.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.SEND);
            } else if (string.startsWith(Command.SUBSCRIBE.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.SUBSCRIBE);
            } else if (string.startsWith(Command.ACK.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.ACK);
            } else if (string.startsWith(Command.UNSUBSCRIBE.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.UNSUBSCRIBE);
            } else if (string.startsWith(Command.BEGIN.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.BEGIN);
            } else if (string.startsWith(Command.COMMIT.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.COMMIT);
            } else if (string.startsWith(Command.ABORT.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.ABORT);
            } else if (string.startsWith(Command.DISCONNECT.toString())) {
                stompFrameMessage = new StompFrameMessage(Command.DISCONNECT);
            } else {
                throw new FrameParseException("Unknown STOMP command: " + string);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "parseCommand: DONE - cmd=" + string + ", start:" + n);
            }
            stompFrameMessage.setByteBufferPosition(n);
            stompFrameMessage.setNextParseStage(ParseStage.HEADER);
        }
        catch (Exception exception) {
            if (exception instanceof FrameParseException) {
                throw exception;
            }
            throw new FrameParseException(exception.getMessage(), exception);
        }
        return stompFrameMessage;
    }

    private static byte[] parseLine(ByteBuffer byteBuffer, int n, int n2) throws Exception {
        byte[] byArray = new byte[n];
        int n3 = byteBuffer.position();
        boolean bl = false;
        int n4 = 0;
        while (n2 < n3) {
            byte by;
            if ((by = byteBuffer.get(n2++)) == 10) {
                bl = true;
                break;
            }
            byArray[n4++] = by;
            if (n4 < n - 1) continue;
            throw new FrameParseException(StompServer.getStompBridgeResources().getKString("BSS4017", n));
        }
        if (!bl) {
            return null;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        return byArray2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ParseStage {
        COMMAND,
        HEADER,
        BODY,
        NULL,
        DONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AckHeader {

        static final String MESSAGEID = "message-id";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectedHeader {

        static final String SESSION = "session";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorHeader {

        static final String MESSAGE = "message";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectHeader {

        static final String LOGIN = "login";
        static final String PASSCODE = "passcode";
        static final String CLIENTID = "client-id";
        static final String VERSION = "version";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnsubscribeHeader {

        static final String DESTINATION = "destination";
        static final String ID = "id";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AckMode {

        static final String AUTO = "auto";
        static final String CLIENT = "client";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubscribeHeader {

        static final String DESTINATION = "destination";
        static final String SELECTOR = "selector";
        static final String ACK = "ack";
        static final String ID = "id";
        static final String DURASUBNAME = "durable-subscriber-name";
        static final String NOLOCAL = "no-local";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageHeader {

        static final String DESTINATION = "destination";
        static final String MESSAGEID = "message-id";
        static final String TIMESTAMP = "timestamp";
        static final String EXPIRES = "expires";
        static final String PRORITY = "priority";
        static final String REDELIVERED = "redelivered";
        static final String TYPE = "type";
        static final String REPLYTO = "reply-to";
        static final String CORRELATIONID = "correlation-id";
        static final String SUBSCRIPTION = "subscription";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SendHeader {

        static final String DESTINATION = "destination";
        static final String EXPIRES = "expires";
        static final String PRIORITY = "priority";
        static final String TYPE = "type";
        static final String PERSISTENT = "persistent";
        static final String REPLYTO = "reply-to";
        static final String CORRELATIONID = "correlation-id";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseCommonHeader {

        static final String RECEIPTID = "receipt-id";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonHeader {

        static final String RECEIPT = "receipt";
        static final String TRANSACTION = "transaction";
        static final String CONTENTLENGTH = "content-length";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        CONNECT,
        SEND,
        DISCONNECT,
        SUBSCRIBE,
        UNSUBSCRIBE,
        BEGIN,
        COMMIT,
        ABORT,
        ACK,
        UNKNOWN,
        CONNECTED,
        MESSAGE,
        RECEIPT,
        ERROR;

    }
}

