/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLStreamWriter {
    public void writeToStream(Node dom, XMLStreamWriter xsw) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xsw.writeStartDocument(doc.getXmlEncoding(), doc.getXmlVersion());
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, xsw);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xsw.writeNamespace(attribute.getLocalName(), attribute.getValue());
            } else if (attribute.getPrefix() == null) {
                xsw.writeAttribute(attribute.getName(), attribute.getValue());
            } else {
                xsw.writeAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
            }
        } else if (currentNode.getNodeType() == 3) {
            xsw.writeCharacters(((Text)currentNode).getNodeValue());
        }
        if (dom.getNodeType() == 9) {
            xsw.writeEndDocument();
        }
    }

    private void writeElement(Element elem, XMLStreamWriter xsw) throws XMLStreamException {
        if (elem.getPrefix() != null && !elem.getPrefix().equals("")) {
            String namespaceURI = xsw.getNamespaceContext().getNamespaceURI(elem.getPrefix());
            xsw.writeStartElement(elem.getPrefix(), elem.getLocalName(), elem.getNamespaceURI());
            if (!elem.getNamespaceURI().equals(namespaceURI)) {
                xsw.writeNamespace(elem.getPrefix(), elem.getNamespaceURI());
            }
        } else {
            String localName = elem.getLocalName();
            String name = elem.getNodeName();
            if (elem.getNamespaceURI() == null || elem.getNamespaceURI().equals("")) {
                xsw.writeStartElement(elem.getNodeName());
                String defaultNamespace = xsw.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && !"".equals(defaultNamespace)) {
                    xsw.writeDefaultNamespace("");
                }
            } else {
                xsw.writeStartElement("", elem.getLocalName(), elem.getNamespaceURI());
            }
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Attr> nonNamespaceDeclAttrs = new ArrayList<Attr>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getNodeType() != 2) continue;
            Attr attribute = attr;
            if (attr.getPrefix() != null && attr.getPrefix().equals("xmlns")) {
                String currentUri = xsw.getNamespaceContext().getNamespaceURI(attr.getLocalName());
                if (currentUri != null && currentUri.equals(attr.getValue())) continue;
                xsw.writeNamespace(attr.getLocalName(), attr.getValue());
                continue;
            }
            nonNamespaceDeclAttrs.add(attribute);
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xsw.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            xsw.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3) {
                xsw.writeCharacters(((Text)node).getNodeValue());
                continue;
            }
            if (node.getNodeType() == 4) {
                xsw.writeCData(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 8) {
                xsw.writeComment(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            this.writeElement((Element)node, xsw);
        }
        xsw.writeEndElement();
    }
}

