/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.jmx;

import com.sun.corba.ee.impl.orbutil.jmx.AnnotationUtil;
import com.sun.corba.ee.impl.orbutil.jmx.DynamicMBeanImpl;
import com.sun.corba.ee.impl.orbutil.jmx.DynamicMBeanSkeleton;
import com.sun.corba.ee.impl.orbutil.jmx.TypeConverterImpl;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObject;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObjectManager;
import com.sun.corba.ee.spi.orbutil.jmx.TypeConverter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedObjectManagerImpl
implements ManagedObjectManager {
    private String domain;
    private MBeanServer server;
    private Map<Object, ObjectName> objectMap;
    private Map<ObjectName, Object> objectNameMap;
    private Map<Class<?>, DynamicMBeanSkeleton> skeletonMap;
    private Map<Type, TypeConverter> typeConverterMap;

    public synchronized DynamicMBeanSkeleton getSkeleton(Class<?> cls) {
        List<Pair<Class<?>, ManagedObject>> mos = AnnotationUtil.getClassAnnotations(cls, ManagedObject.class);
        if (mos.size() == 0) {
            throw new IllegalArgumentException("Class " + cls + " is not a ManagedObject");
        }
        Pair<Class<?>, ManagedObject> pair = mos.get(0);
        DynamicMBeanSkeleton result = this.skeletonMap.get(pair.first());
        if (result == null) {
            result = new DynamicMBeanSkeleton(cls, this);
            this.skeletonMap.put(cls, result);
        }
        return result;
    }

    @Override
    public synchronized TypeConverter getTypeConverter(Type type) {
        TypeConverter result = this.typeConverterMap.get(type);
        if (result == null) {
            result = TypeConverterImpl.makeTypeConverter(type, this);
            this.typeConverterMap.put(type, result);
        }
        return result;
    }

    public ManagedObjectManagerImpl(String domain) {
        this.domain = domain;
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.objectMap = new HashMap<Object, ObjectName>();
        this.objectNameMap = new HashMap<ObjectName, Object>();
        this.skeletonMap = new WeakHashMap();
        this.typeConverterMap = new WeakHashMap<Type, TypeConverter>();
    }

    public static ManagedObjectManager makeDelegate(final ManagedObjectManager mom, final String ... props) {
        return new ManagedObjectManager(){
            final Properties savedProps;
            {
                this.savedProps = ManagedObjectManagerImpl.makeProps(props);
            }

            @Override
            public void register(Object obj, String ... mprops) {
                Properties lprops = new Properties(this.savedProps);
                ManagedObjectManagerImpl.addToProperties(lprops, mprops);
                mom.register(obj, lprops);
            }

            @Override
            public void register(Object obj, Properties mprops) {
                Properties lprops = new Properties(this.savedProps);
                Enumeration<?> names = mprops.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = mprops.getProperty(name);
                    lprops.setProperty(name, value);
                }
                mom.register(obj, lprops);
            }

            @Override
            public void unregister(Object obj) {
                try {
                    mom.unregister(obj);
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException(exc);
                }
            }

            @Override
            public ObjectName getObjectName(Object obj) {
                return mom.getObjectName(obj);
            }

            @Override
            public String getDomain() {
                return mom.getDomain();
            }

            @Override
            public Object getObject(ObjectName oname) {
                return mom.getObject(oname);
            }

            @Override
            public TypeConverter getTypeConverter(Type type) {
                return mom.getTypeConverter(type);
            }

            @Override
            public void setMBeanServer(MBeanServer server) {
                mom.setMBeanServer(server);
            }

            @Override
            public MBeanServer getMBeanServer() {
                return mom.getMBeanServer();
            }
        };
    }

    private static Properties makeProps(String ... props) {
        Properties result = new Properties();
        ManagedObjectManagerImpl.addToProperties(result, props);
        return result;
    }

    private static void addToProperties(Properties base, String ... props) {
        for (String str : props) {
            int eqIndex = str.indexOf("=");
            if (eqIndex < 1) {
                throw new IllegalArgumentException("All properties must contain an = after the (non-empty) property name");
            }
            String name = str.substring(0, eqIndex);
            String value = str.substring(eqIndex + 1);
            base.setProperty(name, value);
        }
    }

    @Override
    public void register(Object obj, String ... props) {
        this.register(obj, ManagedObjectManagerImpl.makeProps(props));
    }

    private Hashtable convertToHashtable(Properties props) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = props.getProperty(name);
            result.put(name, value);
        }
        return result;
    }

    @Override
    public synchronized void register(Object obj, Properties props) {
        Class<?> cls = obj.getClass();
        DynamicMBeanSkeleton skel = this.getSkeleton(cls);
        DynamicMBeanImpl mbean = new DynamicMBeanImpl(skel, obj);
        Properties myProps = new Properties(props);
        String type = skel.getType();
        myProps.setProperty("type", type);
        Hashtable onProps = this.convertToHashtable(myProps);
        ObjectName oname = null;
        try {
            oname = new ObjectName(this.domain, onProps);
            this.server.registerMBean(mbean, oname);
            this.objectMap.put(obj, oname);
            this.objectNameMap.put(oname, obj);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    @Override
    public synchronized void unregister(Object obj) {
        ObjectName oname = this.objectMap.get(obj);
        if (oname != null) {
            try {
                this.server.unregisterMBean(oname);
            }
            catch (Exception exc) {
                throw new IllegalArgumentException(exc);
            }
            finally {
                this.objectMap.remove(obj);
                this.objectNameMap.remove(oname);
            }
        }
    }

    @Override
    public ObjectName getObjectName(Object obj) {
        return this.objectMap.get(obj);
    }

    @Override
    public Object getObject(ObjectName oname) {
        return this.objectNameMap.get(oname);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.server;
    }
}

