/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.service.FaultInjection;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.TransactionImpl;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerAdapter;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.BranchXidDecision;
import com.sun.messaging.bridge.service.jms.tx.log.JDBCTxLogImpl;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.UID;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionManagerImpl
implements TransactionManager,
TransactionManagerAdapter {
    private static int FORMATID = 1246580992;
    private Logger _logger = null;
    private static final int DEFAULT_TRANSACTION_TIMEOUT = 0;
    private int _transactionTimeout = 0;
    private String _tmName = null;
    private String _jmsbridge = null;
    private static final int DEFAULT_MAX_BRANCHES = 16;
    private int _maxBranches = 16;
    private TMState _state = TMState.UNINITIALIZED;
    private Map<String, List<XAResource>> _rmToXAResources = new LinkedHashMap<String, List<XAResource>>();
    private ThreadLocal<TransactionImpl> _threadLocal = new ThreadLocal();
    private String _txlogdir = null;
    private TxLog _txlog = null;
    private String _txlogType = "file";
    private String _txlogClass = null;
    private JMSBridgeStore _jdbcStore = null;
    private List<LogRecord> _recoveredLRs = new ArrayList<LogRecord>();
    private LinkedHashMap<String, ArrayList<String>> _keepGxidsForRM = new LinkedHashMap();
    private FaultInjection _fi = FaultInjection.getInjection();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    private static final int MAX_TMNAME_LENGTH = 55;
    private static final int MAX_RMNAME_LENGTH = 62;

    public void setJDBCStore(JMSBridgeStore jMSBridgeStore) throws IllegalStateException {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setJDBCStore");
        }
        this._jdbcStore = jMSBridgeStore;
    }

    @Override
    public synchronized void init(Properties properties, boolean bl) throws Exception {
        Enumeration<?> enumeration;
        if (this._logger == null) {
            throw new IllegalStateException("TM has no logger set");
        }
        if (properties != null) {
            enumeration = properties.propertyNames();
            Object object3 = null;
            Object object = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                object = properties.getProperty(string);
                this._logger.log(Level.INFO, _jbr.getString("BSJ1054", string + "=" + (String)object, this.getClass().getName()));
                this.setProperty(string, (String)object);
            }
        }
        if (this._tmName == null) {
            throw new IllegalStateException("TM name not set for " + this.getClass().getName());
        }
        if (this._state != TMState.UNINITIALIZED) {
            this._logger.log(Level.WARNING, "init " + this);
            throw new IllegalStateException("init " + this);
        }
        enumeration = null;
        if (this._txlogClass == null) {
            if (this._txlogType.equals("jdbc")) {
                this._txlog = (TxLog)Class.forName("com.sun.messaging.bridge.service.jms.tx.log.JDBCTxLogImpl").newInstance();
                ((JDBCTxLogImpl)this._txlog).setJDBCStore(this._jdbcStore);
            } else {
                this._txlog = (TxLog)Class.forName("com.sun.messaging.bridge.service.jms.tx.log.FileTxLogImpl").newInstance();
            }
        } else {
            this._logger.log(Level.INFO, "loading txlog class " + this._txlogClass);
            this._txlog = (TxLog)Class.forName(this._txlogClass).newInstance();
        }
        this._txlog.setLogger(this._logger);
        if (properties.getProperty("txlogMaxBranches") == null) {
            properties.setProperty("txlogMaxBranches", String.valueOf(this._maxBranches));
        }
        try {
            this._txlog.init(properties, bl);
        }
        catch (Exception exception) {
            this._txlog.close();
            throw exception;
        }
        this._recoveredLRs = this._txlog.getAllLogRecords();
        this._logger.log(Level.INFO, _jbr.getString("BSJ1055", this._tmName, String.valueOf(this._recoveredLRs.size())));
        if (this._logger.isLoggable(Level.FINE)) {
            Object var4_8 = null;
            for (LogRecord logRecord : this._recoveredLRs) {
                this._logger.log(Level.INFO, "\t" + logRecord + "\n");
            }
        }
        this._state = TMState.INITIALIZED;
    }

    @Override
    public String[] getAllTransactions() throws Exception {
        if (this._state != TMState.INITIALIZED || this._txlog == null) {
            return null;
        }
        try {
            List list = this._txlog.getAllLogRecords();
            Iterator iterator = list.iterator();
            String[] stringArray = new String[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n++] = ((LogRecord)iterator.next()).toString();
            }
            return stringArray;
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Unable to get " + this + " all log records: " + exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    public TransactionManager getTransactionManager() throws SystemException {
        return this;
    }

    public void setProperty(String string, String string2) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setProperty(" + string + ", " + string2 + ")");
        }
        if (string.equals("tmname")) {
            this.setName(string2);
            return;
        }
        if (string.equals("txlogType")) {
            this.setTxlogType(string2);
            return;
        }
        if (string.equals("txlogClass")) {
            this.setTxlogClass(string2);
            return;
        }
        if (string.equals("jmsbridge")) {
            this._jmsbridge = string2;
            return;
        }
    }

    public void setName(String string) throws SystemException {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setName(" + string + ")");
        }
        if (string.getBytes().length > 55) {
            throw new SystemException("TM name " + string + " exceeds maximum " + 55 + " bytes");
        }
        this._tmName = string;
    }

    public void setTxlogType(String string) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setTxlogType(" + string + ")");
        }
        if (string == null || !string.trim().equals("file") && !string.trim().equals("jdbc")) {
            throw new IllegalArgumentException(this + ": Invalid txlog type " + string);
        }
        this._txlogType = string;
    }

    public void setTxlogClass(String string) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setTxlogClass(" + string + ")");
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(this + ": Invalid txlog class " + string);
        }
        Class<?> clazz = Class.forName(string.trim());
        clazz.newInstance();
        this._txlogClass = string.trim();
    }

    public void setMaxBranches(int n) {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setMaxBranches(" + n + ")");
        }
        if (n < 0 || n > 127) {
            throw new IllegalArgumentException("Invalid value " + n + " for maximum branches");
        }
        this._maxBranches = n;
    }

    protected int getMaxBranches() {
        return this._maxBranches;
    }

    @Override
    public boolean registerRM() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRM(String string, XAResource xAResource) throws Exception {
        Xid[] xidArray;
        if (this._state != TMState.INITIALIZED) {
            throw new IllegalStateException("TM not initialized");
        }
        if (string == null) {
            throw new SystemException("null RM name");
        }
        if (xAResource == null) {
            throw new SystemException("null XAResource object for RM " + string);
        }
        if (string.getBytes().length > 62) {
            throw new SystemException("RM name " + string + " exceeds maximum " + 62 + " bytes");
        }
        Object object2 = this._rmToXAResources;
        synchronized (object2) {
            xidArray = this._rmToXAResources.get(string);
            if (xidArray == null) {
                xidArray = new ArrayList<XAResource>();
                this._rmToXAResources.put(string, (List<XAResource>)xidArray);
            }
            for (XAResource object3 : xidArray) {
                if (!object3.isSameRM(xAResource) && !xAResource.isSameRM(object3) || object3.getClass().getName().equals(xAResource.getClass().getName())) continue;
                String string2 = "XAResource " + xAResource + " has different class name from what's registered " + object3 + " for RM " + string;
                this._logger.log(Level.SEVERE, string2);
                throw new IllegalArgumentException(string2);
            }
            if (!xidArray.contains(xAResource)) {
                xidArray.add((XAResource)xAResource);
            }
        }
        object2 = new ArrayList();
        xidArray = null;
        int n = 0x1000000;
        do {
            try {
                if (this._fi.FAULT_INJECTION) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("cfref", string);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.recover.1", hashMap, "javax.transaction.xa.XAException", true);
                }
                if ((xidArray = xAResource.recover(n)).length > 0) {
                    n = 0;
                }
                ((ArrayList)object2).add(xidArray);
            }
            catch (Throwable throwable) {
                this._logger.log(Level.SEVERE, "Recovering XAResource " + xAResource + " from RM " + string + " failed", throwable);
                SystemException systemException = new SystemException(throwable.getMessage());
                systemException.initCause(throwable);
                throw systemException;
            }
        } while (xidArray.length > 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        BranchXid branchXid = null;
        boolean bl = false;
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            Xid[] xidArray2 = (Xid[])iterator.next();
            for (int i = 0; i < xidArray2.length; ++i) {
                GlobalXid globalXid;
                String string3;
                block29: {
                    byte by;
                    byte by2;
                    branchXid = new BranchXid();
                    branchXid.copy(xidArray2[i]);
                    if (branchXid.getFormatId() != FORMATID) {
                        this._logger.log(Level.WARNING, "Ignore foreign XID " + branchXid + "[" + branchXid.getFormatId() + "]");
                        continue;
                    }
                    byte[] byArray = branchXid.getGlobalTransactionId();
                    String string4 = new String(byArray, 1, (int)(by2 = byArray[0]), "UTF-8");
                    if (!string4.equals(this._tmName)) {
                        this._logger.log(Level.WARNING, "Ignore global XID " + branchXid + " from different TM name [" + string4 + "] from mine [" + this._tmName + "]");
                        continue;
                    }
                    byte[] byArray2 = branchXid.getBranchQualifier();
                    string3 = new String(byArray2, 1, (int)(by = byArray2[0]), "UTF-8");
                    if (!string3.equals(string)) {
                        this._logger.log(Level.WARNING, "XID " + branchXid + " from RM [" + string + "]" + xAResource + " has different RM name [" + string3 + "]");
                        arrayList2.add(string3);
                    }
                    bl = false;
                    globalXid = new GlobalXid();
                    globalXid.setFormatId(branchXid.getFormatId());
                    globalXid.setGlobalTransactionId(byArray);
                    this._logger.log(Level.INFO, "Recovering branch " + branchXid + " for global transaction " + globalXid + " from RM [" + string + "(" + string3 + ")]" + xAResource);
                    LogRecord logRecord = this._txlog.getLogRecord(globalXid);
                    if (logRecord != null && logRecord.getGlobalDecision() == 0) {
                        bl = true;
                    }
                    try {
                        if (logRecord != null && logRecord.isHeuristicBranch(branchXid)) {
                            this._logger.log(Level.WARNING, "Branch " + branchXid + " was heuristically completed in " + globalXid + "[" + bl + "]");
                            arrayList.add(globalXid.toString());
                        }
                        break block29;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        arrayList.add(globalXid.toString());
                        this._logger.log(Level.WARNING, "Unable to find branch " + branchXid + " in " + logRecord + " for recovery");
                    }
                    continue;
                }
                XAParticipant xAParticipant = new XAParticipant(string3, xAResource, branchXid, true);
                xAParticipant.setLogger(this._logger);
                Throwable throwable = null;
                if (bl) {
                    try {
                        this._logger.log(Level.INFO, "Commiting recovered branch " + branchXid + " to RM [" + string + "(" + string3 + ")]" + xAResource);
                        xAParticipant.commit(false);
                    }
                    catch (Throwable throwable2) {
                        arrayList.add(globalXid.toString());
                        throwable = throwable2;
                        this._logger.log(Level.WARNING, "Failed to commit recovered branch " + branchXid, throwable2);
                    }
                    continue;
                }
                try {
                    this._logger.log(Level.INFO, "Rolling back recovered branch " + branchXid + " to RM " + string);
                    xAParticipant.rollback();
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    this._logger.log(Level.WARNING, "Failed to rollback recovered branch " + branchXid, throwable3);
                }
            }
        }
        this.cleanupRecoveredLRs(string, arrayList, arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepGxidForRM(String string, String string2, String string3) {
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = this._keepGxidsForRM;
        synchronized (linkedHashMap) {
            ArrayList<String> arrayList;
            if (string2 != null) {
                arrayList = this._keepGxidsForRM.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this._keepGxidsForRM.put(string2, arrayList);
                }
                if (string != null && !arrayList.contains(string)) {
                    arrayList.add(string);
                }
            }
            if (string3 != null) {
                arrayList = this._keepGxidsForRM.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this._keepGxidsForRM.put(string3, arrayList);
                }
                if (string != null && !arrayList.contains(string)) {
                    arrayList.add(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupRecoveredLRs(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        this._logger.log(Level.INFO, "Update recovery information for RM[" + string + "], " + arrayList.size() + " global xids");
        this.keepGxidForRM(null, string, null);
        String string22 = null;
        for (String string22 : arrayList2) {
            this._logger.log(Level.INFO, "Update recovery information for RM[" + string + "(" + string22 + ")]");
            this.keepGxidForRM(null, null, string22);
        }
        String string32 = null;
        for (String string32 : arrayList) {
            this.keepGxidForRM(string32, string, null);
            for (String string22 : arrayList2) {
                this.keepGxidForRM(string32, null, string22);
            }
        }
        List<LogRecord> list = this._recoveredLRs;
        synchronized (list) {
            string32 = null;
            LogRecord logRecord = null;
            BranchXidDecision[] branchXidDecisionArray = null;
            Iterator<LogRecord> iterator = this._recoveredLRs.iterator();
            while (iterator.hasNext()) {
                logRecord = iterator.next();
                string32 = logRecord.getGlobalXid().toString();
                branchXidDecisionArray = logRecord.getBranchXidDecisions();
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.INFO, "Check recovery completion for global xid " + string32);
                }
                BranchXid branchXid = null;
                byte[] byArray = null;
                byte by = 0;
                String string4 = null;
                boolean bl = false;
                for (int i = 0; i < branchXidDecisionArray.length; ++i) {
                    ArrayList<String> arrayList3;
                    branchXid = branchXidDecisionArray[i].getBranchXid();
                    byArray = branchXid.getBranchQualifier();
                    by = byArray[0];
                    try {
                        string4 = new String(byArray, 1, (int)by, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this._logger.log(Level.WARNING, "Unable to get RM name from branch " + branchXid.toString() + " for recovery global xid " + string32 + ": " + unsupportedEncodingException.getMessage());
                        bl = true;
                        break;
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.INFO, "Check recovery completion for branch xid " + branchXid + " with RM[" + string4 + "]");
                    }
                    if ((arrayList3 = this._keepGxidsForRM.get(string4)) == null || arrayList3.contains(string32)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            if (arrayList3 == null) {
                                this._logger.log(Level.INFO, "Keep global xid " + string32 + " for no RM[" + string4 + "] info");
                            } else {
                                this._logger.log(Level.INFO, "Keep global xid " + string32 + " for RM[" + string4 + "]");
                            }
                        }
                        bl = true;
                        break;
                    }
                    if (!this._logger.isLoggable(Level.FINE)) continue;
                    this._logger.log(Level.INFO, "GXIDs " + arrayList3.size() + " to keep for RM[" + string4 + "]");
                    Iterator<String> iterator2 = arrayList3.iterator();
                    while (iterator2.hasNext()) {
                        this._logger.log(Level.INFO, "GXIDs to keep for RM[" + string4 + "]: " + iterator2.next());
                    }
                }
                if (bl) continue;
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1057", string32.toString()));
                    this._txlog.reap(string32);
                    iterator.remove();
                }
                catch (Exception exception) {
                    this._logger.log(Level.WARNING, "Unable to cleanup recovered global xid " + string32, exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRM(String string) throws Exception {
        if (string == null) {
            throw new SystemException("null RM name");
        }
        Map<String, List<XAResource>> map = this._rmToXAResources;
        synchronized (map) {
            List<XAResource> list = this._rmToXAResources.get(string);
            if (list == null) {
                this._logger.log(Level.WARNING, "Removing a unknown RM " + string);
                return;
            }
            list.remove(string);
            if (list.size() == 0) {
                this._rmToXAResources.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRM(XAResource xAResource) throws Exception {
        Map<String, List<XAResource>> map = this._rmToXAResources;
        synchronized (map) {
            for (Map.Entry<String, List<XAResource>> entry : this._rmToXAResources.entrySet()) {
                List<XAResource> list = entry.getValue();
                for (XAResource xAResource2 : list) {
                    if (!xAResource2.isSameRM(xAResource)) continue;
                    if (!xAResource2.getClass().getName().equals(xAResource.getClass().getName())) {
                        this._logger.log(Level.WARNING, "XAResource " + xAResource + " has different class name from what's registered " + xAResource2 + " for RM " + entry.getKey());
                        continue;
                    }
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkState();
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl != null) {
            throw new NotSupportedException("Nested transaction is not supported. The calling thread " + Thread.currentThread() + " is currently associated with transaction " + transactionImpl);
        }
        GlobalXid globalXid = this.genGlobalXid();
        transactionImpl = new TransactionImpl(globalXid, this);
        this._threadLocal.set(transactionImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        try {
            transactionImpl.commit();
        }
        finally {
            this._threadLocal.set(null);
            if (transactionImpl.getStatus() == 6) {
                // empty if block
            }
        }
    }

    public int getStatus() throws SystemException {
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl == null) {
            return 6;
        }
        return transactionImpl.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl == null) {
            throw new SystemException("No transaction associated with calling thread " + Thread.currentThread());
        }
        return transactionImpl;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        throw new SystemException("operation not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        try {
            transactionImpl.rollback();
        }
        finally {
            this._threadLocal.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl transactionImpl = this._threadLocal.get();
        if (transactionImpl == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        transactionImpl.setRollbackOnly();
    }

    public synchronized void setTransactionTimeout(int n) throws SystemException {
        throw new SystemException("operation not supported");
    }

    public Transaction suspend() throws SystemException {
        throw new SystemException("operation not supported");
    }

    @Override
    public synchronized void shutdown() throws SystemException {
        if (this._state == TMState.CLOSED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1056", this.toString()));
            return;
        }
        this._state = TMState.CLOSING;
        try {
            this._txlog.close();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Failed to close txlog: ", exception.getMessage());
            SystemException systemException = new SystemException();
            systemException.initCause((Throwable)exception);
            throw systemException;
        }
        this._state = TMState.CLOSED;
    }

    private void checkState() throws SystemException {
        if (this._state == TMState.CLOSING || this._state == TMState.CLOSED) {
            throw new SystemException("TM is shuting down");
        }
    }

    private GlobalXid genGlobalXid() throws SystemException {
        try {
            GlobalXid globalXid = new GlobalXid();
            globalXid.setFormatId(FORMATID);
            byte[] byArray = this._tmName.getBytes("UTF-8");
            if (byArray.length > 55) {
                throw new SystemException("TM name " + this._tmName + " byte length exceeds " + 62);
            }
            UID uID = new UID();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[64]);
            byteBuffer.put((byte)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.putLong(uID.longValue());
            globalXid.setGlobalTransactionId(byteBuffer.array());
            return globalXid;
        }
        catch (Exception exception) {
            if (exception instanceof SystemException) {
                throw (SystemException)exception;
            }
            SystemException systemException = new SystemException(exception.getMessage());
            systemException.initCause((Throwable)exception);
            throw systemException;
        }
    }

    protected BranchXid genBranchXid(GlobalXid globalXid, String string, String string2, byte by) throws SystemException {
        try {
            BranchXid branchXid = new BranchXid();
            branchXid.copy(globalXid);
            byte[] byArray = string.getBytes("UTF-8");
            if (byArray.length > 62) {
                throw new SystemException("Resource manager name " + string + " byte length exceeds " + 62);
            }
            int n = 62 - byArray.length;
            byte[] byArray2 = string2.getBytes("UTF-8");
            if (n > byArray2.length) {
                n = byArray2.length;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.INFO, "genBranchXid:rmName=" + string + "[" + byArray.length + "], className=" + string2 + "[" + n + "]");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[64]);
            byteBuffer.put((byte)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.put(byArray2, 0, n);
            byteBuffer.put(by);
            branchXid.setBranchQualifier(byteBuffer.array());
            return branchXid;
        }
        catch (Exception exception) {
            if (exception instanceof SystemException) {
                throw (SystemException)exception;
            }
            SystemException systemException = new SystemException(exception.getMessage());
            systemException.initCause((Throwable)exception);
            throw systemException;
        }
    }

    public TxLog getTxLog() {
        return this._txlog;
    }

    private static String stateString(TMState tMState) {
        switch (tMState) {
            case UNINITIALIZED: {
                return "UNINITIALIZED";
            }
            case INITIALIZED: {
                return "INITIALIZED";
            }
            case CLOSING: {
                return "CLOSING";
            }
            case CLOSED: {
                return "CLOSED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "TM:" + this._tmName + "[" + TransactionManagerImpl.stateString(this._state) + "]";
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TMState {
        UNINITIALIZED,
        INITIALIZED,
        CLOSING,
        CLOSED;

    }
}

