/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeXMLConstant;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import com.sun.messaging.bridge.service.jms.xml.TargetElement;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JMSBridgeReader
extends DefaultHandler {
    private Logger _logger = null;
    private JMSBridgeElement _jmsbridge = null;
    private LinkElement _link = null;
    private DMQElement _dmq = null;
    private TargetElement _target = null;
    private Properties _attrs = null;
    private Properties _props = null;
    private String _refname = null;
    private String _xmlurl = null;

    public JMSBridgeReader(String string, String string2, Logger logger) throws Exception {
        this._logger = logger;
        this._xmlurl = string;
        this.parseXML(string, string2);
    }

    private void parseXML(String string, String string2) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        InputStream inputStream = null;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            inputStream = new URL(string).openStream();
            sAXParser.parse(inputStream, this, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public JMSBridgeElement getJMSBridgeElement() {
        return this._jmsbridge;
    }

    public void startDocument() throws SAXException {
        this._logger.log(Level.INFO, "Start parsing " + this._xmlurl);
    }

    public void endDocument() throws SAXException {
        this._logger.log(Level.INFO, "End of parsing " + this._xmlurl);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        this._logger.log(Level.FINE, "startElement: uri=" + string + ", localName=" + string2 + ", qName=" + string3 + ", attributes=" + attributes);
        try {
            if (string4.equals("jmsbridge") || string4.equals("connection-factory") || string4.equals("link") || string4.equals("source") || string4.equals("target") || string4.equals("destination") || string4.equals("dmq")) {
                this._attrs = new Properties();
                this._props = new Properties();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    string6 = attributes.getQName(i);
                    string7 = attributes.getValue(i);
                    this._logger.log(Level.FINE, "attr:" + string6 + "=" + string7);
                    this._attrs.put(string6, string7);
                    if (string6.equals("name")) {
                        string5 = string7;
                        JMSBridgeXMLConstant.checkReserved(string5);
                        continue;
                    }
                    if (!string6.equals("ref-name")) continue;
                    this._refname = string7;
                    JMSBridgeXMLConstant.checkReserved(string5);
                }
                if (string4.equals("jmsbridge")) {
                    if (this._jmsbridge != null) {
                        throw new SAXNotSupportedException("Multiple jmsbridge element is not allowed");
                    }
                    this._logger.log(Level.FINE, "jmsbridge: name=" + string5);
                    this._jmsbridge = new JMSBridgeElement();
                    this._jmsbridge.setAttributes(this._attrs);
                } else if (string4.equals("link")) {
                    this._logger.log(Level.FINE, "new link: name=" + string5);
                    this._link = new LinkElement();
                    this._link.setAttributes(this._attrs);
                } else if (string4.equals("target")) {
                    this._logger.log(Level.FINE, "target");
                    this._target = new TargetElement();
                    this._target.setAttributes(this._attrs);
                } else if (string4.equals("dmq")) {
                    this._logger.log(Level.FINE, "new dmq: name=" + string5);
                    this._dmq = new DMQElement();
                    this._dmq.setAttributes(this._attrs);
                }
            } else if (string4.equals("property")) {
                string8 = attributes.getValue(0);
                string9 = attributes.getValue(1);
                this._logger.log(Level.FINE, "prop:" + string8 + "=" + string9);
                this._props.put(string8, string9);
            } else if (!string4.equals("description")) {
                throw new SAXException("Unknow element " + string4);
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new SAXException(exception.getMessage(), exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3;
        this._logger.log(Level.FINE, "startElement: uri=" + string + ", localName=" + string2 + ", qName=" + string3);
        try {
            if (string4.equals("connection-factory")) {
                this._logger.log(Level.FINE, "add connection factory: " + this._refname);
                ConnectionFactoryElement connectionFactoryElement = new ConnectionFactoryElement();
                connectionFactoryElement.setAttributes(this._attrs);
                connectionFactoryElement.setProperties(this._props);
                this._jmsbridge.addCF(this._refname, connectionFactoryElement);
            } else if (string4.equals("destination")) {
                this._logger.log(Level.FINE, "add destination: " + this._refname);
                DestinationElement destinationElement = new DestinationElement();
                destinationElement.setAttributes(this._attrs);
                destinationElement.setProperties(this._props);
                this._jmsbridge.addDestination(this._refname, destinationElement);
            } else if (string4.equals("link")) {
                this._jmsbridge.addLink(this._link);
            } else if (string4.equals("dmq")) {
                this._dmq.setProperties(this._props);
                this._jmsbridge.addDMQ(this._dmq);
            } else if (string4.equals("source")) {
                this._logger.log(Level.FINE, "set source: " + this._attrs + " to " + this._link);
                this._link.setSource(this._attrs);
            } else if (string4.equals("target")) {
                this._logger.log(Level.FINE, "set target: " + this._attrs + " to " + this._link);
                this._target.setProperties(this._props);
                this._link.setTarget(this._target);
            } else if (string4.equals("jmsbridge")) {
                this._logger.log(Level.FINE, "End of Document");
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new SAXException(exception.getMessage(), exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._logger.log(Level.FINE, "XML Parser characters: " + String.valueOf(cArray, n, n2));
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._logger.log(Level.WARNING, sAXParseException.getSystemId() + ", line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._logger.log(Level.SEVERE, sAXParseException.getSystemId() + ", line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._logger.log(Level.SEVERE, sAXParseException.getSystemId() + ", line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        super.fatalError(sAXParseException);
        throw sAXParseException;
    }
}

