/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenType;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXException;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Extra;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class AMXValidator {
    private static final String NL = StringUtil.NEWLINE();
    private final MBeanServerConnection mMBeanServer;
    private final ProxyFactory mProxyFactory;
    private final DomainRoot mDomainRoot;
    private MBeanTrackerMBean mMBeanTracker;
    private static Set<Class> EXTRA_ALLOWED_TYPES = SetUtil.newTypedSet(JMXServiceURL.class, CompositeDataSupport.class);
    private static final Pattern TYPE_PATTERN = Pattern.compile("([**$a-zA-Z0-9._-][**$a-zA-Z0-9._-]*)");
    private static final Pattern NAME_PATTERN = Pattern.compile("[^]]*");

    private static void debug(Object o) {
        System.out.println(o.toString());
    }

    public AMXValidator(MBeanServerConnection conn) {
        this.mMBeanServer = conn;
        this.mProxyFactory = ProxyFactory.getInstance(conn);
        this.mDomainRoot = this.mProxyFactory.getDomainRootProxy(false);
    }

    private String toString(Throwable t) {
        return ExceptionUtil.toString(ExceptionUtil.getRootCause(t));
    }

    private static boolean isAcceptableRemoteType(Class<?> c) {
        if (c.isPrimitive() || EXTRA_ALLOWED_TYPES.contains(c) || OpenType.ALLOWED_CLASSNAMES_LIST.contains(c.getName())) {
            return true;
        }
        return c.isArray() && AMXValidator.isAcceptableRemoteType(c.getComponentType());
    }

    private static void checkLegalForRemote(Object value) throws IllegalClassException {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (AMXValidator.isAcceptableRemoteType(clazz)) {
            return;
        }
        if (clazz.isSynthetic() || clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) {
            throw new IllegalClassException(clazz);
        }
        if (clazz.isArray()) {
            if (!AMXValidator.isAcceptableRemoteType(clazz.getComponentType())) {
                Object[] a;
                for (Object o : a = (Object[])value) {
                    AMXValidator.checkLegalForRemote(o);
                }
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            Collection items = (Collection)value;
            for (Object o : items) {
                AMXValidator.checkLegalForRemote(o);
            }
        } else if (Map.class.isAssignableFrom(clazz)) {
            Map items = (Map)value;
            for (Object key : items.keySet()) {
                AMXValidator.checkLegalForRemote(key);
                AMXValidator.checkLegalForRemote(items.get(key));
            }
        } else {
            throw new IllegalClassException(clazz);
        }
    }

    boolean instanceNotFound(Throwable t) {
        return ExceptionUtil.getRootCause(t) instanceof InstanceNotFoundException;
    }

    private void addToProblems(String msg, List<String> problems, Throwable t) {
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        if (!this.instanceNotFound(rootCause)) {
            problems.add(msg + rootCause.toString());
        }
    }

    private void addToProblems(List<String> problems, Throwable t) {
        this.addToProblems("", problems, t);
    }

    private List<String> _validate(AMXProxy proxy) {
        ArrayList<String> problems = new ArrayList<String>();
        ObjectName objectName = proxy.objectName();
        try {
            this.validateObjectName(proxy);
        }
        catch (Throwable t) {
            this.addToProblems(problems, t);
        }
        List<String> temp = null;
        try {
            temp = this.validateMetadata(proxy);
            if (temp != null) {
                problems.addAll(temp);
            }
        }
        catch (Throwable t) {
            this.addToProblems(problems, t);
        }
        try {
            this.validateRequiredAttributes(proxy);
        }
        catch (Throwable t) {
            this.addToProblems(problems, t);
        }
        try {
            String name = proxy.getName();
        }
        catch (Throwable t) {
            this.addToProblems("Proxy access to 'Name' failed: ", problems, t);
        }
        try {
            ObjectName parent = proxy.getParent();
        }
        catch (Throwable t) {
            this.addToProblems("Proxy access to 'Parent' failed: ", problems, t);
        }
        try {
            ObjectName[] children = proxy.getChildren();
        }
        catch (Throwable t) {
            this.addToProblems("Proxy access to 'Children' failed: ", problems, t);
        }
        Pathnames paths = this.mDomainRoot.getPathnames();
        try {
            String path = proxy.path();
            ObjectName actualObjectName = proxy.objectName();
            ObjectName o = paths.resolvePath(path);
            if (o == null) {
                if (proxy.valid()) {
                    problems.add("Path " + path + " does not resolve to any ObjectName, should resolve to: " + actualObjectName);
                }
            } else if (!actualObjectName.equals(o)) {
                problems.add("Path " + path + " does not resolve to ObjectName: " + actualObjectName);
            }
        }
        catch (Throwable t) {
            this.addToProblems(problems, t);
        }
        Set<String> attributeNames = proxy.extra().attributeNames();
        for (String attrName : attributeNames) {
            try {
                Object result = proxy.extra().getAttribute(attrName);
                AMXValidator.checkLegalForRemote(result);
            }
            catch (Throwable t) {
                this.addToProblems("Attribute failed: '" + attrName + "': ", problems, t);
            }
        }
        Object tempProblems = null;
        try {
            this.validateChildren(proxy);
        }
        catch (Throwable t) {
            this.addToProblems(problems, t);
        }
        try {
            AMXProxy parent = proxy.parent();
            if (parent == null && !proxy.type().equals(Util.deduceType(DomainRoot.class))) {
                throw new Exception("Null parent");
            }
            String nameProp = proxy.nameProp();
            boolean valid = proxy.valid();
            String path = proxy.path();
            Extra extra = proxy.extra();
            String interfaceName = extra.interfaceName();
            MBeanInfo mbeanInfo = extra.mbeanInfo();
            String group = extra.group();
            Class<? extends AMXProxy> genericInterface = extra.genericInterface();
            boolean invariantMBeanInfo = extra.isInvariantMBeanInfo();
            boolean supportsAdoption = extra.supportsAdoption();
            String[] subTypes = extra.subTypes();
            Set<AMXProxy> childrenSet = proxy.childrenSet();
            Map<String, Map<String, AMXProxy>> childrenMaps = proxy.childrenMaps();
            Map<String, Object> attributesMap = proxy.attributesMap();
            Set<String> attrNames = proxy.attributeNames();
            if (!((Object)attrNames).equals(attributesMap.keySet())) {
                throw new Exception("Attributes Map differs from attribute names");
            }
            for (AMXProxy child : childrenSet) {
                if (!child.extra().singleton()) continue;
                String childType = child.type();
                if (child.objectName().equals(proxy.child(childType).objectName())) continue;
                throw new Exception("Child type " + childType + " cannot be found via child(type)");
            }
            for (String type : childrenMaps.keySet()) {
                Map<String, AMXProxy> m = proxy.childrenMap(type);
                if (m.keySet().size() != 0) continue;
                throw new Exception("Child type " + type + " has nothing in Map");
            }
        }
        catch (Throwable t) {
            this.addToProblems("General test failure: ", problems, t);
        }
        try {
            this.validateAMXConfig(proxy, problems);
        }
        catch (Throwable t) {
            this.addToProblems("General test failure in validateAMXConfig: ", problems, t);
        }
        return problems;
    }

    private void fail(ObjectName objectName, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(objectName, msg);
    }

    private void fail(AMXProxy amx, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(amx, msg);
    }

    private void validateAMXConfig(AMXProxy proxy, List<String> problems) {
        if (!AMXConfigProxy.class.isAssignableFrom(proxy.extra().genericInterface())) {
            return;
        }
        AMXConfigProxy config = proxy.as(AMXConfigProxy.class);
        if (!config.type().equals("domain") && !AMXConfigProxy.class.isAssignableFrom(config.parent().extra().genericInterface())) {
            problems.add("AMXConfig MBean is not a descendant of Domain: " + config.objectName());
        }
        Map<String, String> defaultValues = config.getDefaultValues(false);
        Map<String, String> defaultValuesAMX = config.getDefaultValues(true);
        if (defaultValues.keySet().size() != defaultValuesAMX.keySet().size()) {
            problems.add("Default values for AMX names differ in number from XML names: " + defaultValues.keySet().size() + " != " + defaultValuesAMX.keySet().size());
        }
        for (String key : defaultValues.keySet()) {
            String value = defaultValues.get(key);
            if (value == null) {
                problems.add("Default value of null for: " + key);
                continue;
            }
            if (value instanceof String) continue;
            problems.add("Default value is not a String for: " + key);
        }
        String[] subTypes = config.extra().subTypes();
        if (subTypes != null) {
            for (String subType : subTypes) {
                Map<String, String> subTypeDefaults = config.getDefaultValues(subType, false);
            }
        }
    }

    private void validateObjectName(AMXProxy proxy) throws ValidationFailureException {
        String nameProp;
        ObjectName objectName = proxy.objectName();
        String type = objectName.getKeyProperty("type");
        if (type == null || type.length() == 0) {
            this.fail(objectName, "type property required in ObjectName");
        }
        if (!TYPE_PATTERN.matcher(type).matches()) {
            this.fail(objectName, "Illegal type \"" + type + "\", does not match " + TYPE_PATTERN.pattern());
        }
        if ((nameProp = objectName.getKeyProperty("name")) != null) {
            if (nameProp.length() == 0) {
                this.fail(objectName, "name property of ObjectName may not be empty");
            }
            if (!NAME_PATTERN.matcher(nameProp).matches()) {
                this.fail(objectName, "Illegal name \"" + nameProp + "\", does not match " + NAME_PATTERN.pattern());
            }
        } else {
            String name = proxy.getName();
            if (!name.equals("")) {
                this.fail(objectName, "getName() returned a non-empty name for a singleton: " + name);
            }
            if (!proxy.extra().singleton()) {
                this.fail(objectName, "Metadata claims named (non-singleton), but no name property present in ObjectName");
            }
        }
        if (proxy.parent() != null && !proxy.parentPath().equals(proxy.parent().path())) {
            this.fail(objectName, "Parent path of " + proxy.parentPath() + " does not match parent's path for  parent " + proxy.parent().objectName());
        }
    }

    private void validateChildren(AMXProxy proxy) throws ValidationFailureException {
        block19: {
            Set<String> attrNames = proxy.attributeNames();
            if (!attrNames.contains("Children")) {
                try {
                    ObjectName[] children = proxy.getChildren();
                    this.fail(proxy, "MBean has no Children attribute in its MBeanInfo, but supplies the attribute");
                }
                catch (Exception e) {}
            } else {
                block18: {
                    try {
                        Set<ObjectName> childrenSetNow;
                        Set<ObjectName> childrenSet;
                        ObjectName[] children = proxy.getChildren();
                        if (children == null) {
                            this.fail(proxy, "Children attribute must be non-null");
                        }
                        if ((childrenSet = SetUtil.newSet(children)).size() != children.length) {
                            this.fail(proxy, "Children contains duplicates");
                        }
                        if (childrenSet.contains(null)) {
                            this.fail(proxy, "Children contains null");
                        }
                        for (ObjectName childObjectName : children) {
                            if (childObjectName == null) {
                                this.fail(proxy, "Child in Children array is null");
                            }
                            AMXProxy child = this.mProxyFactory.getProxy(childObjectName);
                            if (proxy.objectName().equals(child.parent().objectName())) continue;
                            this.fail(proxy, "Child\u00e2\u0080\u0099s Parent of " + child.parent().objectName() + " does not match the actual parent of " + proxy.objectName());
                        }
                        HashSet<String> caseSensitiveTypes = new HashSet<String>();
                        HashSet<String> caseInsensitiveTypes = new HashSet<String>();
                        for (ObjectName o : children) {
                            caseSensitiveTypes.add(Util.getTypeProp(o));
                            caseInsensitiveTypes.add(Util.getTypeProp(o).toLowerCase());
                        }
                        if (caseSensitiveTypes.size() != caseInsensitiveTypes.size()) {
                            this.fail(proxy, "Children types must be case-insensitive");
                        }
                        Set<ObjectName> tracked = this.getMBeanTracker().getChildrenOf(proxy.objectName());
                        if (childrenSet.size() != children.length && !((Object)tracked).equals(childrenSetNow = SetUtil.newSet(proxy.getChildren()))) {
                            this.fail(proxy, "MBeanTracker has different MBeans than the MBean: {" + CollectionUtil.toString(tracked, ", ") + "} vs MBean having {" + CollectionUtil.toString(childrenSetNow, ", ") + "}");
                        }
                    }
                    catch (Exception e) {
                        if (this.instanceNotFound(e)) break block18;
                        this.fail(proxy, "MBean failed to supply Children attribute");
                    }
                }
                try {
                    Map<String, Map<String, AMXProxy>> maps = proxy.childrenMaps();
                    for (String type : maps.keySet()) {
                        Map<String, AMXProxy> siblings = maps.get(type);
                        if (siblings.keySet().size() <= 1) continue;
                        Iterator<AMXProxy> iter = siblings.values().iterator();
                        MBeanInfo mbeanInfo = iter.next().extra().mbeanInfo();
                        while (iter.hasNext()) {
                            AMXProxy next = iter.next();
                            if (mbeanInfo.equals(next.extra().mbeanInfo())) continue;
                            this.fail(proxy, "Children of type " + type + " must  have the same MBeanInfo");
                        }
                    }
                }
                catch (Exception e) {
                    if (this.instanceNotFound(e)) break block19;
                    this.fail(proxy, "MBean failed validating the MBeanInfo of children");
                }
            }
        }
    }

    private MBeanTrackerMBean getMBeanTracker() {
        if (this.mMBeanTracker == null) {
            this.mMBeanTracker = MBeanServerInvocationHandler.newProxyInstance(this.mMBeanServer, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
        }
        return this.mMBeanTracker;
    }

    private List<String> validateMetadata(AMXProxy proxy) {
        ArrayList<String> problems = new ArrayList<String>();
        MBeanInfo mbeanInfo = proxy.extra().mbeanInfo();
        Descriptor d = mbeanInfo.getDescriptor();
        Set<String> LEGAL_AMX_DESCRIPTORS = SetUtil.newStringSet("amx.genericInterfaceName", "amx.isSingleton", "amx.isGlobalSingleton", "amx.group", "amx.supportsAdoption", "amx.subTypes");
        for (String fieldName : d.getFieldNames()) {
            if (!fieldName.startsWith("amx.") || LEGAL_AMX_DESCRIPTORS.contains(fieldName)) continue;
            problems.add("Illegal/unknown AMX metadata field: " + fieldName + " = " + d.getFieldValue(fieldName));
        }
        MetadataValidator val = new MetadataValidator(d, problems);
        val.validateMetadataBoolean("amx.isSingleton");
        val.validateMetadataBoolean("amx.supportsAdoption");
        val.validateMetadataBoolean("immutableInfo");
        val.validateMetadataStringNonEmpty("interfaceName");
        val.validateMetadataStringNonEmpty("amx.genericInterfaceName");
        val.validateMetadataStringNonEmpty("amx.group");
        val.validate("amx.subTypes", String[].class);
        for (MBeanAttributeInfo mBeanAttributeInfo : mbeanInfo.getAttributes()) {
            new MetadataValidator(mBeanAttributeInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getOperations()) {
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getConstructors()) {
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbeanInfo.getNotifications()) {
            new MetadataValidator(mBeanFeatureInfo.getDescriptor(), problems);
        }
        if (proxy.extra().globalSingleton()) {
            ObjectName objectName = proxy.objectName();
            ObjectName pattern = Util.newObjectNamePattern(objectName.getDomain(), Util.makeTypeProp(Util.getTypeProp(objectName)));
            try {
                long start = System.currentTimeMillis();
                Set<ObjectName> instances = this.mMBeanServer.queryNames(pattern, null);
                long elapsed = System.currentTimeMillis() - start;
                if (instances.size() > 1) {
                    problems.add("Global singleton " + objectName + " conflicts with other MBeans of the same type: " + CollectionUtil.toString(instances, ", "));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return problems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateRequiredAttributes(AMXProxy proxy) throws ValidationFailureException {
        ObjectName objectName = proxy.objectName();
        Map<String, MBeanAttributeInfo> infos = JMXUtil.attributeInfosToMap(proxy.extra().mbeanInfo().getAttributes());
        Set<String> attrNames = infos.keySet();
        if (!attrNames.contains("Name")) {
            this.fail(objectName, "MBeanInfo does not contain Name attribute");
        }
        if (!attrNames.contains("Parent")) {
            this.fail(objectName, "MBeanInfo does not contain Parent attribute");
        }
        if (attrNames.contains("Children")) {
            try {
                if (proxy.getChildren() != null) return;
                this.fail(objectName, "value of Children attribute must not be null");
                return;
            }
            catch (AMXException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.instanceNotFound(e)) return;
                this.fail(objectName, "does not supply children correctly");
                return;
            }
        }
        try {
            proxy.getChildren();
            this.fail(objectName, "Children attribute is present, but not listed in MBeanInfo");
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void unregisterNonCompliantMBean(ObjectName objectName) {
        try {
            this.mMBeanServer.unregisterMBean(objectName);
            AMXValidator.debug("Unregistered non-compliant MBean " + objectName);
        }
        catch (Exception ignore) {
            AMXValidator.debug("Unable to unregister non-compliant MBean " + objectName);
        }
    }

    public ValidationResult validate(ObjectName[] targets) {
        long startMillis = System.currentTimeMillis();
        Failures failures = new Failures();
        DomainRoot dr = this.mDomainRoot;
        for (ObjectName objectName : targets) {
            AMXProxy amx;
            ArrayList<String> problems;
            block7: {
                problems = new ArrayList();
                amx = null;
                try {
                    amx = this.mProxyFactory.getProxy(objectName);
                }
                catch (Exception e) {
                    if (this.instanceNotFound(e)) break block7;
                    AMXValidator.debug("Unable to create AMXProxy for " + objectName);
                    e.printStackTrace();
                    String msg = "Cannot create AMXProxy for MBean \"" + objectName + "\" -- MBean is  non-compliant, unregistering it.";
                    problems.add(msg);
                }
            }
            if (amx != null) {
                try {
                    problems = this._validate(amx);
                }
                catch (Exception e) {
                    problems = new ArrayList();
                    this.addToProblems("Validation failure for MBean " + objectName + ", ", problems, e);
                }
            }
            if (problems.size() != 0) {
                this.unregisterNonCompliantMBean(objectName);
            }
            failures.result(objectName, problems);
        }
        long elapsedMillis = System.currentTimeMillis() - startMillis;
        ValidationResult result = new ValidationResult(failures.getNumTested(), failures.getNumFailures(), failures.toString());
        return result;
    }

    public ValidationResult validate(ObjectName objectName) {
        return this.validate(new ObjectName[]{objectName});
    }

    public ValidationResult validate() {
        List<ObjectName> all = Util.toObjectNameList(this.mDomainRoot.getQueryMgr().queryAll());
        return this.validate(CollectionUtil.toArray(all, ObjectName.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Failures {
        private final ConcurrentMap<ObjectName, List<String>> mFailures = new ConcurrentHashMap<ObjectName, List<String>>();
        private AtomicInteger mNumTested = new AtomicInteger();

        public int getNumTested() {
            return this.mNumTested.get();
        }

        public int getNumFailures() {
            return this.mFailures.keySet().size();
        }

        public Map<ObjectName, List<String>> getFailures() {
            return this.mFailures;
        }

        void result(ObjectName objectName, List<String> problems) {
            this.mNumTested.incrementAndGet();
            if (problems != null && problems.size() != 0) {
                this.mFailures.put(objectName, problems);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ObjectName badBoy : this.mFailures.keySet()) {
                List failures = (List)this.mFailures.get(badBoy);
                builder.append(badBoy + NL);
                builder.append(CollectionUtil.toString(failures, NL));
                builder.append(NL);
                builder.append(NL);
            }
            builder.append(this.mFailures.size() + " failures.");
            return builder.toString() + NL + this.mNumTested + " MBeans tested.";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IllegalClassException
    extends Exception {
        private final Class<?> mClass;

        public IllegalClassException(Class<?> clazz) {
            super("Class " + clazz.getName() + " not allowed for AMX MBeans");
            this.mClass = clazz;
        }

        public Class<?> clazz() {
            return this.mClass;
        }

        @Override
        public String toString() {
            return super.getMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetadataValidator {
        private final Descriptor mDescriptor;
        private final Set<String> mFieldNames;
        private final List<String> mProblems;

        public MetadataValidator(Descriptor d, List<String> problems) {
            this.mDescriptor = d;
            this.mFieldNames = SetUtil.newSet(d.getFieldNames());
            this.mProblems = problems;
            this.validateRemote();
        }

        void validateRemote() {
            for (String fieldName : this.mFieldNames) {
                try {
                    AMXValidator.checkLegalForRemote(this.mDescriptor.getFieldValue(fieldName));
                }
                catch (IllegalClassException e) {
                    this.mProblems.add("Descriptor field " + fieldName + " uses a remote-unfriendly class: " + e.clazz().getName());
                }
            }
        }

        void validateMetadataBoolean(String fieldName) {
            if (this.mFieldNames.contains(fieldName)) {
                Object value = this.mDescriptor.getFieldValue(fieldName);
                if (value == null) {
                    this.mProblems.add("Descriptor field " + fieldName + " must not be null");
                } else if (!(value instanceof Boolean || value.equals("true") || value.equals("false"))) {
                    this.mProblems.add("Descriptor field " + fieldName + " must be set to 'true' or 'false', value is " + value);
                }
            }
        }

        void validateMetadataStringNonEmpty(String fieldName) {
            Object value;
            if (this.mFieldNames.contains(fieldName) && ((value = this.mDescriptor.getFieldValue(fieldName)) == null || !(value instanceof String) || ((String)value).length() == 0)) {
                this.mProblems.add("Descriptor field " + fieldName + " must be non-zero length String, value = " + value);
            }
        }

        void validate(String fieldName, Class<?> clazz) {
            Object value;
            if (this.mFieldNames.contains(fieldName) && ((value = this.mDescriptor.getFieldValue(fieldName)) == null || !clazz.isAssignableFrom(value.getClass()))) {
                this.mProblems.add("Descriptor field " + fieldName + " must be of class " + clazz.getSimpleName());
            }
        }
    }

    private static final class ValidationFailureException
    extends Exception {
        private final ObjectName mObjectName;

        public ValidationFailureException(ObjectName objectName, String msg) {
            super(msg);
            this.mObjectName = objectName;
        }

        public ValidationFailureException(AMXProxy amx, String msg) {
            this(amx.objectName(), msg);
        }

        public ObjectName objectName() {
            return this.mObjectName;
        }

        public String toString() {
            return this.getMessage() + ", " + this.mObjectName;
        }
    }

    public static final class ValidationResult {
        private final String mDetails;
        private final int mNumTested;
        private final int mNumFailures;

        public ValidationResult(int numTested, int numFailures, String details) {
            this.mNumTested = numTested;
            this.mNumFailures = numFailures;
            this.mDetails = details;
        }

        public String details() {
            return this.mDetails;
        }

        public int numTested() {
            return this.mNumTested;
        }

        public int numFailures() {
            return this.mNumFailures;
        }

        public String toString() {
            return this.details();
        }
    }
}

