/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolProbeProvider;

public class ConnectionPoolEmitterImpl
implements PoolLifeCycleListener {
    private String poolName;
    private ConnectorConnPoolProbeProvider connectorConnProbeProvider;
    private JdbcConnPoolProbeProvider jdbcProbeProvider;

    public ConnectionPoolEmitterImpl(String poolName) {
        this.poolName = poolName;
        this.connectorConnProbeProvider = ConnectorRuntime.getRuntime().getConnectorConnPoolProvider();
        this.jdbcProbeProvider = ConnectorRuntime.getRuntime().getJdbcConnPoolProvider();
    }

    public void toString(StringBuffer stackTrace) {
        stackTrace.append("\n Monitoring Statistics for \n" + this.poolName);
        this.connectorConnProbeProvider.toString(this.poolName, stackTrace);
        this.jdbcProbeProvider.toString(this.poolName, stackTrace);
    }

    public void connectionAcquired() {
        this.connectorConnProbeProvider.connectionAcquiredEvent(this.poolName);
        this.jdbcProbeProvider.connectionAcquiredEvent(this.poolName);
    }

    public void connectionRequestServed(long timeTakenInMillis) {
        this.connectorConnProbeProvider.connectionRequestServedEvent(this.poolName, timeTakenInMillis);
        this.jdbcProbeProvider.connectionRequestServedEvent(this.poolName, timeTakenInMillis);
    }

    public void connectionTimedOut() {
        this.connectorConnProbeProvider.connectionTimedOutEvent(this.poolName);
        this.jdbcProbeProvider.connectionTimedOutEvent(this.poolName);
    }

    public void connectionNotMatched() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectionMatched() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectionDestroyed() {
        this.connectorConnProbeProvider.connectionDestroyedEvent(this.poolName);
        this.jdbcProbeProvider.connectionDestroyedEvent(this.poolName);
    }

    public void connectionReleased() {
        this.connectorConnProbeProvider.connectionReleasedEvent(this.poolName);
        this.jdbcProbeProvider.connectionReleasedEvent(this.poolName);
    }

    public void connectionCreated() {
        this.connectorConnProbeProvider.connectionCreatedEvent(this.poolName);
        this.jdbcProbeProvider.connectionCreatedEvent(this.poolName);
    }

    public void foundPotentialConnectionLeak() {
        this.connectorConnProbeProvider.potentialConnLeakEvent(this.poolName);
        this.jdbcProbeProvider.potentialConnLeakEvent(this.poolName);
    }

    public void connectionValidationFailed(int count) {
        this.connectorConnProbeProvider.connectionValidationFailedEvent(this.poolName, count);
        this.jdbcProbeProvider.connectionValidationFailedEvent(this.poolName, count);
    }

    public void connectionUsed() {
        this.connectorConnProbeProvider.connectionUsedEvent(this.poolName);
        this.jdbcProbeProvider.connectionUsedEvent(this.poolName);
    }

    public void connectionsFreed(int count) {
        this.connectorConnProbeProvider.connectionsFreedEvent(this.poolName, count);
        this.jdbcProbeProvider.connectionsFreedEvent(this.poolName, count);
    }

    public void decrementConnectionUsed(boolean beingDestroyed, int steadyPoolSize) {
        this.connectorConnProbeProvider.decrementConnectionUsedEvent(this.poolName, beingDestroyed, steadyPoolSize);
        this.jdbcProbeProvider.decrementConnectionUsedEvent(this.poolName, beingDestroyed, steadyPoolSize);
    }

    public void decrementFreeConnectionsSize(int steadyPoolSize) {
        this.connectorConnProbeProvider.decrementFreeConnectionsSizeEvent(this.poolName, steadyPoolSize);
        this.jdbcProbeProvider.decrementFreeConnectionsSizeEvent(this.poolName, steadyPoolSize);
    }
}

