/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-connector-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.connector.resource")
public class DeleteConnectorResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorResource.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="connector_resource_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    ConnectorResource[] connectorResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.noJndiName", "No JNDI name defined for connector resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.isResourceExists(this.resources, this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.notfound", "A connector resource named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (ConnectorResource resource : DeleteConnectorResource.this.connectorResources) {
                        if (!resource.getJndiName().equals(DeleteConnectorResource.this.jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                report.setMessage(localStrings.getLocalString("delete.connector.resource.fail", "Connector resource {0} delete failed ", new Object[]{this.jndiName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            targetServer.deleteResourceRef(this.jndiName);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.fail", "Connector resource {0} delete failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.connector.resource.success", "Connector resource {0} deleted successfully", new Object[]{this.jndiName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ConnectorResource) || !((ConnectorResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

