/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.glassfish.appclient.client.AppClientFacade;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.jws.boot.ErrorDisplayDialog;
import org.glassfish.appclient.client.jws.boot.LaunchSecurityHelper;

public class JWSAppClientContainerMain {
    public static final String SECURITY_CONFIG_PATH_PLACEHOLDER = "security.config.path";
    private static Logger logger = Logger.getLogger(JWSAppClientContainerMain.class.getName());
    private static final ResourceBundle rb = ResourceBundle.getBundle(JWSAppClientContainerMain.class.getPackage().getName().replaceAll("\\.", "/") + ".LocalStrings");

    public static void main(String[] args) {
        try {
            long now = System.currentTimeMillis();
            String agentArgsText = System.getProperty("agent.args");
            LaunchSecurityHelper.setPermissions();
            AppClientFacade.prepareACC(agentArgsText, null);
            AppClientFacade.launch(args);
            logger.fine("JWSAppClientContainer finished after " + (System.currentTimeMillis() - now) + " ms");
        }
        catch (UserError ue) {
            ErrorDisplayDialog.showUserError(ue, rb);
        }
        catch (Throwable thr) {
            System.err.println(rb.getString("jwsacc.errorLaunch"));
            System.err.println(thr.toString());
            thr.printStackTrace();
            ErrorDisplayDialog.showErrors(thr, rb);
            System.exit(1);
        }
    }
}

