/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.standard.EventBean;
import org.jboss.webbeans.bean.standard.InstanceBean;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.resolution.ResolvableTransformer;
import org.jboss.webbeans.resolution.TypeSafeResolver;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<T> {
    private final BeanManagerImpl manager;
    public static final Set<ResolvableTransformer> TRANSFORMERS = new HashSet<ResolvableTransformer>();

    public TypeSafeBeanResolver(BeanManagerImpl manager, Iterable<T> beans) {
        super(beans);
        this.manager = manager;
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        return Reflections.isAssignableFrom(resolvable.getTypeClosure(), bean.getTypes()) && Beans.containsAllBindings(resolvable.getBindings(), bean.getBindings(), this.manager);
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.retainHighestPrecedenceBeans(matched, this.manager.getEnabledDeploymentTypes());
    }

    @Override
    protected Iterable<ResolvableTransformer> getTransformers() {
        return TRANSFORMERS;
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    static {
        TRANSFORMERS.add(EventBean.TRANSFORMER);
        TRANSFORMERS.add(InstanceBean.TRANSFORMER);
    }
}

