/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.jms.ra.EmbeddedBrokerRunner;
import com.sun.messaging.jms.ra.LocalBrokerRunner;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.resource.spi.ResourceAdapterInternalException;

public class LifecycleManagedBroker {
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    private static final String BROKER_TYPE_SOMEDIRECT = "DIRECT";
    private static final String BROKER_TYPE_APIDIRECT = "APIDIRECT";
    private static final String BROKER_TYPE_RADIRECT = "RADIRECT";
    private static final transient String _className = "com.sun.messaging.jms.ra.LifecycleManagedBroker";
    private static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    private static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    private static final transient Logger _loggerB = Logger.getLogger("javax.resourceadapter.mqjmsra");
    private static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    private static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    private transient EmbeddedBrokerRunner ebr = null;
    private transient LocalBrokerRunner lbr = null;
    private static JMSService jmsservice = null;
    private transient boolean started;
    private transient boolean _stopping;
    private transient boolean _lbStarted = false;
    private transient boolean doBind = true;
    private static transient boolean _startedAtLeastOnce;
    private static transient int _rmiRegistryPort;
    private String requestedBrokerType = "REMOTE";
    private String actualBrokerType = "REMOTE";
    private String brokerInstanceName = "imqbroker";
    private String brokerBindAddress = null;
    private int rmiRegistryPort = 1099;
    private boolean startRmiRegistry = false;
    private int brokerPort = 7676;
    private String brokerHomeDir = null;
    private String brokerLibDir = null;
    private String brokerVarDir = null;
    private String brokerJavaDir = null;
    private String brokerArgs = null;
    private boolean useJNDIRmiServiceURL = true;
    private boolean useSSLJMXConnector = true;
    private String masterBroker = null;
    private String brokerId = null;
    private int brokerStartTimeout = 10000;
    private String adminPassFile = null;
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private boolean brokerEnableHA = false;
    private String clusterId = null;
    private String dbType = null;
    private String connectionURL = "";
    public static final String DB_TYPE_DERBY = "derby";
    public static final String DB_TYPE_HADB = "hadb";
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final String DB_TYPE_POINTBASE = "pointbase";
    public static final String DB_TYPE_CLOUDSCAPE = "cloudscape";
    private static transient String IMQ_BROKERID;
    private static transient String IMQ_JDBC_VENDOR;
    private static transient String HADB_USER;
    private static transient String HADB_PASSWORD;
    private static transient String HADB_SERVERLIST;
    private static transient String IMQ_HADB;
    private static transient String IMQ_HADB_DSPROP;
    private static transient String IMQ_HADB_USER;
    private static transient String IMQ_HADB_PASSWORD;
    private static transient String IMQ_HADB_DSPROP_SERVERLIST;
    private Properties dbProps = new Properties();
    private Properties dsProps = new Properties();

    LifecycleManagedBroker() {
    }

    public synchronized void start() throws ResourceAdapterInternalException {
        this._stopping = false;
        if (BROKER_TYPE_LOCAL.equals(this.actualBrokerType)) {
            try {
                this.lbr = new LocalBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, this.rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassword, this.adminPassFile, this._getEffectiveBrokerProps());
                this.lbr.start();
                this._lbStarted = true;
            }
            catch (Exception exception) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting LOCAL broker=" + exception.getMessage());
                resourceAdapterInternalException.initCause((Throwable)exception);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                exception.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
        }
        if (BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType) || BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType)) {
            try {
                if (!_startedAtLeastOnce) {
                    _rmiRegistryPort = this.rmiRegistryPort;
                }
                if (this.ebr == null) {
                    this.ebr = new EmbeddedBrokerRunner(this.actualBrokerType, this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, _rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.adminUsername, this.adminPassword, this.adminPassFile, this.doBind, this._getEffectiveBrokerProps());
                    if (BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType)) {
                        this.ebr.init();
                    }
                }
                this.ebr.start();
                jmsservice = this.ebr.getJMSService();
                _startedAtLeastOnce = true;
            }
            catch (Exception exception) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting EMBEDDED broker=" + exception.getMessage());
                resourceAdapterInternalException.initCause((Throwable)exception);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                exception.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this._stopping = true;
        if (this.ebr != null) {
            this.ebr.stop();
            this.ebr = null;
        }
        if (this.lbr != null) {
            this.lbr.stop();
            this.lbr = null;
        }
        this.started = false;
    }

    private Properties _getEffectiveBrokerProps() {
        Properties properties = new Properties();
        properties.setProperty("imq.cluster.nowaitForMasterBroker", "true");
        if (BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType)) {
            properties.setProperty("imq.service.activate", "jmsdirect");
        }
        if (this.brokerEnableHA) {
            properties.setProperty("imq.cluster.ha", "true");
            if (this.clusterId != null) {
                properties.setProperty("imq.cluster.clusterid", this.clusterId);
            }
        } else {
            if (this.connectionURL != null && !"".equals(this.connectionURL)) {
                properties.setProperty("imq.cluster.brokerlist", this.connectionURL);
            }
            if (this.masterBroker != null) {
                properties.setProperty("imq.cluster.masterbroker", this.masterBroker);
            }
        }
        if (this.dbType != null) {
            properties.setProperty("imq.persist.store", "jdbc");
            if (DB_TYPE_HADB.equals(this.dbType)) {
                properties.setProperty(IMQ_JDBC_VENDOR, this.dbType);
                properties.setProperty(IMQ_BROKERID, this.brokerId);
                if (this.dbProps.containsKey(HADB_USER)) {
                    properties.setProperty(IMQ_HADB_USER, this.dbProps.getProperty(HADB_USER));
                }
                if (this.dbProps.containsKey(HADB_PASSWORD)) {
                    properties.setProperty(IMQ_HADB_PASSWORD, this.dbProps.getProperty(HADB_PASSWORD));
                }
                if (this.dsProps.containsKey(HADB_SERVERLIST)) {
                    properties.setProperty(IMQ_HADB_DSPROP_SERVERLIST, this.dsProps.getProperty(HADB_SERVERLIST));
                }
            }
        }
        return properties;
    }

    protected JMSService _getJMSService() {
        if (this.ebr == null) {
            return null;
        }
        if (jmsservice != null) {
            jmsservice = this.ebr.getJMSService();
        }
        return jmsservice;
    }

    protected static final JMSService _getRAJMSService() {
        return jmsservice;
    }

    public synchronized void setStartRmiRegistry(boolean bl) {
        _loggerL.entering(_className, "setStartRmiRegistry()", new Boolean(bl));
        if (this.started || _startedAtLeastOnce && (BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType))) {
            _loggerL.warning("MQJMSRA_RA2001: setStartRmiRegistry:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.startRmiRegistry + ":to:" + bl);
            return;
        }
        this.startRmiRegistry = bl;
    }

    public boolean getStartRmiRegistry() {
        _loggerL.entering(_className, "getStartRmiRegistry()", new Boolean(this.startRmiRegistry));
        return this.startRmiRegistry;
    }

    public synchronized void setRmiRegistryPort(int n) {
        _loggerL.entering(_className, "setRmiRegistryPort()", new Integer(n));
        if (this.started || _startedAtLeastOnce && (BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType))) {
            _loggerL.warning("MQJMSRA_RA2001: setRmiRegistryPort:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.rmiRegistryPort + ":to:" + n);
            return;
        }
        this.rmiRegistryPort = n;
    }

    public int getRmiRegistryPort() {
        _loggerL.entering(_className, "getRmiRegistryPort()", new Integer(this.rmiRegistryPort));
        return this.rmiRegistryPort;
    }

    public String getBrokerType() {
        return this.requestedBrokerType;
    }

    public synchronized void setBrokerType(String string) {
        _loggerL.entering(_className, "setBrokerType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:lifecycle managed broker already started:Disallowing change from:" + this.requestedBrokerType + ":to:" + string);
            return;
        }
        if ("DIRECT".equals(string) || BROKER_TYPE_EMBEDDED.equals(string)) {
            this.actualBrokerType = ResourceAdapter._isDirectDefault() ? "DIRECT" : BROKER_TYPE_EMBEDDED;
            if ("DIRECT".equals(this.actualBrokerType)) {
                this.actualBrokerType = ResourceAdapter._useAPIDirectImplementation() ? BROKER_TYPE_APIDIRECT : BROKER_TYPE_RADIRECT;
            }
        } else if (BROKER_TYPE_LOCAL.equals(string) || BROKER_TYPE_REMOTE.equals(string)) {
            this.actualBrokerType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + string + ":remaining at brokerType=" + this.requestedBrokerType);
        }
    }

    public boolean isLocal() {
        return BROKER_TYPE_LOCAL.equals(this.actualBrokerType);
    }

    public boolean isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.actualBrokerType);
    }

    public String getBrokerInstanceName() {
        _loggerL.entering(_className, "getBrokerInstanceName()", this.brokerInstanceName);
        return this.brokerInstanceName;
    }

    public synchronized void setBrokerInstanceName(String string) {
        _loggerL.entering(_className, "setBrokerInstanceName()", string);
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.brokerInstanceName = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerInstanceName:Invalid value:" + string);
        }
    }

    public synchronized void setBrokerBindAddress(String string) {
        _loggerL.entering(_className, "setBrokerBindAddress()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:RA already started:Disallowing change from:" + this.brokerBindAddress + ":to:" + string);
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.brokerBindAddress = string;
        }
        catch (UnknownHostException unknownHostException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:Ignoring Invalid Address:" + string + ":ExceptionMsg=" + unknownHostException.getMessage());
        }
    }

    public String getBrokerBindAddress() {
        _loggerL.entering(_className, "getBrokerBindAddress()", this.brokerBindAddress);
        return this.brokerBindAddress;
    }

    public synchronized void setBrokerPort(int n) {
        _loggerL.entering(_className, "setBrokerPort()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + n);
            return;
        }
        this.brokerPort = n;
    }

    public int getBrokerPort() {
        _loggerL.entering(_className, "getBrokerPort()", new Integer(this.brokerPort));
        return this.brokerPort;
    }

    public int getBrokerStartTimeout() {
        return this.brokerStartTimeout;
    }

    public void setBrokerStartTimeout(int n) {
        this.brokerStartTimeout = n;
    }

    public synchronized void setBrokerHomeDir(String string) {
        _loggerL.entering(_className, "setBrokerHomeDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:RA already started:Disallowing change from:" + this.brokerHomeDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerHomeDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerHomeDir() {
        _loggerL.entering(_className, "getBrokerHomeDir()", this.brokerHomeDir);
        return this.brokerHomeDir;
    }

    public synchronized void setBrokerLibDir(String string) {
        _loggerL.entering(_className, "setBrokerLibDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:RA already started:Disallowing change from:" + this.brokerLibDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerLibDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerLibDir() {
        _loggerL.entering(_className, "getBrokerLibDir()", this.brokerLibDir);
        return this.brokerLibDir;
    }

    public synchronized void setBrokerVarDir(String string) {
        _loggerL.entering(_className, "setBrokerVarDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:RA already started:Disallowing change from:" + this.brokerVarDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerVarDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerVarDir() {
        _loggerL.entering(_className, "getBrokerVarDir()", this.brokerVarDir);
        return this.brokerVarDir;
    }

    public synchronized void setBrokerJavaDir(String string) {
        _loggerL.entering(_className, "setBrokerJavaDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:RA already started:Disallowing change from:" + this.brokerJavaDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerJavaDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerJavaDir() {
        _loggerL.entering(_className, "getBrokerJavaDir()", this.brokerJavaDir);
        return this.brokerJavaDir;
    }

    public synchronized void setBrokerArgs(String string) {
        _loggerL.entering(_className, "setBrokerArgs()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerArgs:RA already started:Disallowing change from:" + this.brokerArgs + ":to:" + string);
            return;
        }
        this.brokerArgs = string;
    }

    public String getBrokerArgs() {
        _loggerL.entering(_className, "getBrokerArgs()", this.brokerArgs);
        return this.brokerArgs;
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean bl) {
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseJNDIRmiServiceURL:RA already started:Disallowing change from:" + this.useJNDIRmiServiceURL + ":to:" + bl);
            return;
        }
        this.useJNDIRmiServiceURL = bl;
    }

    public boolean getUseJNDIRmiServiceURL() {
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", new Boolean(this.useJNDIRmiServiceURL));
        return this.useJNDIRmiServiceURL;
    }

    public synchronized void setUseSSLJMXConnector(boolean bl) {
        _loggerL.entering(_className, "setUseSSLJMXConnector()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseSSLJMXConnector:RA already started:Disallowing change from:" + this.useSSLJMXConnector + ":to:" + bl);
            return;
        }
        this.useSSLJMXConnector = bl;
    }

    public boolean getUseSSLJMXConnector() {
        _loggerL.entering(_className, "getUseSSLJMXConnector()", new Boolean(this.useSSLJMXConnector));
        return this.useSSLJMXConnector;
    }

    public synchronized void setAdminUsername(String string) {
        _loggerL.entering(_className, "setAdminUsername()", string);
        this.adminUsername = string;
    }

    public String getAdminUsername() {
        _loggerL.entering(_className, "getAdminUsername()", this.adminUsername);
        return this.adminUsername;
    }

    public synchronized void setAdminPassword(String string) {
        _loggerL.entering(_className, "setAdminPassword()");
        this.adminPassword = string;
    }

    public String getAdminPassword() {
        _loggerL.entering(_className, "getAdminPassword()");
        return this.adminPassword;
    }

    public synchronized void setAdminPassFile(String string) {
        _loggerL.entering(_className, "setAdminPassFile()", string);
        this.adminPassFile = string;
    }

    public String getAdminPassFile() {
        _loggerL.entering(_className, "getAdminPassFile()", this.adminPassFile);
        return this.adminPassFile;
    }

    public synchronized void setBrokerEnableHA(boolean bl) {
        _loggerL.entering(_className, "setBrokerEnableHA()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerEnableHA:RA already started:Disallowing change from:" + this.brokerEnableHA + ":to:" + bl);
            return;
        }
        this.brokerEnableHA = bl;
    }

    public boolean getBrokerEnableHA() {
        _loggerL.entering(_className, "getBrokerEnableHA()", new Boolean(this.brokerEnableHA));
        return this.brokerEnableHA;
    }

    public synchronized void setClusterId(String string) {
        _loggerL.entering(_className, "setClusterId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:RA already started:Disallowing change from:" + this.clusterId + ":to:" + string);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.clusterId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:Invalid value:" + string);
        }
    }

    public String getClusterId() {
        _loggerL.entering(_className, "getClusterId()", this.clusterId);
        return this.clusterId;
    }

    public synchronized void setConnectionURL(String string) {
        String string2 = string;
        _loggerL.entering(_className, "setConnectionURL()", string2);
        this.connectionURL = string;
    }

    public String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        if ("".equals(this.connectionURL)) {
            _loggerL.fine("MQJMSRA_RA1101: getConnectionURL:returning default of 'localhost' for empty connectionURL");
            return "localhost";
        }
        return this.connectionURL;
    }

    public synchronized void setMasterBroker(String string) {
        _loggerL.entering(_className, "setMasterBroker()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setMasterBroker:RA already started:Disallowing change from:" + this.masterBroker + ":to:" + string);
            return;
        }
        this.masterBroker = string;
    }

    public String getMasterBroker() {
        _loggerL.entering(_className, "getMasterBroker()", this.masterBroker);
        return this.masterBroker;
    }

    public synchronized void setBrokerId(String string) {
        _loggerL.entering(_className, "setBrokerId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:RA already started:Disallowing change from:" + this.brokerId + ":to:" + string);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.brokerId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:Invalid value:" + string);
        }
    }

    public String getBrokerId() {
        _loggerL.entering(_className, "getBrokerId()", this.brokerId);
        return this.brokerId;
    }

    public synchronized void setDBType(String string) {
        _loggerL.entering(_className, "setDBType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:RA already started:Disallowing change from:" + this.dbType + ":to:" + string);
            return;
        }
        if (DB_TYPE_HADB.equals(string) || DB_TYPE_ORACLE.equals(string) || DB_TYPE_POINTBASE.equals(string) || DB_TYPE_CLOUDSCAPE.equals(string) || DB_TYPE_DERBY.equals(string)) {
            this.dbType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:Invalid value:" + string);
        }
    }

    public String getDBType() {
        _loggerL.entering(_className, "getDBType()", this.dbType);
        return this.dbType;
    }

    public synchronized void setDBProps(Properties properties) {
        _loggerL.entering(_className, "setDBProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBProps:RA already started:Disallowing change from:" + this.dbProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dbProps = properties;
    }

    public Properties getDBProps() {
        _loggerL.entering(_className, "getDBProps()", this.dbProps);
        return this.dbProps;
    }

    public synchronized void setDSProps(Properties properties) {
        _loggerL.entering(_className, "setDSProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDSProps:RA already started:Disallowing change from:" + this.dsProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dsProps = properties;
    }

    public Properties getDSProps() {
        _loggerL.entering(_className, "getDSProps()", this.dsProps);
        return this.dsProps;
    }

    public boolean isDoBind() {
        return this.doBind;
    }

    public void setDoBind(boolean bl) {
        this.doBind = bl;
    }

    public PortMapperClientHandler getPortMapperClientHandler() {
        if (this.isRemote() || this.isLocal()) {
            throw new IllegalStateException("Cannot access PortMapperClientHandler for LOCAL or REMOTE brokers");
        }
        if (this.isStarted()) {
            return Globals.getPortMapper();
        }
        throw new IllegalStateException("Cannot access PortMapperClientHandler until embedded broker has been started ");
    }

    private static final boolean isNameValidAlphaNumeric_(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SJSMQ LifecycleManagedBroker configuration=\n\tbrokerInstanceName       =" + this.brokerInstanceName + "\n" + "\tbrokerBindAddress        =" + this.brokerBindAddress + "\n" + "\tbrokerPort               =" + this.brokerPort + "\n" + "\tbrokerHomeDir            =" + this.brokerHomeDir + "\n" + "\tbrokerLibDir             =" + this.brokerLibDir + "\n" + "\tbrokerVarDir             =" + this.brokerVarDir + "\n" + "\tbrokerJavaDir            =" + this.brokerJavaDir + "\n" + "\tbrokerArgs               =" + this.brokerArgs + "\n" + "\tMasterBroker             =" + this.masterBroker + "\n" + "\tbrokerId                 =" + this.brokerId + "\n" + "\tadminUsername            =" + this.adminUsername + "\n" + "\tadminPassword            =" + ("admin".equals(this.adminPassword) ? "<default>" : "<modified>") + "\n" + "\tadminPassFile            =" + this.adminPassFile + "\n" + "\tConnectionURL            =" + this.connectionURL + "\n" + "\tdbType                   =" + this.dbType + "\n" + "\tdbProps                  =" + (this.dbProps != null ? this.dbProps.toString() : "null") + "\n" + "\tdsProps                  =" + (this.dsProps != null ? this.dsProps.toString() : "null") + "\n" + "\tuseJNDIRmiServiceURL     =" + this.useJNDIRmiServiceURL + "\n" + "\tuseSSLJMXConnector       =" + this.useSSLJMXConnector + "\n" + "\tbrokerEnableHA           =" + this.brokerEnableHA + "\n" + "\tclusterId                =" + this.clusterId + "\n" + "\trmiRegistryPort          =" + this.rmiRegistryPort + "\n" + "\tstartRmiRegistry         =" + this.startRmiRegistry + "\n" + "\tbrokerStartTimeout       =" + this.brokerStartTimeout + "\n";
    }

    static {
        IMQ_BROKERID = "imq.brokerid";
        IMQ_JDBC_VENDOR = "imq.persist.jdbc.dbVendor";
        HADB_USER = "hadb.user";
        HADB_PASSWORD = "hadb.password";
        HADB_SERVERLIST = "hadb.serverList";
        IMQ_HADB = "imq.persist.jdbc.hadb";
        IMQ_HADB_DSPROP = IMQ_HADB + ".property";
        IMQ_HADB_USER = IMQ_HADB + ".user";
        IMQ_HADB_PASSWORD = IMQ_HADB + ".password";
        IMQ_HADB_DSPROP_SERVERLIST = IMQ_HADB_DSPROP + ".serverList";
    }
}

