/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="Keep-Alive Statistics")
public class KeepAliveStatsProvider {
    private final String name;
    private final CountStatisticImpl keepAliveConnectionsCount = new CountStatisticImpl("KeepAliveConnectionsCount", "count", "Number of connections in keep-alive mode");
    private final CountStatisticImpl flushesCount = new CountStatisticImpl("FlushesCount", "count", "Number of keep-alive connections that were closed");
    private final CountStatisticImpl hitsCount = new CountStatisticImpl("HitsCount", "count", "Number of requests received by connections in keep-alive mode");
    private final CountStatisticImpl refusalsCount = new CountStatisticImpl("RefusalsCount", "count", "Number of keep-alive connections that were rejected");
    private final CountStatisticImpl timeoutsCount = new CountStatisticImpl("TimeoutsCount", "count", "Number of keep-alive connections that timed out");

    public KeepAliveStatsProvider(String name) {
        this.name = name;
    }

    @ManagedAttribute(id="keep-alive-connections-count")
    @Description(value="Number of connections in keep-alive mode")
    public CountStatistic getKeepAliveConnectionsCount() {
        return this.keepAliveConnectionsCount;
    }

    @ManagedAttribute(id="flushes-count")
    @Description(value="Number of keep-alive connections that were closed")
    public CountStatistic getFlushesCount() {
        return this.flushesCount;
    }

    @ManagedAttribute(id="hits-count")
    @Description(value="Number of requests received by connections in keep-alive mode")
    public CountStatistic getHitsCount() {
        return this.hitsCount;
    }

    @ManagedAttribute(id="refusals-count")
    @Description(value="Number of keep-alive connections that were rejected")
    public CountStatistic getRefusalsCount() {
        return this.refusalsCount;
    }

    @ManagedAttribute(id="timeouts-count")
    @Description(value="Number of keep-alive connections that timed out")
    public CountStatistic getTimeoutsCount() {
        return this.timeoutsCount;
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountConnectionsEvent")
    public void incrementCountConnectionsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.keepAliveConnectionsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:decrementCountConnectionsEvent")
    public void decrementCountConnectionsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.keepAliveConnectionsCount.decrement();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountFlushesEvent")
    public void incrementCountFlushesEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.flushesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountHitsEvent")
    public void incrementCountHitsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.hitsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountRefusalsEvent")
    public void incrementCountRefusalsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.refusalsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountTimeoutsEvent")
    public void incrementCountTimeoutsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.timeoutsCount.increment();
        }
    }
}

