/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.management.Attribute;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AuthRealm;
import org.glassfish.admin.amx.intf.config.MessageSecurityConfig;
import org.glassfish.admin.amx.intf.config.ProviderConfig;
import org.glassfish.admin.amx.intf.config.SecurityService;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHandler {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList;
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";
    private static final String COMMON_BUNDLE = "org.glassfish.common.admingui.Strings";

    public static void getRealmAttrForCreate(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        HashMap<String, Boolean> attrMap = new HashMap<String, Boolean>();
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", new ArrayList());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AuthRealm realm = (AuthRealm)V3AMX.objectNameToProxy(objectNameStr).as(AuthRealm.class);
        Map origProps = realm.getProperty();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put(PROPERTY_NAME, realm.getName());
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = realm.getClassname();
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            List props = V3AMX.getChildrenMapForTableList((AMXProxy)realm, "property", skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", V3AMX.getPropValue(origProps, "file"));
                attrMap.put("fileJaax", V3AMX.getPropValue(origProps, "jaas-context"));
                attrMap.put("fileAsGroups", V3AMX.getPropValue(origProps, "assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", V3AMX.getPropValue(origProps, "jaas-context"));
                attrMap.put("ldapAsGroups", V3AMX.getPropValue(origProps, "assign-groups"));
                attrMap.put("directory", V3AMX.getPropValue(origProps, "directory"));
                attrMap.put("baseDn", V3AMX.getPropValue(origProps, "base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", V3AMX.getPropValue(origProps, "jaas-context"));
                attrMap.put("solarisAsGroups", V3AMX.getPropValue(origProps, "assign-groups"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", V3AMX.getPropValue(origProps, "jaas-context"));
                attrMap.put("jdbcAsGroups", V3AMX.getPropValue(origProps, "assign-groups"));
                attrMap.put("datasourceJndi", V3AMX.getPropValue(origProps, "datasource-jndi"));
                attrMap.put("userTable", V3AMX.getPropValue(origProps, "user-table"));
                attrMap.put("userNameColumn", V3AMX.getPropValue(origProps, "user-name-column"));
                attrMap.put("passwordColumn", V3AMX.getPropValue(origProps, "password-column"));
                attrMap.put("groupTable", V3AMX.getPropValue(origProps, "group-table"));
                attrMap.put("groupNameColumn", V3AMX.getPropValue(origProps, "group-name-column"));
                attrMap.put("dbUser", V3AMX.getPropValue(origProps, "db-user"));
                attrMap.put("dbPassword", V3AMX.getPropValue(origProps, "db-password"));
                attrMap.put("digestAlgorithm", V3AMX.getPropValue(origProps, "digest-algorithm"));
                attrMap.put("encoding", V3AMX.getPropValue(origProps, "encoding"));
                attrMap.put("charset", V3AMX.getPropValue(origProps, "charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", V3AMX.getPropValue(origProps, "assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            List props = V3AMX.getNonSkipPropertiesMap((AMXConfigProxy)realm, null);
            handlerCtx.setOutputValue("properties", (Object)props);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("classnameOption");
        List propList = (List)handlerCtx.getInputValue("propList");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "file", "file");
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "fileJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "ldapJaax");
                    SecurityHandler.putOptional(attrMap, propList, "base-dn", "baseDn");
                    SecurityHandler.putOptional(attrMap, propList, "directory", "directory");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "solarisJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "jdbcJaax");
                    SecurityHandler.putOptional(attrMap, propList, "datasource-jndi", "datasourceJndi");
                    SecurityHandler.putOptional(attrMap, propList, "user-table", "userTable");
                    SecurityHandler.putOptional(attrMap, propList, "user-name-column", "userNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "password-column", "passwordColumn");
                    SecurityHandler.putOptional(attrMap, propList, "group-table", "groupTable");
                    SecurityHandler.putOptional(attrMap, propList, "group-name-column", "groupNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "db-user", "dbUser");
                    SecurityHandler.putOptional(attrMap, propList, "db-password", "dbPassword");
                    SecurityHandler.putOptional(attrMap, propList, "digest-algorithm", "digestAlgorithm");
                    SecurityHandler.putOptional(attrMap, propList, "encoding", "encoding");
                    SecurityHandler.putOptional(attrMap, propList, "charset", "charset");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            if (edit.booleanValue()) {
                String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
                V3AMX.setAttribute(objectNameStr, new Attribute("Classname", classname));
                V3AMX.setProperties(objectNameStr, propList, false);
            } else {
                HashMap cMap = new HashMap();
                cMap.put(PROPERTY_NAME, attrMap.get(PROPERTY_NAME));
                cMap.put("Classname", attrMap.get("classname"));
                SecurityService amx = V3AMX.getInstance().getConfig("server-config").getSecurityService();
                AMXConfigProxy child = amx.createChild("auth-realm", cMap);
                V3AMX.setProperties(child.objectName().toString(), propList, false);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void putOptional(Map<String, String> attrMap, List propList, String propName, String key) {
        HashMap<String, String> oneProp = new HashMap<String, String>();
        oneProp.put(PROPERTY_NAME, propName);
        String value = attrMap.get(key);
        if (GuiUtil.isEmpty(value)) {
            return;
        }
        oneProp.put(PROPERTY_VALUE, attrMap.get(key));
        propList.add(oneProp);
    }

    public static void saveUser(HandlerContext handlerCtx) {
        try {
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            V3AMX.getInstance().getRealmsMgr().updateUser(realmName, userid, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addUser(HandlerContext handlerCtx) {
        try {
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            V3AMX.getInstance().getRealmsMgr().addUser(realmName, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String userName = (String)handlerCtx.getInputValue("User");
        handlerCtx.setOutputValue("GroupList", (Object)SecurityHandler.getGroupNames(realmName, userName));
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        ArrayList result = new ArrayList();
        try {
            String[] userNames = V3AMX.getInstance().getRealmsMgr().getUserNames(realmName);
            if (userNames != null) {
                HashMap<String, Object> map = null;
                for (int i = 0; i < userNames.length; ++i) {
                    map = new HashMap<String, Object>();
                    map.put("users", userNames[i]);
                    map.put("groups", SecurityHandler.getGroupNames(realmName, userNames[i]));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        String error = null;
        String realmName = (String)handlerCtx.getInputValue("Realm");
        try {
            List obj;
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("users");
                if (realmName.equals("admin-realm") && user.equals(GuiUtil.getSessionValue("userName"))) {
                    error = GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.cannotDeleteCurrent");
                    continue;
                }
                V3AMX.getInstance().getRealmsMgr().removeUser(realmName, user);
            }
            if (error != null) {
                GuiUtil.prepareAlert(handlerCtx, "error", error, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void checkCurrentUser(HandlerContext handlerCtx) {
        boolean endSession = false;
        String realmName = (String)handlerCtx.getInputValue("Realm");
        if (realmName.equals("admin-realm")) {
            String[] userNames = V3AMX.getInstance().getRealmsMgr().getUserNames(realmName);
            if (userNames == null || userNames.length == 0) {
                endSession = true;
            } else {
                String currentLoginUser = (String)GuiUtil.getSessionValue("userName");
                for (int i = 0; i < userNames.length; ++i) {
                    if (!userNames[i].equals(currentLoginUser)) continue;
                    endSession = false;
                    break;
                }
            }
        }
        if (endSession) {
            ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
            HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
            request.getSession().invalidate();
        }
        handlerCtx.setOutputValue("endSession", (Object)endSession);
    }

    public static void hasManageUserButton(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        handlerCtx.setOutputValue("result", (Object)V3AMX.getInstance().getRealmsMgr().supportsUserManagement(realmName));
    }

    private static String getGroupNames(String realmName, String userName) {
        try {
            return GuiUtil.arrayToString(V3AMX.getInstance().getRealmsMgr().getGroupNames(realmName, userName), ",");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static void addDefaultProviderInfo(HandlerContext handlerCtx) {
        List providerList = (List)handlerCtx.getInputValue("providerList");
        MessageSecurityConfig msgConfig = SecurityHandler.getMsgSecurityProxy((String)handlerCtx.getInputValue("msgSecurityName"));
        String defaultProvider = msgConfig.getDefaultProvider();
        String defaultClientProvider = msgConfig.getDefaultClientProvider();
        String trueStr = GuiUtil.getMessage("common.true");
        String falseStr = GuiUtil.getMessage("common.false");
        for (Map oneRow : providerList) {
            String name = (String)oneRow.get(PROPERTY_NAME);
            if (name.equals(defaultProvider) || name.equals(defaultClientProvider)) {
                oneRow.put("default", trueStr);
                continue;
            }
            oneRow.put("default", falseStr);
        }
    }

    public static void getMsgProviderInfo(HandlerContext handlerCtx) {
        String providerName = (String)handlerCtx.getInputValue("providerName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String configName = (String)handlerCtx.getInputValue("configName");
        MessageSecurityConfig msgConfig = SecurityHandler.getMsgSecurityProxy(msgSecurityName);
        ProviderConfig provider = (ProviderConfig)msgConfig.childrenMap(ProviderConfig.class).get(providerName);
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("msgSecurityName", msgSecurityName);
        attrMap.put("configName", configName);
        attrMap.put(PROPERTY_NAME, providerName);
        attrMap.put("ProviderType", provider.getProviderType());
        attrMap.put("ClassName", provider.getClassName());
        if (provider.getRequestPolicy() != null) {
            attrMap.put("Request-AuthSource", SecurityHandler.str(provider.getRequestPolicy().getAuthSource()));
            attrMap.put("Request-AuthRecipient", SecurityHandler.str(provider.getRequestPolicy().getAuthRecipient()));
        }
        if (provider.getResponsePolicy() != null) {
            attrMap.put("Response-AuthSource", SecurityHandler.str(provider.getResponsePolicy().getAuthSource()));
            attrMap.put("Response-AuthRecipient", SecurityHandler.str(provider.getResponsePolicy().getAuthRecipient()));
        }
        if (providerName.equals(msgConfig.getDefaultClientProvider()) || providerName.equals(msgConfig.getDefaultProvider())) {
            attrMap.put("defaultProvider", "true");
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
    }

    public static void saveMsgProviderInfo(HandlerContext handlerCtx) {
        HashMap attrs;
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String edit = (String)handlerCtx.getInputValue("edit");
        String providerName = (String)attrMap.get(PROPERTY_NAME);
        String msgSecurityName = (String)attrMap.get("msgSecurityName");
        String configName = (String)attrMap.get("configName");
        MessageSecurityConfig msgConfig = SecurityHandler.getMsgSecurityProxy(msgSecurityName);
        ProviderConfig provider = (ProviderConfig)msgConfig.childrenMap(ProviderConfig.class).get(providerName);
        if (edit.equals("true")) {
            if (provider == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.noSuchProvider"));
                return;
            }
            provider.setClassName((String)attrMap.get("ClassName"));
            provider.setProviderType((String)attrMap.get("ProviderType"));
        } else {
            HashMap attrs2 = new HashMap();
            attrs2.put(PROPERTY_NAME, attrMap.get(PROPERTY_NAME));
            attrs2.put("ClassName", attrMap.get("ClassName"));
            attrs2.put("ProviderType", attrMap.get("ProviderType"));
            msgConfig.createChild("provider-config", attrs2);
            provider = (ProviderConfig)msgConfig.childrenMap(ProviderConfig.class).get(providerName);
        }
        String def = (String)attrMap.get("defaultProvider");
        if (def == null) {
            if (providerName.equals(msgConfig.getDefaultProvider())) {
                msgConfig.setDefaultProvider("");
            }
            if (providerName.equals(msgConfig.getDefaultClientProvider())) {
                msgConfig.setDefaultClientProvider("");
            }
        } else {
            String type = provider.getProviderType();
            if (type.equals("server") || type.equals("client-server")) {
                msgConfig.setDefaultProvider(providerName);
            }
            if (type.equals("client") || type.equals("client-server")) {
                msgConfig.setDefaultClientProvider(providerName);
            }
        }
        if (provider.getRequestPolicy() == null) {
            if (!GuiUtil.isEmpty((String)attrMap.get("Request-AuthSource")) || !GuiUtil.isEmpty((String)attrMap.get("Request-AuthRecipient"))) {
                attrs = new HashMap();
                attrs.put("authSource", attrMap.get("Request-AuthSource"));
                attrs.put("AuthRecipient", attrMap.get("Request-AuthRecipient"));
                provider.createChild("request-policy", attrs);
            }
        } else {
            provider.getRequestPolicy().setAuthSource((String)attrMap.get("Request-AuthSource"));
            provider.getRequestPolicy().setAuthRecipient((String)attrMap.get("Request-AuthRecipient"));
        }
        if (provider.getResponsePolicy() == null) {
            if (!GuiUtil.isEmpty((String)attrMap.get("Response-AuthSource")) || !GuiUtil.isEmpty((String)attrMap.get("Response-AuthRecipient"))) {
                attrs = new HashMap();
                attrs.put("authSource", attrMap.get("Response-AuthSource"));
                attrs.put("AuthRecipient", attrMap.get("Response-AuthRecipient"));
                provider.createChild("response-policy", attrs);
            }
        } else {
            provider.getResponsePolicy().setAuthSource((String)attrMap.get("Response-AuthSource"));
            provider.getResponsePolicy().setAuthRecipient((String)attrMap.get("Response-AuthRecipient"));
        }
        handlerCtx.setOutputValue("objName", (Object)provider.objectName().toString());
    }

    public static void checkMsgSecurityDefaultProvider(HandlerContext handlerCtx) {
        String defClient;
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        MessageSecurityConfig msgConfig = SecurityHandler.getMsgSecurityProxy(msgSecurityName);
        String defServer = msgConfig.getDefaultProvider();
        if (!GuiUtil.isEmpty(defServer) && msgConfig.childrenMap(ProviderConfig.class).get(defServer) == null) {
            msgConfig.setDefaultProvider(null);
        }
        if (!GuiUtil.isEmpty(defClient = msgConfig.getDefaultClientProvider()) && msgConfig.childrenMap(ProviderConfig.class).get(defClient) == null) {
            msgConfig.setDefaultClientProvider(null);
        }
    }

    private static MessageSecurityConfig getMsgSecurityProxy(String msgSecurityName) {
        Set pSet = V3AMX.getInstance().getDomainRoot().getQueryMgr().queryTypeName("message-security-config", msgSecurityName);
        Iterator i$ = pSet.iterator();
        if (i$.hasNext()) {
            AMXProxy msgProxy = (AMXProxy)i$.next();
            return (MessageSecurityConfig)msgProxy.as(MessageSecurityConfig.class);
        }
        return null;
    }

    private static String str(String aa) {
        return aa == null ? "" : aa;
    }

    static {
        String[] classnames = V3AMX.getInstance().getRealmsMgr().getPredefinedAuthRealmClassNames();
        realmClassList = new ArrayList();
        realmClassList.add("");
        for (int i = 0; i < classnames.length; ++i) {
            realmClassList.add(classnames[i]);
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

