/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.provider.entity;

import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.core.provider.jaxb.AbstractRootElementProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONRootElementProvider
extends AbstractRootElementProvider {
    JSONRootElementProvider(Providers ps) {
        super(ps);
    }

    JSONRootElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    protected final Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException, IOException {
        Charset c = JSONRootElementProvider.getCharset(mediaType);
        return JSONJAXBContext.getJSONUnmarshaller(u).unmarshalFromJSON(new InputStreamReader(entityStream, c), type);
    }

    @Override
    protected void writeTo(Object t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        JSONJAXBContext.getJSONMarshaller(m).marshallToJSON(t, new OutputStreamWriter(entityStream, c));
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JSONRootElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_JSON_TYPE);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JSONRootElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }

        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }
}

