/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnectorServer;
import org.glassfish.admin.mbeanserver.Util;

final class JMXMPConnectorStarter {
    public static final String JMXMP = "jmxmp";
    private final MBeanServer mMBeanServer;
    private volatile JMXConnectorServer mJMXMP = null;
    private volatile JMXServiceURL mJMXMPServiceURL = null;
    private final String mAddress;
    private final int mPort;
    private final String mAuthRealmName;
    private final boolean mSecurityEnabled;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXMPServiceURL;
    }

    JMXMPConnectorStarter(MBeanServer mbeanServer, String address, int port, String authRealmName, boolean securityEnabled) {
        this.mMBeanServer = mbeanServer;
        this.mAddress = address;
        this.mPort = port;
        this.mAuthRealmName = authRealmName;
        this.mSecurityEnabled = securityEnabled;
    }

    public synchronized JMXConnectorServer start(boolean tryOtherPorts) {
        if (this.mJMXMP != null) {
            return this.mJMXMP;
        }
        int TRY_COUNT = tryOtherPorts ? 100 : 1;
        int port = this.mPort;
        int tryCount = 0;
        while (tryCount < TRY_COUNT) {
            try {
                this.mJMXMP = this.startJMXMPConnectorServer(port);
                break;
            }
            catch (BindException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (port < 1000) {
                port += 1000;
                continue;
            }
            ++port;
        }
        return this.mJMXMP;
    }

    public synchronized void stop() {
        try {
            this.mJMXMP.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void ignore(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnectorServer startJMXMPConnectorServer(int port) throws MalformedURLException, IOException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
        env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        JMXServiceURL serviceURL = new JMXServiceURL("service:jmx:jmxmp://" + Util.localhost() + ":" + port);
        JMXMPConnectorServer jmxmp = null;
        boolean startedOK = false;
        try {
            jmxmp = new JMXMPConnectorServer(serviceURL, env, this.mMBeanServer);
            jmxmp.start();
            startedOK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!startedOK) {
                try {
                    if (jmxmp != null) {
                        jmxmp.stop();
                    }
                }
                catch (Exception e) {
                    JMXMPConnectorStarter.ignore(e);
                }
            }
        }
        this.mJMXMPServiceURL = serviceURL;
        this.mJMXMP = jmxmp;
        JMXConnector jmxc = JMXConnectorFactory.connect(serviceURL, null);
        jmxc.getMBeanServerConnection().getMBeanCount();
        return this.mJMXMP;
    }
}

