/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.spi.WSEjbEndpointRegistry;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.WebServiceEjbEndpointRegistry;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.EndpointLifecycleListener;
import org.glassfish.webservices.monitoring.WebServiceEngine;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.transport.tcp.WSEndpointDescriptor;
import org.glassfish.webservices.transport.tcp.WSEndpointLifeCycleListener;
import org.glassfish.webservices.transport.tcp.WSTCPAdapterRegistryImpl;

public final class AppServRegistry {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    private static final AppServRegistry instance = new AppServRegistry();

    public static AppServRegistry getInstance() {
        return instance;
    }

    private AppServRegistry() {
        WSEndpointLifeCycleListener lifecycleListener = new WSEndpointLifeCycleListener();
        WebServiceEngineImpl engine = WebServiceEngineImpl.getInstance();
        engine.addLifecycleListener((EndpointLifecycleListener)lifecycleListener);
        this.populateEndpoints((WebServiceEngine)engine);
    }

    private void populateEndpoints(@NotNull WebServiceEngine engine) {
        Iterator endpoints = engine.getEndpoints();
        while (endpoints.hasNext()) {
            this.registerEndpoint((Endpoint)endpoints.next());
        }
    }

    @NotNull
    public EjbRuntimeEndpointInfo getEjbRuntimeEndpointInfo(@NotNull String wsPath) {
        WSEndpointDescriptor wsEndpointDescriptor = WSTCPAdapterRegistryImpl.getInstance().lookupEndpoint(wsPath);
        EjbRuntimeEndpointInfo endpointInfo = null;
        if (wsEndpointDescriptor.isEJB()) {
            endpointInfo = AppServRegistry.getWSEjbEndpointRegistry().getEjbWebServiceEndpoint(wsEndpointDescriptor.getURI(), "POST", null);
        }
        return endpointInfo;
    }

    protected void registerEndpoint(@NotNull Endpoint endpoint) {
        WebServiceEndpoint wsServiceDescriptor = endpoint.getDescriptor();
        if (wsServiceDescriptor != null && this.isTCPEnabled(wsServiceDescriptor)) {
            String contextRoot = this.getEndpointContextRoot(wsServiceDescriptor);
            String urlPattern = this.getEndpointUrlPattern(wsServiceDescriptor);
            String wsPath = this.getWebServiceEndpointPath(wsServiceDescriptor);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1110_APP_SERV_REG_REGISTER_ENDPOINT((Object)wsServiceDescriptor.getServiceName(), (Object)wsPath, (Object)wsServiceDescriptor.implementedByEjbComponent()));
            }
            WSEndpointDescriptor descriptor = new WSEndpointDescriptor(wsServiceDescriptor, contextRoot, urlPattern, endpoint.getEndpointSelector());
            WSTCPAdapterRegistryImpl.getInstance().registerEndpoint(wsPath, descriptor);
        }
    }

    protected void deregisterEndpoint(@NotNull Endpoint endpoint) {
        WebServiceEndpoint wsServiceDescriptor = endpoint.getDescriptor();
        String wsPath = this.getWebServiceEndpointPath(wsServiceDescriptor);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1111_APP_SERV_REG_DEREGISTER_ENDPOINT((Object)wsServiceDescriptor.getWebService().getName(), (Object)wsPath, (Object)wsServiceDescriptor.implementedByEjbComponent()));
        }
        WSTCPAdapterRegistryImpl.getInstance().deregisterEndpoint(wsPath);
    }

    @NotNull
    private String getWebServiceEndpointPath(@NotNull WebServiceEndpoint wsServiceDescriptor) {
        String wsPath;
        if (!wsServiceDescriptor.implementedByEjbComponent()) {
            String contextRoot = wsServiceDescriptor.getWebComponentImpl().getWebBundleDescriptor().getContextRoot();
            String urlPattern = wsServiceDescriptor.getEndpointAddressUri();
            wsPath = contextRoot + this.ensureSlash(urlPattern);
            logger.log(Level.FINE, MessagesMessages.WSTCP_1116_APP_SERV_REG_GET_WS_ENDP_PATH_NON_EJB((Object)wsPath));
        } else {
            wsPath = wsServiceDescriptor.getEndpointAddressUri();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1117_APP_SERV_REG_GET_WS_ENDP_PATH_EJB((Object)wsPath));
        }
        return this.ensureSlash(wsPath);
    }

    @NotNull
    private String getEndpointContextRoot(@NotNull WebServiceEndpoint wsServiceDescriptor) {
        String contextRoot;
        if (!wsServiceDescriptor.implementedByEjbComponent()) {
            contextRoot = wsServiceDescriptor.getWebComponentImpl().getWebBundleDescriptor().getContextRoot();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1112_APP_SERV_REG_GET_ENDP_CR_NON_EJB((Object)contextRoot));
        } else {
            String[] path = wsServiceDescriptor.getEndpointAddressUri().split("/");
            contextRoot = "/" + path[1];
            logger.log(Level.FINE, MessagesMessages.WSTCP_1113_APP_SERV_REG_GET_ENDP_CR_EJB((Object)contextRoot));
        }
        return contextRoot;
    }

    @NotNull
    private String getEndpointUrlPattern(@NotNull WebServiceEndpoint wsServiceDescriptor) {
        String urlPattern;
        if (!wsServiceDescriptor.implementedByEjbComponent()) {
            urlPattern = wsServiceDescriptor.getEndpointAddressUri();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1114_APP_SERV_REG_GET_ENDP_URL_PATTERN_NON_EJB((Object)urlPattern));
        } else {
            String[] path = wsServiceDescriptor.getEndpointAddressUri().split("/");
            if (path.length < 3) {
                return "";
            }
            urlPattern = "/" + path[2];
            logger.log(Level.FINE, MessagesMessages.WSTCP_1115_APP_SERV_REG_GET_ENDP_URL_PATTERN_EJB((Object)urlPattern));
        }
        return urlPattern;
    }

    @Nullable
    private String ensureSlash(@Nullable String s) {
        if (s != null && s.length() > 0 && s.charAt(0) != '/') {
            return "/" + s;
        }
        return s;
    }

    private boolean isTCPEnabled(WebServiceEndpoint webServiceDesc) {
        return true;
    }

    static WebServiceEjbEndpointRegistry getWSEjbEndpointRegistry() {
        return (WebServiceEjbEndpointRegistry)Globals.getDefaultHabitat().getComponent(WSEjbEndpointRegistry.class);
    }
}

