/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import java.beans.PropertyVetoException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.admin.config.PropertyBag;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigToolsImpl
extends AMXImplBase {
    private static void debug(String s) {
        System.out.println(s);
    }

    public ConfigToolsImpl(ObjectName parent) {
        super(parent, ConfigTools.class);
    }

    private static Property findProperty(List<Property> props, String name) {
        for (Property prop : props) {
            if (prop == null) {
                ConfigToolsImpl.debug("WARNING: null Property object in List<Property>");
                continue;
            }
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    private static SystemProperty findSystemProperty(List<SystemProperty> props, String name) {
        for (SystemProperty prop : props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public Object test() {
        return null;
    }

    public void setProperties(ObjectName parent, List<Map<String, String>> props, boolean clearAll) {
        if (parent == null || props == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(parent);
        if (configBean == null) {
            throw new IllegalArgumentException("" + parent);
        }
        PropertyBagProxy proxy = (PropertyBagProxy)configBean.getProxy(PropertyBagProxy.class);
        if (!PropertyBag.class.isAssignableFrom(proxy.getClass())) {
            throw new IllegalArgumentException("ConfigBean " + configBean.getProxyType().getName() + " is not a PropertyBag");
        }
        PropsSetter propsSetter = new PropsSetter(props, clearAll);
        try {
            ConfigSupport.apply((ConfigCode)propsSetter, (ConfigBeanProxy[])new ConfigBeanProxy[]{proxy});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void clearProperties(ObjectName parent) {
        this.setProperties(parent, new ArrayList<Map<String, String>>(), true);
    }

    public void clearSystemProperties(ObjectName parent) {
        this.setSystemProperties(parent, new ArrayList<Map<String, String>>(), true);
    }

    public void setSystemProperties(ObjectName parent, List<Map<String, String>> props, boolean clearAll) {
        if (parent == null || props == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(parent);
        if (configBean == null) {
            throw new IllegalArgumentException("" + parent);
        }
        SystemPropertyBagProxy proxy = (SystemPropertyBagProxy)configBean.getProxy(SystemPropertyBagProxy.class);
        if (!SystemPropertyBag.class.isAssignableFrom(proxy.getClass())) {
            throw new IllegalArgumentException("ConfigBean " + configBean.getProxyType().getName() + " is not a SystemPropertyBag");
        }
        SystemPropsSetter propsSetter = new SystemPropsSetter(props, clearAll);
        try {
            ConfigSupport.apply((ConfigCode)propsSetter, (ConfigBeanProxy[])new ConfigBeanProxy[]{proxy});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String[] toString(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = Util.typeFromName((String)classes[i].getName());
        }
        return names;
    }

    public String[] getConfigNamedTypes() {
        return this.toString(ConfigBeanJMXSupport.getTypesImplementing(Named.class));
    }

    public String[] getConfigResourceTypes() {
        return this.toString(ConfigBeanJMXSupport.getTypesImplementing(Resource.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AnyPropsSetter
    implements ConfigCode {
        protected final List<Map<String, String>> mNewProps;
        protected final boolean mClearAll;

        AnyPropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            this.mNewProps = newProps;
            this.mClearAll = clearAll;
        }

        public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
            if (params.length != 1) {
                throw new IllegalArgumentException();
            }
            ConfigBeanProxy parent = params[0];
            ConfigBean source = (ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)parent);
            ConfigSupport configSupport = (ConfigSupport)source.getHabitat().getComponent(ConfigSupport.class);
            return this._run(parent, configSupport);
        }

        protected Set<String> propNames() {
            HashSet<String> names = new HashSet<String>();
            for (Map<String, String> newProp : this.mNewProps) {
                names.add(newProp.get("Name"));
            }
            return names;
        }

        abstract Object _run(ConfigBeanProxy var1, ConfigSupport var2) throws PropertyVetoException, TransactionFailure;
    }

    static interface PropertyBagProxy
    extends ConfigBeanProxy,
    PropertyBag {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropsSetter
    extends AnyPropsSetter {
        public PropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            super(newProps, clearAll);
        }

        @Override
        public Object _run(ConfigBeanProxy parent, ConfigSupport configSupport) throws PropertyVetoException, TransactionFailure {
            PropertyBag bag = (PropertyBag)parent;
            List props = bag.getProperty();
            if (this.mClearAll) {
                Set<String> newPropNames = this.propNames();
                ArrayList<Property> toRemove = new ArrayList<Property>();
                for (Property existing : props) {
                    if (newPropNames.contains(existing.getName())) continue;
                    toRemove.add(existing);
                }
                props.removeAll(toRemove);
            }
            WriteableView parentW = (WriteableView)Proxy.getInvocationHandler(parent);
            Transaction t = parentW.getTransaction();
            for (Map newProp : this.mNewProps) {
                String name = (String)newProp.get("Name");
                String value = (String)newProp.get("Value");
                String description = (String)newProp.get("Description");
                Property prop = ConfigToolsImpl.findProperty(props, name);
                if (prop != null) {
                    Property propW = (Property)configSupport.getWriteableView((ConfigBeanProxy)prop);
                    ((WriteableView)Proxy.getInvocationHandler(propW)).join(t);
                    prop = propW;
                } else {
                    prop = (Property)parent.createChild(Property.class);
                    props.add(prop);
                }
                prop.setName(name);
                prop.setValue(value);
                prop.setDescription(description);
            }
            return null;
        }
    }

    static interface SystemPropertyBagProxy
    extends ConfigBeanProxy,
    SystemPropertyBag {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SystemPropsSetter
    extends AnyPropsSetter {
        public SystemPropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            super(newProps, clearAll);
        }

        @Override
        public Object _run(ConfigBeanProxy parent, ConfigSupport configSupport) throws PropertyVetoException, TransactionFailure {
            SystemPropertyBag bag = (SystemPropertyBag)parent;
            List props = bag.getSystemProperty();
            if (this.mClearAll) {
                Set<String> newPropNames = this.propNames();
                ArrayList<SystemProperty> toRemove = new ArrayList<SystemProperty>();
                for (SystemProperty existing : props) {
                    if (newPropNames.contains(existing.getName())) continue;
                    toRemove.add(existing);
                }
                props.removeAll(toRemove);
            }
            WriteableView parentW = (WriteableView)Proxy.getInvocationHandler(parent);
            Transaction t = parentW.getTransaction();
            for (Map newProp : this.mNewProps) {
                String name = (String)newProp.get("Name");
                String value = (String)newProp.get("Value");
                String description = (String)newProp.get("Description");
                SystemProperty prop = ConfigToolsImpl.findSystemProperty(props, name);
                if (prop != null) {
                    SystemProperty propW = (SystemProperty)configSupport.getWriteableView((ConfigBeanProxy)prop);
                    ((WriteableView)Proxy.getInvocationHandler(propW)).join(t);
                    prop = propW;
                } else {
                    prop = (SystemProperty)parent.createChild(SystemProperty.class);
                    props.add(prop);
                }
                prop.setName(name);
                prop.setValue(value);
                prop.setDescription(description);
            }
            return null;
        }
    }
}

