/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.intf.config;

import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Resource;
import org.glassfish.admin.amx.intf.config.Resources;
import org.glassfish.admin.amx.intf.config.Server;
import org.glassfish.admin.amx.intf.config.SystemApplications;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class AMXConfigGetters {
    private final DomainRoot mDomainRoot;
    private final Domain mDomainConfig;

    public AMXConfigGetters(AMXProxy amx) {
        this.mDomainRoot = amx.extra().proxyFactory().getDomainRootProxy();
        this.mDomainConfig = (Domain)this.mDomainRoot.child(Domain.class);
    }

    public DomainRoot domainRoot() {
        return this.mDomainRoot;
    }

    public Domain domainConfig() {
        return this.mDomainConfig;
    }

    public Resources resources() {
        return this.domainConfig().getResources();
    }

    public Applications applications() {
        return this.domainConfig().getApplications();
    }

    public SystemApplications systemApplications() {
        return this.domainConfig().getSystemApplications();
    }

    public <T extends Resource> T getResource(String name, Class<T> clazz) {
        for (AMXProxy child : this.resources().childrenSet()) {
            if (!child.getName().equals(name)) continue;
            return (T)((Resource)child.as(clazz));
        }
        return null;
    }

    public Resource getResource(String name) {
        return this.getResource(name, Resource.class);
    }

    public Server getServer(String name) {
        return this.child((AMXProxy)this.domainConfig().getServers(), Server.class, name);
    }

    public Application getApplication(String name) {
        Application appConfig = (Application)this.applications().childrenMap(Application.class).get(name);
        if (appConfig == null) {
            appConfig = (Application)this.systemApplications().childrenMap(Application.class).get(name);
        }
        return appConfig;
    }

    public <T extends AMXProxy> T child(AMXProxy parent, Class<T> intf, String name) {
        return (T)((AMXProxy)parent.childrenMap(intf).get(name));
    }

    public Config getConfig(String name) {
        return this.child((AMXProxy)this.domainConfig().getConfigs(), Config.class, name);
    }
}

