/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdminEndpointDecider {
    private String asadminContextRoot;
    private String guiContextRoot;
    private List<String> asadminHosts;
    private List<String> guiHosts;
    private int port;
    private Config cfg;
    private Logger log;
    public static final String ADMIN_LISTENER_ID = "admin-listener";
    public static final int ADMIN_PORT = 4848;

    public AdminEndpointDecider(Config cfg, Logger log) {
        if (cfg == null || log == null) {
            throw new IllegalArgumentException("config or logger can't be null");
        }
        this.cfg = cfg;
        this.log = log;
        this.setValues();
    }

    public int getListenPort() {
        return this.port;
    }

    public List<String> getAsadminHosts() {
        return this.asadminHosts;
    }

    public List<String> getGuiHosts() {
        return this.guiHosts;
    }

    public String getAsadminContextRoot() {
        return this.asadminContextRoot;
    }

    public String getGuiContextRoot() {
        return this.guiContextRoot;
    }

    private void setValues() {
        this.asadminContextRoot = "/__asadmin";
        NetworkConfig config = this.cfg.getNetworkConfig();
        if (config == null) {
            throw new IllegalStateException("Can't operate without <http-service>");
        }
        List lss = config.getNetworkListeners().getNetworkListener();
        if (lss == null || lss.isEmpty()) {
            throw new IllegalStateException("Can't operate without at least one <network-listener>");
        }
        boolean dedicatedAdmin = false;
        for (NetworkListener ls : lss) {
            if (!ADMIN_LISTENER_ID.equals(ls.getName())) continue;
            this.guiContextRoot = "";
            String dvs = ls.findHttpProtocol().getHttp().getDefaultVirtualServer();
            this.guiHosts = Collections.unmodifiableList(Arrays.asList(dvs));
            this.asadminHosts = this.guiHosts;
            try {
                this.port = Integer.valueOf(ls.getPort());
            }
            catch (NumberFormatException ne) {
                this.port = 4848;
            }
            dedicatedAdmin = true;
            break;
        }
        if (!dedicatedAdmin) {
            NetworkListener effective = (NetworkListener)lss.get(0);
            String dvs = effective.findHttpProtocol().getHttp().getDefaultVirtualServer();
            this.guiHosts = Collections.unmodifiableList(Arrays.asList(dvs));
            this.asadminHosts = this.guiHosts;
            try {
                this.port = Integer.valueOf(effective.getPort());
            }
            catch (NumberFormatException ne) {
                this.port = 8080;
            }
            AdminService as = this.cfg.getAdminService();
            if (as == null) {
                this.guiContextRoot = "/admin";
            } else {
                this.setGuiContextRootFromAdminService(as);
            }
        }
    }

    private void setGuiContextRootFromAdminService(AdminService as) {
        for (Property p : as.getProperty()) {
            this.setGuiContextRoot(p);
        }
    }

    private void setGuiContextRoot(Property prop) {
        if (prop == null) {
            this.guiContextRoot = "/admin";
            return;
        }
        if ("adminConsoleContextRoot".equals(prop.getName())) {
            if (prop.getValue() != null && prop.getValue().startsWith("/")) {
                this.guiContextRoot = prop.getValue();
                this.log.info("Admin Console Adapter: context root: " + this.guiContextRoot);
            } else {
                this.log.info("Invalid context root for the admin console application, using default:/admin");
                this.guiContextRoot = "/admin";
            }
        }
    }
}

