/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionManagementSettings {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp");
    private static final int DEFAULT_VALUE = -1;
    private int highWatermark = -1;
    private int maxParallelConnections = -1;
    private int numberToReclaim = -1;
    private static volatile ConnectionManagementSettingsHolder holder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionManagementSettingsHolder getSettingsHolder() {
        if (holder != null) return holder;
        Class<ConnectionManagementSettings> clazz = ConnectionManagementSettings.class;
        synchronized (ConnectionManagementSettings.class) {
            if (holder != null || ConnectionManagementSettings.createDefaultHolder()) return holder;
            holder = new SystemPropsConnectionManagementSettingsHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return holder;
        }
    }

    public static void setSettingsHolder(ConnectionManagementSettingsHolder holder) {
        ConnectionManagementSettings.holder = holder;
    }

    public ConnectionManagementSettings(int highWatermark, int maxParallelConnections, int numberToReclaim) {
        this.highWatermark = highWatermark != -1 ? highWatermark : 1500;
        this.maxParallelConnections = maxParallelConnections != -1 ? maxParallelConnections : 5;
        this.numberToReclaim = numberToReclaim != -1 ? numberToReclaim : 1;
    }

    public ConnectionManagementSettings(int highWatermark, int numberToReclaim) {
        this.highWatermark = highWatermark != -1 ? highWatermark : 1500;
        this.maxParallelConnections = -1;
        this.numberToReclaim = numberToReclaim != -1 ? numberToReclaim : 1;
    }

    public int getHighWatermark() {
        return this.highWatermark;
    }

    public int getMaxParallelConnections() {
        return this.maxParallelConnections;
    }

    public int getNumberToReclaim() {
        return this.numberToReclaim;
    }

    private static boolean createDefaultHolder() {
        boolean isOk = true;
        try {
            Class<?> policyHolderClass = Class.forName("com.sun.xml.ws.transport.tcp.wsit.PolicyConnectionManagementSettingsHolder");
            Method getSingltonMethod = policyHolderClass.getMethod("getInstance", new Class[0]);
            holder = (ConnectionManagementSettingsHolder)getSingltonMethod.invoke(null, new Object[0]);
            logger.log(Level.FINE, MessagesMessages.WSTCP_1150_CON_MNGMNT_SETTINGS_POLICY());
        }
        catch (Exception e) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1151_CON_MNGMNT_SETTINGS_SYST_PROPS());
            isOk = false;
        }
        return isOk;
    }

    public static interface ConnectionManagementSettingsHolder {
        public ConnectionManagementSettings getClientSettings();

        public ConnectionManagementSettings getServerSettings();
    }

    private static class SystemPropsConnectionManagementSettingsHolder
    implements ConnectionManagementSettingsHolder {
        private volatile ConnectionManagementSettings clientSettings;
        private volatile ConnectionManagementSettings serverSettings;

        private SystemPropsConnectionManagementSettingsHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionManagementSettings getClientSettings() {
            if (this.clientSettings == null) {
                SystemPropsConnectionManagementSettingsHolder systemPropsConnectionManagementSettingsHolder = this;
                synchronized (systemPropsConnectionManagementSettingsHolder) {
                    if (this.clientSettings == null) {
                        this.clientSettings = SystemPropsConnectionManagementSettingsHolder.createSettings(true);
                    }
                }
            }
            return this.clientSettings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionManagementSettings getServerSettings() {
            if (this.serverSettings == null) {
                SystemPropsConnectionManagementSettingsHolder systemPropsConnectionManagementSettingsHolder = this;
                synchronized (systemPropsConnectionManagementSettingsHolder) {
                    if (this.serverSettings == null) {
                        this.serverSettings = SystemPropsConnectionManagementSettingsHolder.createSettings(false);
                    }
                }
            }
            return this.serverSettings;
        }

        private static ConnectionManagementSettings createSettings(boolean isClient) {
            int highWatermark = Integer.getInteger("high-water-mark", -1);
            int maxParallelConnections = Integer.getInteger("max-parallel-connections", -1);
            int numberToReclaim = Integer.getInteger("number-to-reclaim", -1);
            ConnectionManagementSettings settings = null;
            settings = isClient ? new ConnectionManagementSettings(highWatermark, maxParallelConnections, numberToReclaim) : new ConnectionManagementSettings(highWatermark, numberToReclaim);
            return settings;
        }
    }
}

