/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Producer {
    private static boolean DEBUG = false;
    private transient Logger logger = Globals.getLogger();
    private static CacheHashMap cache = new CacheHashMap(20);
    private boolean valid = true;
    private static Map allProducers = Collections.synchronizedMap(new HashMap());
    private static Set wildcardProducers = Collections.synchronizedSet(new HashSet());
    private ConnectionUID connection_uid;
    private DestinationUID destination_uid;
    private ProducerUID uid;
    private long creationTime;
    private int pauseCnt = 0;
    private int resumeCnt = 0;
    private int msgCnt = 0;
    transient String creator = null;
    transient Set destinations = null;
    transient Map lastResumeFlowSizes = Collections.synchronizedMap(new HashMap());

    public String toString() {
        return "Producer[" + (Object)((Object)this.uid) + "," + this.destination_uid + "," + (Object)((Object)this.connection_uid) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Hashtable> hashtable;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put("TABLE", "AllProducers");
        Vector<String> vector = new Vector<String>();
        Object object = cache;
        synchronized (object) {
            hashtable = cache.keySet().iterator();
            while (hashtable.hasNext()) {
                vector.add(String.valueOf(((ProducerUID)((Object)hashtable.next())).longValue()));
            }
        }
        hashtable2.put("cache", vector);
        object = null;
        hashtable = allProducers;
        synchronized (hashtable) {
            object = new HashMap(allProducers);
        }
        hashtable = new Hashtable<String, Hashtable>();
        for (ProducerUID producerUID : ((HashMap)object).keySet()) {
            Producer producer = (Producer)((HashMap)object).get((Object)producerUID);
            hashtable.put(String.valueOf(producerUID.longValue()), producer.getDebugState());
        }
        hashtable2.put("producersCnt", new Integer(allProducers.size()));
        hashtable2.put("producers", hashtable);
        return hashtable2;
    }

    public synchronized void pause() {
        ++this.pauseCnt;
    }

    public synchronized void addMsg() {
        ++this.msgCnt;
    }

    public synchronized int getMsgCnt() {
        return this.msgCnt;
    }

    public synchronized boolean isPaused() {
        return this.pauseCnt > this.resumeCnt;
    }

    public synchronized void resume() {
        ++this.resumeCnt;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("TABLE", "Producer[" + this.uid.longValue() + "]");
        hashtable.put("uid", String.valueOf(this.uid.longValue()));
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("pauseCnt", String.valueOf(this.pauseCnt));
        hashtable.put("resumeCnt", String.valueOf(this.resumeCnt));
        if (this.connection_uid != null) {
            hashtable.put("connectionUID", String.valueOf(this.connection_uid.longValue()));
        }
        if (this.destination_uid != null) {
            hashtable.put("destination", this.destination_uid.toString());
        }
        return hashtable;
    }

    private Producer(ConnectionUID connectionUID, DestinationUID destinationUID) {
        this.uid = new ProducerUID();
        this.connection_uid = connectionUID;
        this.destination_uid = destinationUID;
        this.logger.log(4, "Creating new Producer " + (Object)((Object)this.uid) + " on " + destinationUID + " for connection " + (Object)((Object)connectionUID));
    }

    public ProducerUID getProducerUID() {
        return this.uid;
    }

    public ConnectionUID getConnectionUID() {
        return this.connection_uid;
    }

    public DestinationUID getDestinationUID() {
        return this.destination_uid;
    }

    public static void clearProducers() {
        cache.clear();
        allProducers.clear();
        wildcardProducers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkProducer(ProducerUID producerUID) {
        String string = null;
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            string = (String)cache.get((Object)producerUID);
        }
        if (string == null) {
            return " pid " + (Object)((Object)producerUID) + " not of of last 20 removed";
        }
        return "Producer[" + (Object)((Object)producerUID) + "]:" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProducerInfo(ProducerUID producerUID, String string) {
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            cache.put((Object)producerUID, (Object)(System.currentTimeMillis() + ":" + string));
        }
    }

    public static Iterator getAllProducers() {
        return new ArrayList(allProducers.values()).iterator();
    }

    public static Iterator getWildcardProducers() {
        return new ArrayList(wildcardProducers).iterator();
    }

    public static int getNumProducers() {
        return allProducers.size();
    }

    public static int getNumWildcardProducers() {
        return wildcardProducers.size();
    }

    public static Producer getProducer(ProducerUID producerUID) {
        return (Producer)allProducers.get((Object)producerUID);
    }

    public static Producer destroyProducer(ProducerUID producerUID, String string) {
        Producer producer = (Producer)allProducers.remove((Object)producerUID);
        Producer.updateProducerInfo(producerUID, string);
        if (producer == null) {
            return producer;
        }
        if (producer.getDestinationUID().isWildcard()) {
            wildcardProducers.remove((Object)producer.getProducerUID());
            List list = Destination.findMatchingIDs(producer.getDestinationUID());
            for (DestinationUID destinationUID : list) {
                Destination destination = Destination.getDestination(destinationUID);
                if (destination == null) continue;
                destination.removeProducer(producerUID);
            }
        } else {
            Destination destination = Destination.getDestination(producer.getDestinationUID());
            if (destination != null) {
                destination.removeProducer(producerUID);
            }
        }
        producer.destroy();
        return producer;
    }

    public static Producer createProducer(DestinationUID destinationUID, ConnectionUID connectionUID, String string) {
        Producer producer = new Producer(connectionUID, destinationUID);
        Producer producer2 = allProducers.put(producer.getProducerUID(), producer);
        if (destinationUID.isWildcard()) {
            wildcardProducers.add(producer.getProducerUID());
        }
        producer.creator = string;
        assert (producer2 == null) : producer2;
        return producer;
    }

    public synchronized void destroy() {
        this.valid = false;
        this.lastResumeFlowSizes.clear();
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Producer getProducer(String string) {
        if (string == null) {
            return null;
        }
        Map map = allProducers;
        synchronized (map) {
            for (Producer producer : allProducers.values()) {
                if (!string.equals(producer.creator)) continue;
                return producer;
            }
        }
        return null;
    }

    public boolean isWildcard() {
        return this.destination_uid.isWildcard();
    }

    public Set getDestinations() {
        if (this.destinations == null) {
            this.destinations = new HashSet();
            if (!this.destination_uid.isWildcard()) {
                this.destinations.add(Destination.getDestination(this.destination_uid));
            } else {
                List list = Destination.findMatchingIDs(this.destination_uid);
                for (DestinationUID destinationUID : list) {
                    this.destinations.add(Destination.getDestination(destinationUID));
                }
            }
        }
        return this.destinations;
    }

    public void sendResumeFlow(DestinationUID destinationUID) {
        this.resume();
        this.sendResumeFlow(destinationUID, 0, 0L, 0L, "Resuming " + this, true);
        this.logger.log(1, "Producer.sendResumeFlow(" + destinationUID + ") resumed: " + this);
    }

    public void sendResumeFlow(DestinationUID destinationUID, int n, long l, long l2, String string, boolean bl) {
        ConnectionUID connectionUID;
        ResumeFlowSizes resumeFlowSizes = null;
        if (bl) {
            resumeFlowSizes = (ResumeFlowSizes)this.lastResumeFlowSizes.get(destinationUID);
            if (resumeFlowSizes == null) {
                resumeFlowSizes = new ResumeFlowSizes(Destination.MAX_PRODUCER_BATCH, -1L, -1L);
                this.lastResumeFlowSizes.put(destinationUID, resumeFlowSizes);
            }
        } else {
            resumeFlowSizes = new ResumeFlowSizes(n, l, l2);
            this.lastResumeFlowSizes.put(destinationUID, resumeFlowSizes);
        }
        if ((connectionUID = this.getConnectionUID()) == null) {
            this.logger.log(4, "cant resume flow[no con_uid] " + this);
            return;
        }
        IMQConnection iMQConnection = (IMQConnection)Globals.getConnectionManager().getConnection(connectionUID);
        if (string == null) {
            string = "Resuming " + this;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQSize", resumeFlowSizes.size);
        hashtable.put("JMQBytes", new Long(resumeFlowSizes.bytes));
        hashtable.put("JMQMaxMsgBytes", new Long(resumeFlowSizes.mbytes));
        if (iMQConnection != null) {
            Packet packet = new Packet(iMQConnection.useDirectBuffers());
            packet.setPacketType(52);
            hashtable.put("JMQProducerID", new Long(this.getProducerUID().longValue()));
            hashtable.put("JMQDestinationID", destinationUID.toString());
            hashtable.put("Reason", string);
            packet.setProperties(hashtable);
            iMQConnection.sendControlMessage(packet);
        }
    }

    class ResumeFlowSizes {
        int size = 0;
        long bytes = 0L;
        long mbytes = 0L;

        public ResumeFlowSizes(int n, long l, long l2) {
            this.size = n;
            this.bytes = l;
            this.mbytes = l2;
        }
    }
}

