/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.lang.reflect.Method;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.provider.FlashlightProbe;

class DTraceMethodFinder {
    private final FlashlightProbe probe;
    private final Object targetObject;
    private final Class targetClass;
    private final int numProbeParams;
    private Method method;
    private Class[] probeParamTypes;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DTraceMethodFinder.class);

    DTraceMethodFinder(FlashlightProbe p, Object t) {
        this.probe = p;
        this.targetObject = t;
        this.targetClass = this.targetObject.getClass();
        this.probeParamTypes = this.probe.getParamTypes();
        if (this.probeParamTypes == null) {
            this.probeParamTypes = new Class[0];
        }
        this.numProbeParams = this.probeParamTypes.length;
    }

    Method matchMethod() {
        String metname = this.probe.getProviderJavaMethodName();
        for (Method m : this.targetClass.getMethods()) {
            Class[] paramTypes;
            if (!m.getName().equals(metname) || (paramTypes = m.getParameterTypes()).length != this.numProbeParams || !this.compareParams(this.probeParamTypes, paramTypes)) continue;
            return m;
        }
        throw new RuntimeException(strings.get("dtrace_cantfind", new Object[]{metname}));
    }

    private boolean compareParams(Class[] probep, Class[] dtracep) {
        for (int i = 0; i < probep.length; ++i) {
            Class probeClass = probep[i];
            Class dtraceClass = dtracep[i];
            if (probeClass.equals(dtraceClass) || dtraceClass.equals(String.class) && !FlashlightUtils.isIntegral(probeClass) || FlashlightUtils.compareIntegral(dtraceClass, probeClass)) continue;
            return false;
        }
        return true;
    }
}

