/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.osgi.OSGiWebContainer;
import org.glassfish.web.osgi.WebBundleURLStreamHandlerService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtender
implements BundleActivator,
SynchronousBundleListener {
    private OSGiWebContainer wc;
    private static final Logger logger = Logger.getLogger(WebExtender.class.getPackage().getName());
    private BundleContext context;
    private Events events = (Events)Globals.get(Events.class);
    private EventListener listener;
    private Semaphore serverReady = new Semaphore(0);

    public void doActualWork() {
        this.wc = new OSGiWebContainer();
        this.context.addBundleListener((BundleListener)this);
        this.registerGlassFishEventListener();
        for (Bundle b : this.context.getBundles()) {
            if ((b.getState() & 0x28) == 0 || !this.isWebBundle(b)) continue;
            this.deploy(b);
        }
        this.addURLHandler();
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.waitForServerToStart();
    }

    private void waitForServerToStart() {
        EventListener serverStartedListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (EventTypes.SERVER_READY.equals((Object)event.type())) {
                    logger.logp(Level.INFO, "WebExtender", "event", "Received Server Started Event");
                    WebExtender.this.serverReady.release();
                    WebExtender.this.events.unregister((EventListener)this);
                }
            }
        };
        this.events.register(serverStartedListener);
        new Thread(new Runnable(){

            public void run() {
                if (!WebExtender.this.isServerStarted()) {
                    logger.logp(Level.INFO, "WebExtender", "run", "Waiting for Server to start");
                    try {
                        WebExtender.this.serverReady.acquire();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                WebExtender.this.doActualWork();
            }
        }).start();
    }

    private boolean isServerStarted() {
        ServerEnvironment serverEnv = (ServerEnvironment)Globals.get(ServerEnvironment.class);
        return serverEnv.getStatus() == ServerEnvironment.Status.started;
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterGlassFishEventListener();
        context.removeBundleListener((BundleListener)this);
        this.wc.undeployAll();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 128: {
                if (this.isLazy(bundle) || !this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                if (!this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 4: {
                if (!this.isWebBundle(bundle)) break;
                this.undeploy(bundle);
            }
        }
    }

    private boolean isLazy(Bundle bundle) {
        return "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private boolean isWebBundle(Bundle b) {
        return b.getHeaders().get("Web-ContextPath") != null;
    }

    private void deploy(Bundle b) {
        try {
            this.wc.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private void undeploy(Bundle b) {
        try {
            this.wc.undeploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private void addURLHandler() {
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"webbundle"});
        this.context.registerService(URLStreamHandlerService.class.getName(), (Object)new WebBundleURLStreamHandlerService(), (Dictionary)p);
    }

    private void registerGlassFishEventListener() {
        this.listener = new EventListener(){

            public void event(EventListener.Event event) {
                if (EventTypes.PREPARE_SHUTDOWN.equals((Object)event.type())) {
                    WebExtender.this.wc.undeployAll();
                }
            }
        };
        this.events.register(this.listener);
    }

    private void unregisterGlassFishEventListener() {
        if (this.listener != null) {
            this.events.unregister(this.listener);
        }
    }
}

