/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.webbeans.DeploymentImpl;
import org.glassfish.webbeans.WebBeansApplicationContainer;
import org.glassfish.webbeans.WebBeansContainer;
import org.glassfish.webbeans.ejb.EjbServicesImpl;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.spi.Deployment;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.ejb.SessionBeanInterceptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebBeansDeployer
extends SimpleDeployer<WebBeansContainer, WebBeansApplicationContainer> {
    static final String WEB_BEAN_EXTENSION = "org.glassfish.webbeans";
    static final String WEB_BEAN_BOOTSTRAP = "org.glassfish.webbeans.WebBeansBootstrap";
    private static final String WEB_BEAN_LISTENER = "org.jboss.webbeans.servlet.WebBeansListener";
    @Inject
    private Habitat habitat;

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        if (ejbBundle != null) {
            Set ejbs = ejbBundle.getEjbs();
            InterceptorDescriptor interceptor = this.createEjbInterceptor(ejbBundle);
            for (EjbDescriptor next : ejbs) {
                if (!next.getType().equals("Session") && !next.getType().equals("Message-driven")) continue;
                next.addFrameworkInterceptor(interceptor);
            }
        }
        return true;
    }

    public WebBeansApplicationContainer load(WebBeansContainer container, DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        ConcurrentHashMapBeanStore applicationBeanStore = new ConcurrentHashMapBeanStore();
        WebBeansBootstrap bootstrap = new WebBeansBootstrap();
        HashSet<EjbDescriptor> ejbs = new HashSet();
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        if (ejbBundle != null) {
            ejbs = ejbBundle.getEjbs();
            EjbServicesImpl ejbServices = new EjbServicesImpl(this.habitat, ejbs);
            bootstrap.getServices().add(EjbServices.class, ejbServices);
        }
        bootstrap.setEnvironment(Environments.SERVLET);
        bootstrap.getServices().add(Deployment.class, new DeploymentImpl(archive, ejbs){});
        bootstrap.setApplicationContext(applicationBeanStore);
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (wDesc != null) {
            wDesc.setExtensionProperty(WEB_BEAN_EXTENSION, "true");
            wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WEB_BEAN_LISTENER));
        }
        WebBeansApplicationContainer wbApp = new WebBeansApplicationContainer(bootstrap);
        bootstrap.initialize();
        context.addTransientAppMetaData(WEB_BEAN_BOOTSTRAP, (Object)bootstrap);
        return wbApp;
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }

    private InterceptorDescriptor createEjbInterceptor(EjbBundleDescriptor ejbBundle) {
        InterceptorDescriptor interceptor = new InterceptorDescriptor();
        Class<SessionBeanInterceptor> wbInterceptor = SessionBeanInterceptor.class;
        String wbInterceptorName = wbInterceptor.getName();
        interceptor.setInterceptorClass(wbInterceptor);
        for (Method m : wbInterceptor.getDeclaredMethods()) {
            LifecycleCallbackDescriptor desc;
            if (m.getAnnotation(PostConstruct.class) != null) {
                desc = new LifecycleCallbackDescriptor();
                desc.setLifecycleCallbackClass(wbInterceptorName);
                desc.setLifecycleCallbackMethod(m.getName());
                interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, desc);
                continue;
            }
            if (m.getAnnotation(PreDestroy.class) != null) {
                desc = new LifecycleCallbackDescriptor();
                desc.setLifecycleCallbackClass(wbInterceptorName);
                desc.setLifecycleCallbackMethod(m.getName());
                interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, desc);
                continue;
            }
            if (m.getAnnotation(AroundInvoke.class) != null) {
                desc = new LifecycleCallbackDescriptor();
                desc.setLifecycleCallbackClass(wbInterceptorName);
                desc.setLifecycleCallbackMethod(m.getName());
                interceptor.addAroundInvokeDescriptor(desc);
                continue;
            }
            if (m.getAnnotation(AroundTimeout.class) == null) continue;
            desc = new LifecycleCallbackDescriptor();
            desc.setLifecycleCallbackClass(wbInterceptorName);
            desc.setLifecycleCallbackMethod(m.getName());
            interceptor.addAroundTimeoutDescriptor(desc);
        }
        return interceptor;
    }
}

