/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.InvalidCommandException;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.component.Habitat;

public class AsadminMain {
    private static String[] copyOfArgs;
    private static String classPath;
    private static String className;
    private static String command;
    private static ProgramOptions po;
    private static Habitat habitat;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings;

    public static void main(String[] args) {
        int minor = JDK.getMinor();
        if (minor < 6) {
            CLILogger.getInstance().printError(strings.get("OldJdk", new Object[]{"" + minor}));
            System.exit(1);
        }
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            CLILogger.getInstance().printDebugMessage("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        StaticModulesRegistry registry = new StaticModulesRegistry(CLICommand.class.getClassLoader());
        habitat = registry.createHabitat("default");
        copyOfArgs = new String[args.length];
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        if (args.length <= 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = AsadminMain.class.getName();
        command = args[0];
        int exitCode = AsadminMain.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (po.isTerse()) break;
                CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                break;
            }
            case 1: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 3: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 2: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public static int executeCommand(String[] argv) {
        CLICommand cmd = null;
        Environment env = new Environment();
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                Map<String, String> params = rcp.getOptions();
                po = new ProgramOptions(params, env);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                po = new ProgramOptions(env);
            }
            po.toEnvironment(env);
            po.setProgramArguments(copyOfArgs);
            po.setClassPath(classPath);
            po.setClassName(className);
            if (argv.length == 0) {
                argv = new String[]{"multimode"};
            }
            command = argv[0];
            habitat.addComponent("environment", (Object)env);
            habitat.addComponent("program-options", (Object)po);
            cmd = CLICommand.getCommand(habitat, command);
            return cmd.execute(argv);
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof InvalidCommandException) {
                CLILogger.getInstance().printError(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(habitat, po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
                }
                catch (InvalidCommandException e) {}
            } else if (ce.getCause() instanceof ConnectException) {
                CLILogger.getInstance().printError(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(habitat), strings.get("ClosestMatchedLocalCommands"));
                }
                catch (InvalidCommandException e) {
                    CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
                }
            } else {
                CLILogger.getInstance().printError(ce.getMessage());
            }
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            if (cmd == null) {
                AsadminMain.printUsage();
            } else {
                CLILogger.getInstance().printError(cmd.getUsage());
            }
            return 1;
        }
    }

    private static void printUsage() {
        CLILogger.getInstance().printError("Usage: asadmin [-H|--host localhost] [-p|--port 4848] [-u|--user anonymous]\n\t[-W|--passwordfile file] [-s|--secure=false] [-e|--echo=false]\n\t[-I|--interactive=true] [-?|--help] [command [options] [operands]]");
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        strings = new LocalStringsImpl(AsadminMain.class);
        Map systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = (String)systemProps.get("com.sun.aas.installRoot");
        String crVal = (String)systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }
}

