/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-commands")
@Scoped(value=PerLookup.class)
public class ListCommandsCommand
extends CLICommand {
    @Inject
    private Habitat habitat;
    private String[] remoteCommands;
    private String[] localCommands;
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private boolean localOnly;
    private boolean remoteOnly;
    private static final String SPACES = "                                                            ";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListCommandsCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        ListCommandsCommand.addOption(opts, "localonly", '\u0000', "BOOLEAN", false, "false");
        ListCommandsCommand.addOption(opts, "remoteonly", '\u0000', "BOOLEAN", false, "false");
        ListCommandsCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandName = "command-pattern";
        this.operandMin = 0;
        this.operandMax = Integer.MAX_VALUE;
        this.processProgramOptions();
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        this.localOnly = this.getBooleanOption("localonly");
        this.remoteOnly = this.getBooleanOption("remoteonly");
        if (this.localOnly && this.remoteOnly) {
            throw new CommandException(strings.get("listCommands.notBoth"));
        }
    }

    public int executeCommand() throws CommandException, CommandValidationException {
        for (String pat : this.operands) {
            this.patterns.add(Pattern.compile(this.globToRegex(pat)));
        }
        if (!this.remoteOnly) {
            this.localCommands = this.matchCommands(CLIUtil.getLocalCommands(this.habitat));
            this.printLocalCommands();
        }
        if (!this.localOnly && !this.remoteOnly) {
            logger.printMessage("");
        }
        if (!this.localOnly) {
            try {
                this.remoteCommands = this.matchCommands(CLIUtil.getRemoteCommands(this.habitat, this.programOpts, this.env));
            }
            catch (CommandException ce) {
                throw new CommandException(ce.getMessage());
            }
            this.printRemoteCommands();
        }
        logger.printMessage("");
        return 0;
    }

    private String[] matchCommands(String[] commands) {
        if (this.patterns.size() == 0) {
            return commands;
        }
        ArrayList<String> matched = new ArrayList<String>();
        for (String cmd : commands) {
            for (Pattern re : this.patterns) {
                if (!re.matcher(cmd).find()) continue;
                matched.add(cmd);
            }
        }
        return matched.toArray(new String[matched.size()]);
    }

    private String globToRegex(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen);
        if (line.startsWith("*")) {
            line = line.substring(1);
            --strLen;
        }
        if (line.endsWith("*")) {
            line = line.substring(0, strLen - 1);
            --strLen;
        }
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : line.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    void printLocalCommands() {
        if (this.localCommands.length == 0) {
            logger.printMessage(strings.get("listCommands.localCommandNoMatch"));
            return;
        }
        logger.printMessage(strings.get("listCommands.localCommandHeader"));
        for (String s : this.localCommands) {
            logger.printMessage(s);
        }
    }

    void printRemoteCommands() {
        if (this.remoteCommands.length == 0) {
            logger.printMessage(strings.get("listCommands.remoteCommandNoMatch"));
            return;
        }
        logger.printMessage(strings.get("listCommands.remoteCommandHeader"));
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(CLIConstants.EOL);
        }
        logger.printMessage(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        return SPACES.substring(0, numSpaces);
    }
}

