/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainsProcessor {
    private CommonInfoModel commonInfo;
    private static final StringManager stringManager = StringManager.getManager(DomainsProcessor.class);
    private static final Logger logger = LogService.getLogger();
    private boolean domainStarted = false;

    public DomainsProcessor(CommonInfoModel ci) {
        this.commonInfo = ci;
    }

    public int startDomain(String domainName) throws HarnessException {
        int exitValue = 0;
        if (!this.domainStarted) {
            exitValue = Commands.startDomain(domainName, this.commonInfo);
            if (exitValue == 0) {
                this.domainStarted = true;
            } else {
                throw new HarnessException(stringManager.getString("upgrade.common.domain_start_failed", (Object)domainName));
            }
        }
        return exitValue;
    }

    public void copyUserLibFiles() {
        File tmpF;
        logger.log(Level.INFO, stringManager.getString("upgrade.common.start_copy_user_libs"));
        String s = this.commonInfo.getSource().getInstallDir();
        File sLibDir = null;
        StringTokenizer t = new StringTokenizer(s, File.separator);
        if (!(t.countTokens() <= 1 || (sLibDir = new File((tmpF = new File(s)).getParentFile().getParentFile(), "lib")).exists() && sLibDir.isDirectory())) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.dir_not_found", (Object)sLibDir.getAbsolutePath()));
            sLibDir = null;
        }
        if (sLibDir == null) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.src_lib_dir_not_found", (Object)(s + "/lib")));
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.warning_user_must_copy_file"));
        } else {
            File tmpF2;
            File tLibDir = null;
            s = this.commonInfo.getTarget().getInstallDir();
            t = new StringTokenizer(s, File.separator);
            if (!(t.countTokens() <= 1 || (tLibDir = new File((tmpF2 = new File(s)).getParentFile(), "lib")).exists() && tLibDir.isDirectory())) {
                logger.log(Level.FINE, stringManager.getString("upgrade.common.dir_not_found", (Object)tLibDir.getAbsolutePath()));
                tLibDir = null;
            }
            if (tLibDir == null) {
                logger.log(Level.WARNING, stringManager.getString("upgrade.common.trg_lib_dir_not_found", (Object)(s + "/lib")));
                logger.log(Level.WARNING, stringManager.getString("upgrade.common.warning_user_must_copy_file"));
            } else {
                UpgradeUtils u = UpgradeUtils.getUpgradeUtils(this.commonInfo);
                u.copyUserLibFiles(sLibDir, tLibDir);
            }
        }
        logger.log(Level.INFO, stringManager.getString("upgrade.common.finished_copy_user_libs"));
    }
}

