/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.gui.MainFrame;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DataCollectionPanel
extends JPanel {
    private static final StringManager stringManager = StringManager.getManager(MainFrame.class);
    private static final CommonInfoModel commonInfoModel = CommonInfoModel.getInstance();
    private static final String REQUIRED_FIELD_CHAR = stringManager.getString("upgrade.gui.detailspanel.requiredField.char");
    private static final String SOURCE_LABEL_TEXT = String.format("%s %s", REQUIRED_FIELD_CHAR, stringManager.getString("upgrade.gui.detailspanel.sourceDirLabel"));
    private static final String TARGET_LABEL_TEXT = String.format("%s %s", REQUIRED_FIELD_CHAR, stringManager.getString("upgrade.gui.detailspanel.targetDirLabel"));
    private static final String REQUIRED_TEXT_LABEL = String.format("(%s %s)", REQUIRED_FIELD_CHAR, stringManager.getString("upgrade.gui.detailspanel.requiredField.text"));
    private final MainFrame mainFrame;
    private final JFileChooser chooser;
    private JPasswordField adminPWField;
    private JTextField adminUserTextField;
    private JSeparator jSeparator1;
    private JPasswordField masterPWField;
    private JButton sourceBrowseButton;
    private JLabel sourceLabel;
    private JTextField sourceTextField;
    private JButton targetBrowseButton;
    private JTextField targetTextField;

    public DataCollectionPanel(MainFrame mainFrame) {
        String masPW;
        Credentials cred;
        this.initComponents();
        this.mainFrame = mainFrame;
        KeyAdapter dirTextKeyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                DataCollectionPanel.this.processDirTextKeyReleased();
            }
        };
        this.sourceTextField.addKeyListener(dirTextKeyAdapter);
        this.targetTextField.addKeyListener(dirTextKeyAdapter);
        String tempStr = commonInfoModel.getSource().getInstallDir();
        if (tempStr != null) {
            this.sourceTextField.setText(tempStr);
        }
        if ((tempStr = commonInfoModel.getTarget().getInstallDir()) != null) {
            this.targetTextField.setText(tempStr);
        }
        if ((cred = commonInfoModel.getSource().getDomainCredentials()).getAdminUserName() != null) {
            this.adminUserTextField.setText(cred.getAdminUserName());
        }
        if (cred.getAdminPassword() != null) {
            this.adminPWField.setText(cred.getAdminPassword());
        }
        if ((masPW = cred.getMasterPassword()) != null && !"changeit".equals(masPW)) {
            this.masterPWField.setText(cred.getMasterPassword());
        }
        this.sourceBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DataCollectionPanel.this.sourceBrowseButtonActionPerformed();
            }
        });
        this.targetBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DataCollectionPanel.this.targetBrowseButtonActionPerformed();
            }
        });
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle(stringManager.getString("upgrade.gui.detailspanel.fileChooseTitle"));
        this.chooser.setFileSelectionMode(1);
    }

    private void initComponents() {
        JLabel headerLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        JLabel contentLabel = new JLabel();
        this.sourceLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.sourceBrowseButton = new JButton();
        JLabel targetLabel = new JLabel();
        this.targetTextField = new JTextField();
        this.targetBrowseButton = new JButton();
        JLabel adminUserLabel = new JLabel();
        this.adminUserTextField = new JTextField();
        JLabel adminPWLabel = new JLabel();
        this.adminPWField = new JPasswordField();
        JLabel masterPWLabel = new JLabel();
        this.masterPWField = new JPasswordField();
        JLabel reqTextLabel = new JLabel();
        headerLabel.setText(stringManager.getString("upgrade.gui.detailspanel.headerPanel"));
        contentLabel.setForeground(Color.blue);
        contentLabel.setText(stringManager.getString("upgrade.gui.detailspanel.contentLabel"));
        this.sourceLabel.setLabelFor(this.sourceTextField);
        this.sourceLabel.setText(SOURCE_LABEL_TEXT);
        this.sourceTextField.setToolTipText(stringManager.getString("upgrade.gui.detailspanel.sourceHelpLabel"));
        this.sourceBrowseButton.setText(stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        targetLabel.setLabelFor(this.targetTextField);
        targetLabel.setText(TARGET_LABEL_TEXT);
        this.targetBrowseButton.setText(stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        adminUserLabel.setLabelFor(this.adminUserTextField);
        adminUserLabel.setText(stringManager.getString("upgrade.gui.detailspanel.adminUserLabel"));
        this.adminUserTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataCollectionPanel.this.adminUserTextFieldActionPerformed(evt);
            }
        });
        adminPWLabel.setLabelFor(this.adminPWField);
        adminPWLabel.setText(stringManager.getString("upgrade.gui.detailspanel.adminPWLabel"));
        masterPWLabel.setLabelFor(this.adminPWField);
        masterPWLabel.setText(stringManager.getString("upgrade.gui.detailspanel.masterPWLabel"));
        reqTextLabel.setText(REQUIRED_TEXT_LABEL);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(contentLabel).addComponent(this.jSeparator1, -1, 497, Short.MAX_VALUE).addComponent(headerLabel, GroupLayout.Alignment.TRAILING, -1, 497, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceLabel).addComponent(targetLabel).addComponent(this.targetTextField, -1, 363, Short.MAX_VALUE).addComponent(this.sourceTextField, -1, 363, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.targetBrowseButton).addComponent(this.sourceBrowseButton))).addComponent(masterPWLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(adminUserLabel).addComponent(this.adminUserTextField, -1, 200, Short.MAX_VALUE).addComponent(this.masterPWField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 55, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(reqTextLabel).addComponent(adminPWLabel).addComponent(this.adminPWField, -2, 242, -2)))).addContainerGap()));
        layout.linkSize(0, this.sourceBrowseButton, this.targetBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(headerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(contentLabel).addGap(18, 18, 18).addComponent(this.sourceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceTextField, -2, -1, -2).addComponent(this.sourceBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(targetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetTextField, -2, -1, -2).addComponent(this.targetBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(adminUserLabel).addComponent(adminPWLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adminUserTextField, -2, 28, -2).addComponent(this.adminPWField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(masterPWLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.masterPWField, -2, -1, -2).addComponent(reqTextLabel)).addContainerGap(18, Short.MAX_VALUE)));
    }

    private void adminUserTextFieldActionPerformed(ActionEvent evt) {
    }

    void checkState() {
        this.processDirTextKeyReleased();
    }

    public String getSourceDirPath() {
        return this.sourceTextField.getText();
    }

    public String getDestinationDirPath() {
        return this.targetTextField.getText();
    }

    public String getAdminUserName() {
        return this.adminUserTextField.getText();
    }

    public String getAdminPassword() {
        return this.adminPWField.getPassword().toString();
    }

    public String getMasterPassword() {
        return this.masterPWField.getPassword().toString();
    }

    private void processDirTextKeyReleased() {
        if (this.sourceTextField.getText().isEmpty() || this.targetTextField.getText().isEmpty()) {
            this.mainFrame.allowContinue(false);
        } else {
            this.mainFrame.allowContinue(true);
        }
    }

    private void sourceBrowseButtonActionPerformed() {
        this.chooser.setCurrentDirectory(null);
        int retVal = this.chooser.showOpenDialog(this.mainFrame);
        if (0 == retVal) {
            this.sourceTextField.setText(this.chooser.getSelectedFile().getPath());
            this.checkState();
        }
    }

    private void targetBrowseButtonActionPerformed() {
        this.chooser.setCurrentDirectory(new File(this.targetTextField.getText()));
        int retVal = this.chooser.showOpenDialog(this.mainFrame);
        if (0 == retVal) {
            this.targetTextField.setText(this.chooser.getSelectedFile().getPath());
            this.checkState();
        }
    }
}

