/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.loader.EJBClassLoader;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.glassfish.api.deployment.InstrumentableClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarClassLoader
extends URLClassLoader
implements InstrumentableClassLoader {
    private final List<ClassLoaderHolder> delegates = new LinkedList<ClassLoaderHolder>();
    private final Method findClass;
    private final Method findLoadedClass;
    private final Method findResource;
    private final Method findResources;
    private static final String EAR_LIB_MODULE = " __ear_lib_module";

    public EarClassLoader(URL[] urls, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        EJBClassLoader earLibClassLoader = new EJBClassLoader((ClassLoader)this);
        for (URL url : urls) {
            earLibClassLoader.addURL(url);
        }
        this.addModuleClassLoader(EAR_LIB_MODULE, (ClassLoader)earLibClassLoader);
        try {
            this.findClass = ClassLoader.class.getDeclaredMethod("findClass", String.class);
            this.findClass.setAccessible(true);
            this.findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            this.findLoadedClass.setAccessible(true);
            this.findResource = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            this.findResource.setAccessible(true);
            this.findResources = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            this.findResources.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void addModuleClassLoader(String moduleName, ClassLoader cl) {
        this.delegates.add(new ClassLoaderHolder(moduleName, cl));
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        for (ClassLoaderHolder clh : this.delegates) {
            if (!moduleName.equals(clh.moduleName)) continue;
            return clh.loader;
        }
        return null;
    }

    public ClassLoader copy() {
        ClassLoader cLoader = this.getModuleClassLoader(EAR_LIB_MODULE);
        if (cLoader instanceof InstrumentableClassLoader) {
            return ((InstrumentableClassLoader)this.getModuleClassLoader(EAR_LIB_MODULE)).copy();
        }
        return null;
    }

    public synchronized void addTransformer(ClassFileTransformer transformer) {
        ClassLoader cLoader = this.getModuleClassLoader(EAR_LIB_MODULE);
        if (cLoader instanceof InstrumentableClassLoader) {
            ((InstrumentableClassLoader)this.getModuleClassLoader(EAR_LIB_MODULE)).addTransformer(transformer);
        }
    }

    @Override
    protected Class<?> findClass(String s) throws ClassNotFoundException {
        Class clazz;
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                clazz = (Class)this.findLoadedClass.invoke((Object)clh.loader, s);
                if (clazz == null) continue;
                return clazz;
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        try {
            return super.findClass(s);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoaderHolder clh : this.delegates) {
                try {
                    clazz = (Class)this.findClass.invoke((Object)clh.loader, s);
                    if (clazz == null) continue;
                    return clazz;
                }
                catch (IllegalAccessException e2) {
                }
                catch (InvocationTargetException e3) {
                }
            }
            throw new ClassNotFoundException(s);
        }
    }

    @Override
    public URL findResource(String s) {
        URL url = null;
        url = super.findResource(s);
        if (url != null) {
            return url;
        }
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                url = (URL)this.findResource.invoke((Object)clh.loader, s);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String s) throws IOException {
        Enumeration<URL> result = super.findResources(s);
        if (result != null) {
            return result;
        }
        Vector urls = new Vector();
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                Enumeration enumeration = (Enumeration)this.findResources.invoke((Object)clh.loader, s);
                while (enumeration.hasMoreElements()) {
                    urls.add(enumeration.nextElement());
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        return urls.elements();
    }

    private class ClassLoaderHolder {
        final ClassLoader loader;
        final String moduleName;

        private ClassLoaderHolder(String moduleName, ClassLoader loader) {
            this.loader = loader;
            this.moduleName = moduleName;
        }
    }
}

