/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.FacesLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInfFacesConfigInfo {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String ABSOLUTE_ORDERING = "absolute-ordering";
    private static final String ORDERING = "ordering";
    private static final String NAME = "name";
    private static final String OTHERS = "others";
    private double version = 2.0;
    private boolean exists;
    private boolean metadataComplete;
    private List<String> absoluteOrdering;

    public WebInfFacesConfigInfo(Document document) {
        this.exists = this.isWebinfFacesConfig(document);
        if (this.exists) {
            this.version = this.getVersion(document);
            if (this.isVersionGreaterOrEqual(2.0)) {
                this.extractOrdering(document);
            }
        }
        this.metadataComplete = this.isMetadataComplete(document);
    }

    public boolean isVersionGreaterOrEqual(double version) {
        return this.version >= version;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public List<String> getAbsoluteOrdering() {
        return this.absoluteOrdering != null ? Collections.unmodifiableList(this.absoluteOrdering) : null;
    }

    private double getVersion(Document document) {
        String version = document.getDocumentElement().getAttributeNS(document.getNamespaceURI(), "version");
        if (version != null && version.length() > 0) {
            return Double.parseDouble(version);
        }
        return 1.1;
    }

    private boolean isWebinfFacesConfig(Document document) {
        String marker = document.getDocumentElement().getAttribute("com.sun.faces.webinf");
        return marker != null && marker.length() > 0;
    }

    private boolean isMetadataComplete(Document document) {
        if (this.exists) {
            if (this.isVersionGreaterOrEqual(2.0)) {
                String metadataComplete = document.getDocumentElement().getAttributeNS(document.getNamespaceURI(), "metadata-complete");
                return metadataComplete != null ? Boolean.valueOf(metadataComplete) : false;
            }
            return true;
        }
        return false;
    }

    private void extractOrdering(Document document) {
        NodeList absoluteOrderingElements;
        String namespace;
        Element documentElement = document.getDocumentElement();
        NodeList orderingElements = documentElement.getElementsByTagNameNS(namespace = documentElement.getNamespaceURI(), ORDERING);
        if (orderingElements.getLength() > 0 && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("jsf.configuration.web.faces.config.contains.ordering");
        }
        if ((absoluteOrderingElements = documentElement.getElementsByTagNameNS(namespace, ABSOLUTE_ORDERING)).getLength() > 0) {
            if (absoluteOrderingElements.getLength() > 1) {
                throw new IllegalStateException("Multiple 'absolute-ordering' elements found within WEB-INF/faces-config.xml");
            }
            Node absoluteOrderingNode = absoluteOrderingElements.item(0);
            NodeList children = absoluteOrderingNode.getChildNodes();
            this.absoluteOrdering = new ArrayList<String>(children.getLength());
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = children.item(i);
                if (NAME.equals(n.getLocalName())) {
                    this.absoluteOrdering.add(this.getNodeText(n));
                    continue;
                }
                if (!OTHERS.equals(n.getLocalName())) continue;
                if (this.absoluteOrdering.contains(OTHERS)) {
                    throw new IllegalStateException("'absolute-ordering' element defined with multiple 'others' child elements found within WEB-INF/faces-config.xml");
                }
                this.absoluteOrdering.add(OTHERS);
            }
        }
    }

    private String getNodeText(Node node) {
        String res = null;
        if (node != null && (res = node.getTextContent()) != null) {
            res = res.trim();
        }
        return res != null && res.length() != 0 ? res : null;
    }
}

