/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;

public class RackApplicationChooser {
    Logger logger = Logger.getLogger(RackApplicationChooser.class.getName());

    public JRubyConfig.Framework which(String appPath, final String appType) {
        if (appType != null) {
            if (appType.equalsIgnoreCase("sinatra")) {
                return this.findSinatra(appPath);
            }
            return new JRubyConfig.Framework(){

                public String type() {
                    return appType;
                }

                public File initScript() {
                    if (RackApplicationChooser.this.isFileOrDir(appType)) {
                        return new File(appType);
                    }
                    return null;
                }
            };
        }
        this.logger.fine("Path is " + appPath + ", checking for Rails");
        JRubyConfig.Framework rails = this.detectRails(appPath);
        if (rails != null) {
            return rails;
        }
        this.logger.fine("Rails not found, checking for Merb");
        JRubyConfig.Framework merb = this.detectMerb(appPath);
        if (merb != null) {
            return merb;
        }
        this.logger.fine("Merb not found, checking for Sinatra");
        JRubyConfig.Framework sinatra = this.findSinatra(appPath);
        if (sinatra != null) {
            return sinatra;
        }
        this.logger.info("Unable to find a supported framework! Checking for rackup (.ru) file");
        JRubyConfig.Framework rackUp = this.findRackup(appPath);
        if (rackUp != null) {
            this.logger.info("Discovered a rackup (.ru) file, attempting to launch a framework from that.");
            return rackUp;
        }
        this.logger.severe("Framework autodetection failed! Please set jruby.applicationType deployment property to the path to a script that will start your framework");
        throw new IllegalStateException("No framework to start!");
    }

    private boolean isFileOrDir(String value) {
        return !value.equals("rails") && !value.equals("merb") && !value.equals("sinatra");
    }

    private boolean isSinatra(File f) {
        String app = "";
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    if (!s.matches("\\s*require\\s*[\"']sinatra[\"']")) continue;
                    return true;
                }
            }
            catch (IOException e) {
                this.logger.severe("IO Exception determining framework for " + f.getAbsolutePath() + ": " + e);
            }
        } else {
            this.logger.severe("Was told to read nonexistant file " + f.getAbsolutePath());
        }
        return false;
    }

    private String inhale(File f) {
        String app = "";
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    String s1;
                    s.trim();
                    if (!s.startsWith("require ") || (s1 = s.substring("require ".length(), s.length() - 1)).equals("sinatra")) {
                        // empty if block
                    }
                    app = app + s + "\n";
                }
            }
            catch (IOException e) {
                this.logger.severe("IO Exception determining framework for " + f.getAbsolutePath() + ": " + e);
            }
        } else {
            this.logger.severe("Was told to read nonexistant file " + f.getAbsolutePath());
        }
        return app;
    }

    private JRubyConfig.Framework findSinatra(String appPath) {
        final File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (final File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".rb")) continue;
                this.logger.fine("Checking " + file.getName());
                if (!this.detectSinatra(file)) continue;
                this.logger.fine("Found Sinatra in " + file.getAbsolutePath());
                return new JRubyConfig.Framework(){

                    public String type() {
                        return "sinatra";
                    }

                    public File initScript() {
                        return file;
                    }
                };
            }
        } else if (this.detectSinatra(appDir)) {
            this.logger.fine("Found Sinatra in " + appDir.getAbsolutePath());
            return new JRubyConfig.Framework(){

                public String type() {
                    return "sinatra";
                }

                public File initScript() {
                    return appDir;
                }
            };
        }
        return null;
    }

    private JRubyConfig.Framework findRackup(String appPath) {
        File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (final File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".ru")) continue;
                return new JRubyConfig.Framework(){

                    public String type() {
                        return "rackup";
                    }

                    public File initScript() {
                        return file;
                    }
                };
            }
        }
        return null;
    }

    private boolean detectSinatra(File appFile) {
        this.logger.fine("attempting to detect sinatra in " + appFile.getPath());
        if (this.isSinatra(appFile)) {
            this.logger.info("Detected Sinatra application");
            return true;
        }
        return false;
    }

    private JRubyConfig.Framework detectRails(String appPath) {
        String bootFile;
        final File boot = new File(appPath, "config/boot.rb");
        if (boot.exists() && ((bootFile = this.inhale(boot)).contains("RAILS_ROOT") || bootFile.contains("Rails.boot!"))) {
            this.logger.info("Detected Rails application");
            return new JRubyConfig.Framework(){

                public String type() {
                    return "rails";
                }

                public File initScript() {
                    return boot;
                }
            };
        }
        return null;
    }

    private JRubyConfig.Framework detectMerb(String appPath) {
        File init = new File(appPath, "config/init.rb");
        if (!init.exists() && !(init = new File(appPath, "root/init.rb")).exists()) {
            return null;
        }
        String initFile = this.inhale(init);
        if (initFile.contains("Merb::Config")) {
            this.logger.info("Detected merb application");
            final File init1 = init;
            return new JRubyConfig.Framework(){

                public String type() {
                    return "merb";
                }

                public File initScript() {
                    return init1;
                }
            };
        }
        return null;
    }
}

