/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jmac.provider.ServerAuthConfig;
import com.sun.enterprise.security.webservices.WebServiceSecurity;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.rpc.spi.runtime.Tie;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPMessage;

public class ServletSystemHandlerDelegate
implements SystemHandlerDelegate {
    protected static final Logger _logger = LogDomains.getLogger(ServletSystemHandlerDelegate.class, (String)"javax.enterprise.system.core.security");
    private static final String IMPLEMENTOR = "com.sun.xml.rpc.server.http.Implementor";
    private static final String SERVER_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ServerAuthContext";
    ServerAuthConfig config_;
    WebServiceEndpoint endpoint_;

    public ServletSystemHandlerDelegate(ServerAuthConfig config, WebServiceEndpoint ep) {
        this.config_ = config;
        this.endpoint_ = ep;
    }

    public boolean processRequest(SOAPMessageContext messageContext) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ws.processRequest");
        }
        final SOAPMessageContext finalMC = messageContext;
        Implementor implementor = (Implementor)messageContext.getProperty(IMPLEMENTOR);
        final Tie tie = implementor.getTie();
        StreamingHandler handler = (StreamingHandler)((Object)implementor.getTie());
        SOAPMessage request = finalMC.getMessage();
        ServerAuthContext sAC = this.config_.getAuthContext(handler, request);
        boolean status = true;
        try {
            if (sAC != null) {
                status = false;
                status = WebServiceSecurity.validateRequest(finalMC, sAC);
                if (status) {
                    messageContext.setProperty(SERVER_AUTH_CONTEXT, sAC);
                }
            }
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "ws.error_validate_request", ae);
            throw new RuntimeException(ae);
        }
        finally {
            WebServiceSecurity.auditInvocation(messageContext, this.endpoint_, status);
        }
        if (status && System.getSecurityManager() != null) {
            status = false;
            try {
                Subject.doAsPrivileged(SecurityContext.getCurrent().getSubject(), new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        tie.handle(finalMC);
                        ServletSystemHandlerDelegate.this.processResponse(finalMC);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AuthException) {
                    _logger.log(Level.SEVERE, "ws.error_secure_response", cause);
                }
                RuntimeException re = null;
                re = cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
                throw re;
            }
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) {
        ServerAuthContext sAC;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ws.processResponse");
        }
        if ((sAC = (ServerAuthContext)messageContext.getProperty(SERVER_AUTH_CONTEXT)) == null) {
            return;
        }
        try {
            WebServiceSecurity.secureResponse(messageContext, sAC);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "ws.error_secure_response", ae);
            throw new RuntimeException(ae);
        }
    }
}

