/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import java.io.Serializable;

public class ConnectorConnectionPool
implements Serializable {
    protected ConnectorDescriptorInfo connectorDescriptorInfo_;
    protected String steadyPoolSize_;
    protected String maxPoolSize_;
    protected String maxWaitTimeInMillis_;
    protected String poolResizeQuantity_;
    protected String idleTimeoutInSeconds_;
    protected boolean failAllConnections_;
    protected boolean matchConnections_ = false;
    protected int transactionSupport_;
    protected boolean isConnectionValidationRequired_ = false;
    private boolean lazyConnectionAssoc_ = false;
    private boolean lazyConnectionEnlist_ = false;
    private boolean associateWithThread_ = false;
    private boolean partitionedPool = false;
    private boolean poolingOn = true;
    private boolean pingDuringPoolCreation = false;
    private String poolDataStructureType;
    private String poolWaitQueue;
    private String dataStructureParameters;
    private String resourceGatewayClass;
    private String resourceSelectionStrategyClass;
    private boolean nonTransactional_ = false;
    private boolean nonComponent_ = false;
    private ConnectorSecurityMap[] securityMaps = null;
    private boolean isAuthCredentialsDefinedInPool_ = false;
    private String maxConnectionUsage;
    private boolean validateAtmostEveryIdleSecs = false;
    private boolean preferValidateOverRecreate_ = false;
    private String validateAtmostOncePeriod_ = null;
    private String conCreationRetryAttempts_ = null;
    private String conCreationRetryInterval_ = null;
    private String connectionLeakTracingTimeout_ = null;
    private boolean connectionReclaim_ = false;
    public static final String DEFAULT_MAX_CONNECTION_USAGE = "0";
    public static final String DEFAULT_CON_CREATION_RETRY_ATTEMPTS = "0";
    public static final String DEFAULT_CON_CREATION_RETRY_INTERVAL = "10";
    public static final String DEFAULT_VALIDATE_ATMOST_ONCE_PERIOD = "0";
    public static final String DEFAULT_LEAK_TIMEOUT = "0";
    private String name;

    public ConnectorConnectionPool(String name) {
        this.name = name;
    }

    public boolean getPingDuringPoolCreation() {
        return this.pingDuringPoolCreation;
    }

    public void setPingDuringPoolCreation(boolean enabled) {
        this.pingDuringPoolCreation = enabled;
    }

    public boolean isPoolingOn() {
        return this.poolingOn;
    }

    public void setPooling(boolean enabled) {
        this.poolingOn = enabled;
    }

    protected ConnectorConnectionPool doClone(String name) {
        ConnectorConnectionPool clone = new ConnectorConnectionPool(name);
        ConnectorDescriptorInfo cdi = this.connectorDescriptorInfo_.doClone();
        clone.setSecurityMaps(this.securityMaps);
        clone.setSteadyPoolSize(this.getSteadyPoolSize());
        clone.setMaxPoolSize(this.getMaxPoolSize());
        clone.setMaxWaitTimeInMillis(this.getMaxWaitTimeInMillis());
        clone.setPoolResizeQuantity(this.getPoolResizeQuantity());
        clone.setIdleTimeoutInSeconds(this.getIdleTimeoutInSeconds());
        clone.setConnectionValidationRequired(this.isConnectionValidationRequired_);
        clone.setFailAllConnections(this.isFailAllConnections());
        clone.setTransactionSupport(this.getTransactionSupport());
        clone.setConnectorDescriptorInfo(cdi);
        clone.setNonComponent(this.isNonComponent());
        clone.setNonTransactional(this.isNonTransactional());
        clone.setMatchConnections(this.matchConnections());
        clone.setLazyConnectionAssoc(this.isLazyConnectionAssoc());
        clone.setAssociateWithThread(this.isAssociateWithThread());
        clone.setPartitionedPool(this.isPartitionedPool());
        clone.setDataStructureParameters(this.getDataStructureParameters());
        clone.setPoolDataStructureType(this.getPoolDataStructureType());
        clone.setPoolWaitQueue(this.getPoolWaitQueue());
        clone.setLazyConnectionEnlist(this.isLazyConnectionEnlist());
        clone.setMaxConnectionUsage(this.getMaxConnectionUsage());
        clone.setValidateAtmostOncePeriod(this.getValidateAtmostOncePeriod());
        clone.setConnectionLeakTracingTimeout(this.getConnectionLeakTracingTimeout());
        clone.setConCreationRetryInterval(this.getConCreationRetryInterval());
        clone.setConCreationRetryAttempts(this.getConCreationRetryAttempts());
        clone.setPreferValidateOverRecreate(this.isPreferValidateOverRecreate());
        clone.setPooling(this.isPoolingOn());
        clone.setPingDuringPoolCreation(this.getPingDuringPoolCreation());
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setAuthCredentialsDefinedInPool(boolean authCred) {
        this.isAuthCredentialsDefinedInPool_ = authCred;
    }

    public boolean getAuthCredentialsDefinedInPool() {
        return this.isAuthCredentialsDefinedInPool_;
    }

    public ConnectorDescriptorInfo getConnectorDescriptorInfo() {
        return this.connectorDescriptorInfo_;
    }

    public void setConnectorDescriptorInfo(ConnectorDescriptorInfo connectorDescriptorInfo) {
        this.connectorDescriptorInfo_ = connectorDescriptorInfo;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize_;
    }

    public void setSteadyPoolSize(String steadyPoolSize) {
        this.steadyPoolSize_ = steadyPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis_;
    }

    public void setMaxWaitTimeInMillis(String maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis_ = maxWaitTimeInMillis;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity_;
    }

    public void setPoolResizeQuantity(String poolResizeQuantity) {
        this.poolResizeQuantity_ = poolResizeQuantity;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds_;
    }

    public void setIdleTimeoutInSeconds(String idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds_ = idleTimeoutInSeconds;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections_;
    }

    public void setFailAllConnections(boolean failAllConnections) {
        this.failAllConnections_ = failAllConnections;
    }

    public boolean matchConnections() {
        return this.matchConnections_;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections_ = matchConnections;
    }

    public int getTransactionSupport() {
        return this.transactionSupport_;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport_ = transactionSupport;
    }

    public void setConnectionValidationRequired(boolean validation) {
        this.isConnectionValidationRequired_ = validation;
    }

    public boolean isIsConnectionValidationRequired() {
        return this.isConnectionValidationRequired_;
    }

    public boolean isLazyConnectionAssoc() {
        return this.lazyConnectionAssoc_;
    }

    public void setLazyConnectionAssoc(boolean enabled) {
        this.lazyConnectionAssoc_ = enabled;
    }

    public boolean isLazyConnectionEnlist() {
        return this.lazyConnectionEnlist_;
    }

    public void setLazyConnectionEnlist(boolean enabled) {
        this.lazyConnectionEnlist_ = enabled;
    }

    public boolean isAssociateWithThread() {
        return this.associateWithThread_;
    }

    public void setAssociateWithThread(boolean enabled) {
        this.associateWithThread_ = enabled;
    }

    public boolean isNonTransactional() {
        return this.nonTransactional_;
    }

    public void setNonTransactional(boolean enabled) {
        this.nonTransactional_ = enabled;
    }

    public boolean isNonComponent() {
        return this.nonComponent_;
    }

    public void setNonComponent(boolean enabled) {
        this.nonComponent_ = enabled;
    }

    public String getConnectionLeakTracingTimeout() {
        return this.connectionLeakTracingTimeout_;
    }

    public void setConnectionLeakTracingTimeout(String timeout) {
        this.connectionLeakTracingTimeout_ = timeout;
    }

    public void setSecurityMaps(ConnectorSecurityMap[] securityMapArray) {
        this.securityMaps = securityMapArray;
    }

    public ConnectorSecurityMap[] getSecurityMaps() {
        return this.securityMaps;
    }

    public boolean isValidateAtmostEveryIdleSecs() {
        return this.validateAtmostEveryIdleSecs;
    }

    public void setValidateAtmostEveryIdleSecs(boolean enabled) {
        this.validateAtmostEveryIdleSecs = enabled;
    }

    public void setMaxConnectionUsage(String count) {
        this.maxConnectionUsage = count;
    }

    public String getMaxConnectionUsage() {
        return this.maxConnectionUsage;
    }

    public String getConCreationRetryInterval() {
        return this.conCreationRetryInterval_;
    }

    public void setConCreationRetryInterval(String retryInterval) {
        this.conCreationRetryInterval_ = retryInterval;
    }

    public String getConCreationRetryAttempts() {
        return this.conCreationRetryAttempts_;
    }

    public void setConCreationRetryAttempts(String retryAttempts) {
        this.conCreationRetryAttempts_ = retryAttempts;
    }

    public String getValidateAtmostOncePeriod() {
        return this.validateAtmostOncePeriod_;
    }

    public void setValidateAtmostOncePeriod(String validateAtmostOncePeriod) {
        this.validateAtmostOncePeriod_ = validateAtmostOncePeriod;
    }

    public boolean isConnectionReclaim() {
        return this.connectionReclaim_;
    }

    public void setConnectionReclaim(boolean connectionReclaim) {
        this.connectionReclaim_ = connectionReclaim;
    }

    public String toString() {
        String returnVal = null;
        StringBuffer sb = new StringBuffer("ConnectorConnectionPool :: ");
        try {
            sb.append(this.getName());
            sb.append("\nsteady size: ");
            sb.append(this.getSteadyPoolSize());
            sb.append("\nmax pool size: ");
            sb.append(this.getMaxPoolSize());
            sb.append("\nmax wait time: ");
            sb.append(this.getMaxWaitTimeInMillis());
            sb.append("\npool resize qty: ");
            sb.append(this.getPoolResizeQuantity());
            sb.append("\nIdle timeout: ");
            sb.append(this.getIdleTimeoutInSeconds());
            sb.append("\nfailAllConnections: ");
            sb.append(this.isFailAllConnections());
            sb.append("\nTransaction Support Level: ");
            sb.append(this.transactionSupport_);
            sb.append("\nisConnectionValidationRequired_ ");
            sb.append(this.isConnectionValidationRequired_);
            sb.append("\npreferValidateOverRecreate_ ");
            sb.append(this.preferValidateOverRecreate_);
            sb.append("\nmatchConnections_ ");
            sb.append(this.matchConnections_);
            sb.append("\nassociateWithThread_ ");
            sb.append(this.associateWithThread_);
            sb.append("\nlazyConnectionAssoc_ ");
            sb.append(this.lazyConnectionAssoc_);
            sb.append("\nlazyConnectionEnlist_ ");
            sb.append(this.lazyConnectionEnlist_);
            sb.append("\nmaxConnectionUsage_ ");
            sb.append(this.maxConnectionUsage);
            sb.append("\nvalidateAtmostOncePeriod_ ");
            sb.append(this.validateAtmostOncePeriod_);
            sb.append("\nconnectionLeakTracingTimeout_");
            sb.append(this.connectionLeakTracingTimeout_);
            sb.append("\nconnectionReclaim_");
            sb.append(this.connectionReclaim_);
            sb.append("\nconnectionCreationRetryAttempts_");
            sb.append(this.conCreationRetryAttempts_);
            sb.append("\nconnectionCreationRetryIntervalInMilliSeconds_");
            sb.append(this.conCreationRetryInterval_);
            sb.append("\nnonTransactional_ ");
            sb.append(this.nonTransactional_);
            sb.append("\nnonComponent_ ");
            sb.append(this.nonComponent_);
            sb.append("\nConnectorDescriptorInfo -> ");
            sb.append("\nrarName: ");
            if (this.connectorDescriptorInfo_ != null) {
                sb.append(this.connectorDescriptorInfo_.getRarName());
                sb.append("\nresource adapter class: ");
                sb.append(this.connectorDescriptorInfo_.getResourceAdapterClassName());
                sb.append("\nconnection def name: ");
                sb.append(this.connectorDescriptorInfo_.getConnectionDefinitionName());
                sb.append("\nMCF Config properties-> ");
                for (Object o : this.connectorDescriptorInfo_.getMCFConfigProperties()) {
                    ConnectorConfigProperty ep = (ConnectorConfigProperty)o;
                    sb.append(ep.getName());
                    sb.append(":");
                    sb.append("password".equalsIgnoreCase(ep.getName()) ? "****" : ep.getValue());
                    sb.append("\n");
                }
            }
            if (this.securityMaps != null) {
                sb.append("SecurityMaps -> {");
                for (ConnectorSecurityMap securityMap : this.securityMaps) {
                    if (securityMap == null || securityMap.getName() == null) continue;
                    sb.append(securityMap.getName());
                    sb.append(" ");
                }
                sb.append("}");
            }
            returnVal = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public boolean isPartitionedPool() {
        return this.partitionedPool;
    }

    public void setPartitionedPool(boolean partitionedPool) {
        this.partitionedPool = partitionedPool;
    }

    public String getPoolDataStructureType() {
        return this.poolDataStructureType;
    }

    public void setPoolDataStructureType(String poolDataStructureType) {
        this.poolDataStructureType = poolDataStructureType;
    }

    public String getPoolWaitQueue() {
        return this.poolWaitQueue;
    }

    public void setPoolWaitQueue(String poolWaitQueue) {
        this.poolWaitQueue = poolWaitQueue;
    }

    public String getDataStructureParameters() {
        return this.dataStructureParameters;
    }

    public void setDataStructureParameters(String dataStructureParameters) {
        this.dataStructureParameters = dataStructureParameters;
    }

    public String getResourceGatewayClass() {
        return this.resourceGatewayClass;
    }

    public void setResourceGatewayClass(String resourceGatewayClass) {
        this.resourceGatewayClass = resourceGatewayClass;
    }

    public String getResourceSelectionStrategyClass() {
        return this.resourceSelectionStrategyClass;
    }

    public void setResourceSelectionStrategyClass(String resourceSelectionStrategyClass) {
        this.resourceSelectionStrategyClass = resourceSelectionStrategyClass;
    }

    public boolean isPreferValidateOverRecreate() {
        return this.preferValidateOverRecreate_;
    }

    public void setPreferValidateOverRecreate(boolean preferValidateOverRecreate) {
        this.preferValidateOverRecreate_ = preferValidateOverRecreate;
    }
}

