/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ReinvokeAware;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class ReadFilter
implements ProtocolFilter,
ReinvokeAware {
    public static final String DELAYED_CLOSE_NOTIFICATION = "delayedClose";
    public static final String UDP_SOCKETADDRESS = "socketAddress";
    protected boolean continousExecution = false;
    protected int readAttempts = 3;

    public boolean execute(Context ctx) throws IOException {
        return this.execute(ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execute(Context ctx, ByteBuffer byteBuffer) throws IOException {
        if (ctx.getCurrentOpType() == Context.OpType.OP_WRITE) {
            if (!Controller.logger().isLoggable(Level.FINE)) return false;
            Controller.logger().fine("ReadFilter cannont handle OP_WRITE");
            return false;
        }
        if (byteBuffer == null) {
            byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
            int size = 8192;
            ByteBufferFactory.ByteBufferType bbt = WorkerThreadImpl.DEFAULT_BYTEBUFFER_TYPE;
            if (ctx.getSelectorHandler().getThreadPool() instanceof DefaultThreadPool) {
                DefaultThreadPool tp = (DefaultThreadPool)ctx.getSelectorHandler().getThreadPool();
                size = tp.getInitialByteBufferSize();
                bbt = tp.getByteBufferType();
            }
            if (byteBuffer == null) {
                byteBuffer = ByteBufferFactory.allocateView((int)size, (bbt == ByteBufferFactory.ByteBufferType.DIRECT ? 1 : 0) != 0);
                ((WorkerThread)Thread.currentThread()).setByteBuffer(byteBuffer);
            }
        }
        if (!byteBuffer.hasRemaining()) {
            throw new IllegalStateException("ByteBuffer is full: " + byteBuffer);
        }
        boolean invokeNextFilter = true;
        int count = 0;
        int nRead = 0;
        SocketAddress socketAddress = null;
        Exception exception = null;
        SelectionKey key = ctx.getSelectionKey();
        Controller.Protocol protocol = ctx.getProtocol();
        try {
            block41: {
                try {
                    int loop = 0;
                    if (protocol == Controller.Protocol.TCP || protocol == Controller.Protocol.TLS) {
                        SocketChannel channel = (SocketChannel)key.channel();
                        while ((count = channel.read(byteBuffer)) > -1) {
                            nRead += count;
                            if (++loop < this.readAttempts) continue;
                            if (nRead == 0 && ctx.getKeyRegistrationState() != Context.KeyRegistrationState.NONE) {
                                ctx.setAttribute("succes_read", Boolean.FALSE);
                                invokeNextFilter = false;
                            }
                            break block41;
                        }
                        break block41;
                    }
                    if (protocol != Controller.Protocol.UDP) break block41;
                    DatagramChannel datagramChannel = (DatagramChannel)key.channel();
                    socketAddress = datagramChannel.receive(byteBuffer);
                    ctx.getSelectorHandler().register(key, 1);
                }
                catch (IOException ex) {
                    exception = ex;
                    this.log("ReadFilter.execute", ex);
                    Object var13_18 = null;
                    SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
                    if (skh222 instanceof BaseSelectionKeyHandler) {
                        ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandlerNotifier", (Object)((BaseSelectionKeyHandler)skh222));
                    }
                    if (exception != null) {
                        ctx.setAttribute("throwable", exception);
                        if (protocol != Controller.Protocol.UDP) {
                            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        }
                        if (nRead <= 0) {
                            invokeNextFilter = false;
                            if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                            ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                            return invokeNextFilter;
                        }
                        ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                        return invokeNextFilter;
                    }
                    if (count == -1 && protocol != Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        if (nRead <= 0) {
                            invokeNextFilter = false;
                            if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                            ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                            return invokeNextFilter;
                        }
                        ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                        return invokeNextFilter;
                    }
                    if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                        return false;
                    }
                    if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
                    ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
                    return invokeNextFilter;
                }
                catch (RuntimeException ex) {
                    exception = ex;
                    this.log("ReadFilter.execute", ex);
                    Object var13_19 = null;
                    SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
                    if (skh222 instanceof BaseSelectionKeyHandler) {
                        ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandlerNotifier", (Object)((BaseSelectionKeyHandler)skh222));
                    }
                    if (exception != null) {
                        ctx.setAttribute("throwable", exception);
                        if (protocol != Controller.Protocol.UDP) {
                            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        }
                        if (nRead <= 0) {
                            invokeNextFilter = false;
                            if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                            ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                            return invokeNextFilter;
                        }
                        ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                        return invokeNextFilter;
                    }
                    if (count == -1 && protocol != Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        if (nRead <= 0) {
                            invokeNextFilter = false;
                            if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                            ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                            return invokeNextFilter;
                        }
                        ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                        return invokeNextFilter;
                    }
                    if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                        return false;
                    }
                    if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
                    ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
                    return invokeNextFilter;
                }
            }
            Object var13_17 = null;
            SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandlerNotifier", (Object)((BaseSelectionKeyHandler)skh222));
            }
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                if (protocol != Controller.Protocol.UDP) {
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                }
                if (nRead <= 0) {
                    invokeNextFilter = false;
                    if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                    ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                    return invokeNextFilter;
                }
                ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                return invokeNextFilter;
            }
            if (count == -1 && protocol != Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                if (nRead <= 0) {
                    invokeNextFilter = false;
                    if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                    ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                    return invokeNextFilter;
                }
                ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                return invokeNextFilter;
            }
            if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                return false;
            }
            if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
            ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
            return invokeNextFilter;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandlerNotifier", (Object)((BaseSelectionKeyHandler)skh222));
            }
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                if (protocol != Controller.Protocol.UDP) {
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                }
                if (nRead <= 0) {
                    invokeNextFilter = false;
                    if (!(skh222 instanceof BaseSelectionKeyHandler)) throw throwable;
                    ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                    throw throwable;
                }
                ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                throw throwable;
            }
            if (count == -1 && protocol != Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                if (nRead <= 0) {
                    invokeNextFilter = false;
                    if (!(skh222 instanceof BaseSelectionKeyHandler)) throw throwable;
                    ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                    throw throwable;
                }
                ctx.setAttribute(DELAYED_CLOSE_NOTIFICATION, Boolean.TRUE);
                throw throwable;
            }
            if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                invokeNextFilter = false;
                throw throwable;
            }
            if (protocol != Controller.Protocol.UDP) throw throwable;
            ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExecute(Context ctx) throws IOException {
        boolean isReinvoke;
        Context.KeyRegistrationState state;
        SelectionKey key;
        SelectorHandler selectorHandler;
        block9: {
            boolean bl;
            selectorHandler = ctx.getSelectorHandler();
            key = ctx.getSelectionKey();
            state = ctx.getKeyRegistrationState();
            Controller.Protocol protocol = ctx.getProtocol();
            try {
                if (protocol != Controller.Protocol.UDP) break block9;
                bl = true;
                Object var11_8 = null;
                ctx.removeAttribute("throwable");
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                ctx.removeAttribute("throwable");
                ctx.removeAttribute(UDP_SOCKETADDRESS);
                throw throwable;
            }
            ctx.removeAttribute(UDP_SOCKETADDRESS);
            return bl;
        }
        ProtocolChain protocolChain = ctx.getProtocolChain();
        boolean bl = isReinvoke = this.continousExecution && protocolChain instanceof ReinvokeAware && ((ReinvokeAware)((Object)protocolChain)).isContinuousExecution();
        if (isReinvoke && state == Context.KeyRegistrationState.REGISTER && Boolean.FALSE != (Boolean)ctx.getAttribute("succes_read")) {
            ctx.setAttribute("succes_read", Boolean.TRUE);
        } else {
            SelectionKeyHandler skh;
            Boolean isDelayedNotification = (Boolean)ctx.removeAttribute(DELAYED_CLOSE_NOTIFICATION);
            if (isDelayedNotification == Boolean.TRUE && (skh = ctx.getSelectorHandler().getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(key);
            }
            if (state == Context.KeyRegistrationState.CANCEL) {
                selectorHandler.getSelectionKeyHandler().cancel(key);
            } else if (state == Context.KeyRegistrationState.REGISTER) {
                selectorHandler.register(key, 1);
            }
        }
        boolean bl2 = true;
        Object var11_9 = null;
        ctx.removeAttribute("throwable");
        ctx.removeAttribute(UDP_SOCKETADDRESS);
        return bl2;
    }

    public void setContinuousExecution(boolean continousExecution) {
        this.continousExecution = continousExecution;
    }

    public boolean isContinuousExecution() {
        return this.continousExecution;
    }

    public int getReadAttempts() {
        return this.readAttempts;
    }

    public void setReadAttempts(int readAttempts) {
        if (readAttempts < 1) {
            throw new IllegalArgumentException("The readAttempts parameter should be >= 1");
        }
        this.readAttempts = readAttempts;
    }

    protected void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, msg, t);
        }
    }
}

