/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.external.probe.provider.StatsProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsProviderRegistry {
    List<StatsProviderRegistryElement> regElements = new ArrayList<StatsProviderRegistryElement>();
    private Map<String, List<StatsProviderRegistryElement>> configToRegistryElementMap = new HashMap<String, List<StatsProviderRegistryElement>>();
    private Map<Object, StatsProviderRegistryElement> statsProviderToRegistryElementMap = new HashMap<Object, StatsProviderRegistryElement>();
    private Map<String, Boolean> configEnabledMap = new HashMap<String, Boolean>();
    private MonitoringRuntimeDataRegistry mrdr;
    private boolean isAMXReady = false;
    private boolean isMBeanEnabled = true;

    public StatsProviderRegistry(MonitoringRuntimeDataRegistry mrdr) {
        this.mrdr = mrdr;
    }

    public void registerStatsProvider(String configStr, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider, String mbeanName, ManagedObjectManager mom) {
        StatsProviderRegistryElement spre = new StatsProviderRegistryElement(configStr, parentTreeNodePath, childTreeNodeNames, handles, statsProvider, mbeanName, mom);
        if (this.configToRegistryElementMap.containsKey(configStr)) {
            List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configStr);
            spreList.add(spre);
        } else {
            ArrayList<StatsProviderRegistryElement> spreList = new ArrayList<StatsProviderRegistryElement>();
            spreList.add(spre);
            this.configToRegistryElementMap.put(configStr, spreList);
        }
        this.statsProviderToRegistryElementMap.put(statsProvider, spre);
    }

    public void unregisterStatsProvider(Object statsProvider) throws Exception {
        StatsProviderRegistryElement spre = this.statsProviderToRegistryElementMap.get(statsProvider);
        if (spre == null) {
            throw new Exception("Invalid statsProvider, cannot unregister");
        }
        String parentNodePath = spre.getParentTreeNodePath();
        List<String> childNodeNames = spre.getChildTreeNodeNames();
        TreeNode rootNode = this.mrdr.get("server");
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath);
            TreeNode parentNode = (TreeNode)nodeList.get(0);
            Collection childNodes = parentNode.getChildNodes();
            for (TreeNode childNode : childNodes) {
                if (!childNodeNames.contains(childNode.getName())) continue;
                parentNode.removeChild(childNode);
            }
        }
        Collection<ProbeClientMethodHandle> handles = spre.getHandles();
        for (ProbeClientMethodHandle handle : handles) {
        }
        this.unregisterGmbal(spre);
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(spre.getConfigStr());
        if (spreList != null) {
            spreList.remove(spre);
            if (spreList.isEmpty()) {
                this.configToRegistryElementMap.remove(spre.getConfigStr());
            }
        }
        this.statsProviderToRegistryElementMap.remove(statsProvider);
        spre.setStatsProvider(null);
    }

    public void enableStatsProvider(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            Object sp = spre.getStatsProvider();
            if (sp instanceof StatsProvider) {
                ((StatsProvider)sp).enable();
            }
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null) {
                List nodeList = rootNode.getNodes(parentNodePath);
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName()) || childNode.isEnabled()) continue;
                    childNode.setEnabled(true);
                }
            }
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (handle.isEnabled()) continue;
                handle.enable();
            }
            if (!this.isAMXReady() || !this.isMBeanEnabled()) continue;
            this.registerGmbal(spre);
        }
    }

    public void disableStatsProvider(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            Object sp = spre.getStatsProvider();
            if (sp instanceof StatsProvider) {
                ((StatsProvider)sp).disable();
            }
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null) {
                List nodeList = rootNode.getNodes(parentNodePath);
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName()) || !childNode.isEnabled()) continue;
                    childNode.setEnabled(false);
                }
            }
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (!handle.isEnabled()) continue;
                handle.disable();
            }
            this.unregisterGmbal(spre);
        }
    }

    void registerGmbal(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            this.registerGmbal(spre);
        }
    }

    void unregisterGmbal(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            this.unregisterGmbal(spre);
        }
    }

    void registerGmbal(StatsProviderRegistryElement spre) {
        Object statsProvider = spre.getStatsProvider();
        ManagedObjectManager mom = spre.getManagedObjectManager();
        if (mom == null) {
            mom = ManagedObjectManagerFactory.createFederated(StatsProviderManagerDelegateImpl.MONITORING_SERVER);
            spre.setManagedObjectManager(mom);
            String mbeanName = spre.getMBeanName();
            mom.stripPackagePrefix();
            if (mbeanName != null && !mbeanName.isEmpty()) {
                mom.createRoot(statsProvider, mbeanName);
            } else {
                mom.createRoot(statsProvider);
            }
        }
    }

    void unregisterGmbal(StatsProviderRegistryElement spre) {
        ManagedObjectManager mom = spre.getManagedObjectManager();
        if (mom != null) {
            mom.unregister(spre.getStatsProvider());
            try {
                mom.close();
            }
            catch (IOException ioe) {
                Logger.getLogger(StatsProviderRegistry.class.getName()).log(Level.SEVERE, null, ioe);
            }
            spre.setManagedObjectManager(null);
        }
    }

    void registerAllGmbal() {
        for (StatsProviderRegistryElement spre : this.statsProviderToRegistryElementMap.values()) {
            this.registerGmbal(spre);
        }
    }

    void unregisterAllGmbal() {
        for (StatsProviderRegistryElement spre : this.statsProviderToRegistryElementMap.values()) {
            this.unregisterGmbal(spre);
        }
    }

    boolean getConfigEnabled(String configElement) {
        return this.configEnabledMap.get(configElement);
    }

    void setConfigEnabled(String configElement, boolean enabled) {
        this.configEnabledMap.put(configElement, enabled);
    }

    Collection<StatsProviderRegistryElement> getSpreList() {
        return this.statsProviderToRegistryElementMap.values();
    }

    void setAMXReady(boolean ready) {
        this.isAMXReady = ready;
    }

    boolean isAMXReady() {
        return this.isAMXReady;
    }

    void setMBeanEnabled(boolean enabled) {
        this.isMBeanEnabled = enabled;
    }

    boolean isMBeanEnabled() {
        return this.isMBeanEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatsProviderRegistryElement {
        String configStr;
        String parentTreeNodePath;
        List<String> childTreeNodeNames;
        Collection<ProbeClientMethodHandle> handles;
        Object statsProvider;
        String mbeanName;
        ManagedObjectManager mom;

        public StatsProviderRegistryElement(String configStr, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider, String mbeanName, ManagedObjectManager mom) {
            this.configStr = configStr;
            this.handles = handles;
            this.parentTreeNodePath = parentTreeNodePath;
            this.childTreeNodeNames = childTreeNodeNames;
            this.statsProvider = statsProvider;
            this.mbeanName = mbeanName;
            this.mom = mom;
        }

        public String getConfigStr() {
            return this.configStr;
        }

        public List<String> getChildTreeNodeNames() {
            return this.childTreeNodeNames;
        }

        public String getParentTreeNodePath() {
            return this.parentTreeNodePath;
        }

        public Collection<ProbeClientMethodHandle> getHandles() {
            return this.handles;
        }

        public Object getStatsProvider() {
            return this.statsProvider;
        }

        private void setStatsProvider(Object statsProvider) {
            this.statsProvider = statsProvider;
        }

        public String getMBeanName() {
            return this.mbeanName;
        }

        public ManagedObjectManager getManagedObjectManager() {
            return this.mom;
        }

        void setManagedObjectManager(ManagedObjectManager mom) {
            this.mom = mom;
        }
    }
}

