/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="JVM Runtime Statistics")
public class JVMRuntimeStatsProvider {
    private RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();

    @ManagedAttribute(id="bootclasspath-current")
    @Description(value="boot class path that is used by the bootstrap class loader to search for class files")
    public String getBootClassPath() {
        return this.rtBean.getBootClassPath();
    }

    @ManagedAttribute(id="classpath-current")
    @Description(value="Java class path that is used by the system class loader to search for class files")
    public String getClassPath() {
        return this.rtBean.getClassPath();
    }

    @ManagedAttribute(id="inputarguments-current")
    @Description(value="input arguments passed to the Java virtual machine which does not include the arguments to the main method")
    public List<String> getInputArguments() {
        return this.rtBean.getInputArguments();
    }

    @ManagedAttribute(id="librarypath-current")
    @Description(value="Java library path")
    public String getLibraryPath() {
        return this.rtBean.getLibraryPath();
    }

    @ManagedAttribute(id="managementspecversion-current")
    @Description(value="version of the specification for the management interface implemented by the running Java virtual machine")
    public String getManagementSpecVersion() {
        return this.rtBean.getManagementSpecVersion();
    }

    @ManagedAttribute(id="name-current")
    @Description(value="name representing the running Java virtual machine")
    public String getRuntimeName() {
        return this.rtBean.getName();
    }

    @ManagedAttribute(id="specname-current")
    @Description(value="Java virtual machine specification name")
    public String getSpecName() {
        return this.rtBean.getSpecName();
    }

    @ManagedAttribute(id="specvendor-current")
    @Description(value="Java virtual machine specification vendor")
    public String getSpecVendor() {
        return this.rtBean.getSpecVendor();
    }

    @ManagedAttribute(id="specversion-current")
    @Description(value="Java virtual machine specification version")
    public String getSpecVersion() {
        return this.rtBean.getSpecVersion();
    }

    @ManagedAttribute(id="uptime-count")
    @Description(value="uptime of the Java virtual machine in milliseconds")
    public long getUptime() {
        return this.rtBean.getUptime();
    }

    @ManagedAttribute(id="vmname-current")
    @Description(value="Java virtual machine implementation name")
    public String getVmName() {
        return this.rtBean.getSpecName();
    }

    @ManagedAttribute(id="vmvendor-current")
    @Description(value="Java virtual machine implementation vendor")
    public String getVmVendor() {
        return this.rtBean.getSpecVendor();
    }

    @ManagedAttribute(id="vmversion-current")
    @Description(value="Java virtual machine implementation version")
    public String getVmVersion() {
        return this.rtBean.getSpecVersion();
    }
}

