/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.container.common.LocalPassword;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.internal.api.AdminAccessController;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator {
    @Inject
    volatile SecurityService ss;
    private final String defaultAdminUser = "anonymous";
    @Inject
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    private final Logger logger = Logger.getAnonymousLogger();

    public boolean login(String user, String password, String realm) throws LoginException {
        return this.handleFileRealm(user, password, realm);
    }

    private boolean handleFileRealm(String user, String password, String realm) throws LoginException {
        boolean anonok = this.serverAllowsAnonymousFileRealmLogin();
        if (anonok) {
            return anonok;
        }
        boolean isLocal = this.isLocalPassword(user, password);
        if (isLocal) {
            return true;
        }
        try {
            AuthRealm ar = this.as.getAssociatedAuthRealm();
            if (FileRealm.class.getName().equals(ar.getClassname())) {
                String adminKeyFilePath = ar.getPropertyValue("file");
                FileRealm fr = new FileRealm(adminKeyFilePath);
                FileRealmUser fru = (FileRealmUser)fr.getUser(user);
                for (String group : fru.getGroups()) {
                    if (!group.equals("asadmin")) continue;
                    return fr.authenticate(user, password) != null;
                }
                return false;
            }
        }
        catch (NoSuchUserException ue) {
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        return false;
    }

    private boolean serverAllowsAnonymousFileRealmLogin() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            throw new RuntimeException("Warning: Configuration is bad, realm: " + this.as.getAuthRealmName() + " does not exist!");
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            this.logger.fine("NOT ALLOWING ANONYMOUS ADMIN LOGIN, SINCE IT's NOT A FILE");
            return false;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            this.logger.fine("ALLOWING ANONYMOUS ADMIN LOGIN AS THE KEYFILE DOES NOT EXIST");
            return true;
        }
        try {
            String au;
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            Enumeration users = fr.getUserNames();
            if (users.hasMoreElements() && "anonymous".equals(au = (String)users.nextElement()) && !users.hasMoreElements()) {
                this.logger.fine("Allowing anonymous access");
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isLocalPassword(String user, String password) {
        if (!this.localPassword.isLocalPassword(password)) {
            this.logger.finest("Password is not the local password");
            return false;
        }
        this.logger.fine("Allowing access using local password");
        return true;
    }

    public Subject authenticate(Object credentials) {
        if (this.serverAllowsAnonymousFileRealmLogin()) {
            this.logger.fine("Allowing anonymous login for JMX Access");
            return null;
        }
        if (!(credentials instanceof String[])) {
            throw new SecurityException("The JMX Connector should access with a two-element string array containing user name and password");
        }
        String[] up = (String[])credentials;
        if (up.length < 2) {
            throw new SecurityException("The JMX Connector should access with a two-element string array containing user name and password");
        }
        String u = up[0];
        String p = up[1];
        String realm = this.as.getSystemJmxConnector().getAuthRealmName();
        if (realm == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            this.login(u, p, realm);
            return null;
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }
}

