/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.jws.DeveloperContentHandler;
import org.glassfish.appclient.server.core.jws.ExtensionFileManager;
import org.glassfish.appclient.server.core.jws.JWSAdapterManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartState;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class JavaWebStartInfo
implements ConfigListener {
    private static final String GLASSFISH_DIRECTORY_PREFIX = "glassfish/";
    @Inject
    private JWSAdapterManager jwsAdapterManager;
    @Inject
    private ASJarSigner jarSigner;
    @Inject
    private DeveloperContentHandler dch;
    @Inject
    private ExtensionFileManager extensionFileManager;
    private AppClientServerApplication acServerApp;
    private Set<Content> myContent = null;
    private DeploymentContext dc = null;
    private TokenHelper tHelper;
    private Logger logger;
    private final Map<String, StaticContent> staticContent = new HashMap<String, StaticContent>();
    private final Map<String, DynamicContent> dynamicContent = new HashMap<String, DynamicContent>();
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String DOC_TEMPLATE_PREFIX = "/org/glassfish/appclient/server/core/jws/templates/";
    private static final String MAIN_DOCUMENT_TEMPLATE = "/org/glassfish/appclient/server/core/jws/templates/appclientMainDocumentTemplate.jnlp";
    private static final String CLIENT_DOCUMENT_TEMPLATE = "/org/glassfish/appclient/server/core/jws/templates/appclientClientDocumentTemplate.jnlp";
    private static final String MAIN_IMAGE_XML_PROPERTY_NAME = "appclient.main.information.images";
    private static final String APP_LIBRARY_EXTENSION_PROPERTY_NAME = "app.library.extension";
    private static final String APP_CLIENT_MAIN_CLASS_ARGUMENTS_PROPERTY_NAME = "appclient.main.class.arguments";
    private static final String CLIENT_FACADE_JAR_PATH_PROPERTY_NAME = "client.facade.jar.path";
    private static final String CLIENT_JAR_PATH_PROPERTY_NAME = "client.jar.path";
    private boolean isJWSEligible;
    private volatile boolean isJWSEnabledAtApp = true;
    private volatile boolean isJWSEnabledAtModule = true;
    private final JavaWebStartState jwsState = new JavaWebStartState();
    private static final String JAVA_WEB_START_ENABLED_PROPERTY_NAME = "java-web-start-enabled";
    private AppClientDeployerHelper helper;
    private ApplicationClientDescriptor acDesc;
    private String jnlpDoc;
    private static final List<SignedSystemContentFromApp> SIGNED_SYSTEM_CONTENT_SERVED_AT_APP_LEVEL = Arrays.asList(new SignedSystemContentFromApp("gf-client.jar", "glassfish/modules/gf-client.jar"), new SignedSystemContentFromApp("gf-client-module.jar", "glassfish/modules/gf-client-module.jar"));

    public void init(AppClientServerApplication acServerApp) {
        this.acServerApp = acServerApp;
        this.helper = acServerApp.helper();
        this.acDesc = acServerApp.getDescriptor();
        this.logger = LogDomains.getLogger(AppClientServerApplication.class, (String)"javax.enterprise.system.container.appclient");
        this.dc = acServerApp.dc();
        this.isJWSEligible = this.acDesc.getJavaWebStartAccessDescriptor().isEligible();
        this.isJWSEnabledAtApp = this.isJWSEnabled(this.dc.getAppProps());
        this.isJWSEnabledAtModule = this.isJWSEnabled(this.dc.getModuleProps());
        this.tHelper = TokenHelper.newInstance(this.helper);
        String devJNLPDoc = this.acDesc.getJavaWebStartAccessDescriptor().getJnlpDocument();
        File sourceDir = this.acDesc.getApplication().isVirtual() ? this.dc.getSourceDir() : new File(this.dc.getSource().getParentArchive().getURI());
        this.jnlpDoc = devJNLPDoc;
        this.dch.init(this.dc.getClassLoader(), this.tHelper, sourceDir, this.staticContent, this.dynamicContent, devJNLPDoc);
    }

    public void start() {
        if (this.isJWSRunnable()) {
            this.jwsState.transition(JavaWebStartState.Action.START, new Runnable(){

                public void run() {
                    try {
                        JavaWebStartInfo.this.startJWSServices();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
    }

    public void stop() {
        this.jwsState.transition(JavaWebStartState.Action.STOP, new Runnable(){

            public void run() {
                try {
                    JavaWebStartInfo.this.stopJWSServices();
                }
                catch (EndpointRegistrationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public void suspend() {
        this.jwsState.transition(JavaWebStartState.Action.SUSPEND, new Runnable(){

            public void run() {
                JavaWebStartInfo.this.suspendJWSServices();
            }
        });
    }

    public void resume() {
        if (this.isJWSRunnable()) {
            this.jwsState.transition(JavaWebStartState.Action.RESUME, new Runnable(){

                public void run() {
                    JavaWebStartInfo.this.resumeJWSServices();
                }
            });
        }
    }

    private void startJWSServices() throws EndpointRegistrationException, IOException {
        if (this.myContent == null) {
            this.processExtensionReferences();
            this.myContent = this.addClientContentToHTTPAdapters();
        }
        for (Content c : this.myContent) {
            c.start();
        }
        this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.started", new Object[]{this.acServerApp.moduleExpression(), JWSAdapterManager.userFriendlyContextRoot(this.acServerApp)});
    }

    private void processExtensionReferences() throws IOException {
        this.tHelper.setProperty(APP_LIBRARY_EXTENSION_PROPERTY_NAME, this.jarElementsForExtensions(this.extensionFileManager.findExtensionTransitiveClosure(new File(this.helper.appClientServerURI(this.dc)), this.dc.getSource().getManifest().getMainAttributes())));
    }

    private String jarElementsForExtensions(Set<ExtensionFileManager.Extension> exts) {
        StringBuilder sb = new StringBuilder();
        for (ExtensionFileManager.Extension e : exts) {
            sb.append("<jar href=" + JWSAdapterManager.publicExtensionHref(e) + "/>");
        }
        return sb.toString();
    }

    private void stopJWSServices() throws EndpointRegistrationException {
        for (Content c : this.myContent) {
            c.stop();
        }
        this.jwsAdapterManager.removeContentForAppClient(this.acServerApp.deployedAppName(), this.acServerApp);
        this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.stopped", this.acServerApp.moduleExpression());
    }

    private void suspendJWSServices() {
        for (Content c : this.myContent) {
            c.suspend();
        }
    }

    private void resumeJWSServices() {
        for (Content c : this.myContent) {
            c.resume();
        }
    }

    private boolean isJWSEnabled(Properties props) {
        boolean result = true;
        String propsSetting = props.getProperty(JAVA_WEB_START_ENABLED_PROPERTY_NAME);
        if (propsSetting != null) {
            result &= Boolean.parseBoolean(propsSetting);
        }
        return result;
    }

    private boolean isJWSEnabled() {
        return this.isJWSEnabledAtApp && this.isJWSEnabledAtModule;
    }

    private boolean isJWSRunnable() {
        if (!this.isJWSEligible) {
            this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.noStart.ineligible", this.acServerApp.moduleExpression());
        }
        if (!this.isJWSEnabled()) {
            this.logger.log(Level.INFO, "enterprise.deployment.appclient.jws.noStart.disabled", this.acServerApp.moduleExpression());
        }
        return this.isJWSEligible && this.isJWSEnabled();
    }

    private Set<Content> addClientContentToHTTPAdapters() throws EndpointRegistrationException, IOException {
        this.initClientStaticContent();
        this.initClientDynamicContent();
        this.dch.addDeveloperContent(this.jnlpDoc);
        HashSet<Content> result = new HashSet<Content>(this.staticContent.values());
        result.addAll(this.dynamicContent.values());
        this.jwsAdapterManager.addContentForAppClient(this.acServerApp.deployedAppName(), this.acServerApp, this.tHelper.tokens(), this.staticContent, this.dynamicContent);
        return result;
    }

    private void initClientStaticContent() throws IOException, EndpointRegistrationException {
        this.createAndAddStaticContent(this.staticContent, this.helper.appClientServerURI(this.dc), this.helper.appClientUserURI(this.dc), CLIENT_JAR_PATH_PROPERTY_NAME);
        this.createAndAddSignedStaticContentFromGeneratedFile(this.staticContent, this.helper.facadeServerURI(this.dc), this.helper.facadeUserURI(this.dc), CLIENT_FACADE_JAR_PATH_PROPERTY_NAME);
        this.addSignedSystemContent(this.staticContent);
        this.prepareImageInfo(this.staticContent, this.tHelper.tokens());
        for (DownloadableArtifacts.FullAndPartURIs artifact : this.helper.earLevelDownloads()) {
            String uriString = artifact.getPart().toASCIIString();
            this.staticContent.put(uriString, new FixedContent(new File(artifact.getFull())));
        }
    }

    private void addSignedSystemContent(Map<String, StaticContent> content) {
        for (SignedSystemContentFromApp signedContentFromApp : SIGNED_SYSTEM_CONTENT_SERVED_AT_APP_LEVEL) {
            AutoSignedContent signedContent = this.jwsAdapterManager.appLevelSignedSystemContent(signedContentFromApp.getRelativePath(), this.jwsAdapterManager.signingAlias(this.dc));
            this.recordStaticContent(content, signedContent, signedContentFromApp.getRelativePathURI(), signedContentFromApp.getTokenName());
        }
    }

    private void createAndAddStaticContent(Map<String, StaticContent> content, URI uriToFile, URI uriForLookup, String tokenName) {
        FixedContent jarContent = new FixedContent(new File(uriToFile));
        this.recordStaticContent(content, jarContent, uriForLookup, tokenName);
    }

    private void createAndAddSignedStaticContentFromGeneratedFile(Map<String, StaticContent> content, URI uriToFile, URI uriForLookup, String tokenName) {
        File unsignedFile = new File(uriToFile);
        File signedFile = this.signedFileForGeneratedAppFile(unsignedFile);
        signedFile.getParentFile().mkdirs();
        AutoSignedContent signedJarContent = new AutoSignedContent(unsignedFile, signedFile, this.jwsAdapterManager.signingAlias(this.dc), this.jarSigner);
        this.recordStaticContent(content, signedJarContent, uriForLookup, tokenName);
    }

    private void recordStaticContent(Map<String, StaticContent> content, StaticContent newContent, URI uriForLookup, String tokenName) {
        String uriStringForLookup = uriForLookup.toASCIIString();
        this.recordStaticContent(content, newContent, uriStringForLookup);
        this.tHelper.setProperty(tokenName, uriForLookup.toASCIIString());
    }

    private void recordStaticContent(Map<String, StaticContent> content, StaticContent newContent, String uriStringForLookup) {
        content.put(uriStringForLookup, newContent);
        this.logger.fine("Recording static content: URI for lookup = " + uriStringForLookup + "; content = " + newContent.toString());
    }

    private File signedFileForGeneratedAppFile(File unsignedFile) {
        File rootForSignedFilesInApp = new File(this.dc.getScratchDir("xml"), "signed/");
        rootForSignedFilesInApp.mkdir();
        URI unsignedFileURIRelativeToXMLDir = this.dc.getScratchDir("xml").toURI().relativize(unsignedFile.toURI());
        URI signedFileURI = rootForSignedFilesInApp.toURI().resolve(unsignedFileURIRelativeToXMLDir);
        return new File(signedFileURI);
    }

    private void initClientDynamicContent() throws IOException {
        this.tHelper.setProperty(APP_CLIENT_MAIN_CLASS_ARGUMENTS_PROPERTY_NAME, "");
        String mainDocument = this.dch.combineJNLP(JavaWebStartInfo.textFromURL(MAIN_DOCUMENT_TEMPLATE));
        this.createAndAddDynamicContentFromTemplateText(this.dynamicContent, this.tHelper.mainJNLP(), mainDocument);
        this.createAndAddDynamicContentFromTemplateText(this.dynamicContent, "", mainDocument);
        this.createAndAddDynamicContent(this.dynamicContent, this.tHelper.clientJNLP(), CLIENT_DOCUMENT_TEMPLATE);
    }

    private void createAndAddDynamicContent(Map<String, DynamicContent> content, String uriStringForContent, String uriStringForTemplate) throws IOException {
        this.createAndAddDynamicContentFromTemplateText(content, uriStringForContent, JavaWebStartInfo.textFromURL(uriStringForTemplate));
    }

    private void createAndAddDynamicContentFromTemplateText(Map<String, DynamicContent> content, String uriStringForContent, String templateText) throws IOException {
        String processedTemplate = Util.replaceTokens(templateText, this.tHelper.tokens());
        content.put(uriStringForContent, JavaWebStartInfo.newDynamicContent(processedTemplate, JNLP_MIME_TYPE));
        this.logger.fine("Adding dyn content " + uriStringForContent + System.getProperty("line.separator") + (this.logger.isLoggable(Level.FINER) ? processedTemplate : ""));
    }

    private static DynamicContent newDynamicContent(String template, String mimeType) {
        return new SimpleDynamicContentImpl(template, mimeType);
    }

    private void prepareImageInfo(Map<String, StaticContent> staticContent, Properties tokens) {
        String splashImageURI;
        StringBuilder result = new StringBuilder();
        VendorInfo vendorInfo = this.getVendorInfo();
        String imageURI = vendorInfo.getImageURI();
        if (imageURI.length() > 0) {
            result.append("<icon href=\"" + imageURI + "\"/>");
            this.addImageContent(imageURI, staticContent);
        }
        if ((splashImageURI = vendorInfo.getSplashImageURI()).length() > 0) {
            result.append("<icon kind=\"splash\" href=\"" + splashImageURI + "\"/>");
            this.addImageContent(splashImageURI, staticContent);
        }
        if (result.length() == 0) {
            result.append("<!-- No image information specified in sun-application-client.xml -->");
        }
        tokens.setProperty(MAIN_IMAGE_XML_PROPERTY_NAME, result.toString());
    }

    private void addImageContent(String imageURI, Map<String, StaticContent> staticContent) {
        FixedContent sc = this.helper.fixedContentWithinEAR(imageURI);
        if (sc != null) {
            staticContent.put(imageURI, sc);
        }
    }

    private VendorInfo getVendorInfo() {
        VendorInfo vendorInfo = new VendorInfo(this.acDesc.getJavaWebStartAccessDescriptor().getVendor());
        return vendorInfo;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            try {
                this.processChangeEventIfInteresting(event);
            }
            catch (Exception e) {
                UnprocessedChangeEvent uce = new UnprocessedChangeEvent(event, e.getLocalizedMessage());
                unprocessedEvents.add(uce);
            }
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }

    private void processChangeEventIfInteresting(PropertyChangeEvent event) throws EndpointRegistrationException {
        Boolean oldEnabledValue;
        String thisAppOrModuleName;
        String eventSourceName;
        boolean isSourceApp = event.getSource() instanceof Application;
        boolean isSourceModule = event.getSource() instanceof Module;
        if (!isSourceApp && !isSourceModule || !(event.getNewValue() instanceof Property)) {
            return;
        }
        Property newPropertySetting = (Property)event.getNewValue();
        if (!newPropertySetting.getName().equals(JAVA_WEB_START_ENABLED_PROPERTY_NAME)) {
            return;
        }
        if (isSourceApp) {
            eventSourceName = ((Application)event.getSource()).getName();
            thisAppOrModuleName = this.acServerApp.registrationName();
        } else {
            eventSourceName = ((Module)event.getSource()).getName();
            thisAppOrModuleName = this.acDesc.getModuleName();
        }
        if (!thisAppOrModuleName.equals(eventSourceName)) {
            return;
        }
        Boolean newEnabledValue = Boolean.valueOf(newPropertySetting.getValue());
        Property oldPropertySetting = (Property)event.getOldValue();
        String oldPropertyValue = oldPropertySetting != null ? oldPropertySetting.getValue() : null;
        Boolean bl = oldEnabledValue = oldPropertyValue == null ? Boolean.TRUE : Boolean.valueOf(oldPropertyValue);
        if (isSourceApp) {
            this.isJWSEnabledAtApp = newEnabledValue;
        } else {
            this.isJWSEnabledAtModule = newEnabledValue;
        }
        if (!newEnabledValue.equals(oldEnabledValue)) {
            if (newEnabledValue.booleanValue()) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    public static String textFromURL(String templateURLString) throws IOException {
        InputStream is = AppClientServerApplication.class.getResourceAsStream(templateURLString);
        if (is == null) {
            throw new FileNotFoundException(templateURLString);
        }
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(is);
        char[] buffer = new char[1024];
        try {
            int charsRead;
            while ((charsRead = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new IOException(templateURLString, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignore) {
                throw new IOException("Error closing template stream after error", ignore);
            }
        }
    }

    private static class SignedSystemContentFromApp {
        private final String tokenName;
        private final String relativePath;

        private SignedSystemContentFromApp(String tokenName, String relativePath) {
            this.tokenName = tokenName;
            this.relativePath = relativePath;
        }

        String getRelativePath() {
            return this.relativePath;
        }

        String getTokenName() {
            return this.tokenName;
        }

        URI getRelativePathURI() {
            return URI.create(this.relativePath);
        }
    }

    private static class VendorInfo {
        private String vendorStringFromDescriptor;
        private String vendor = "";
        private String imageURIString = "";
        private String splashImageURIString = "";

        private VendorInfo(String vendorStringFromDescriptor) {
            this.vendorStringFromDescriptor = vendorStringFromDescriptor != null ? vendorStringFromDescriptor : "";
            String[] parts = this.vendorStringFromDescriptor.split("::");
            if (parts.length == 1) {
                this.vendor = parts[0];
            } else if (parts.length == 2) {
                this.imageURIString = parts[0];
                this.vendor = parts[0];
            } else if (parts.length == 3) {
                this.imageURIString = parts[0];
                this.splashImageURIString = parts[1];
                this.vendor = parts[2];
            }
        }

        private String getVendor() {
            return this.vendor;
        }

        private String getImageURI() {
            return this.imageURIString;
        }

        private String getSplashImageURI() {
            return this.splashImageURIString;
        }
    }
}

